/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.cxxbridge;

import com.facebook.infer.annotation.Assertions;
import com.facebook.react.bridge.JSInstance;
import com.facebook.react.bridge.NativeModule;
import com.facebook.react.bridge.OnBatchCompleteListener;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactMarker;
import com.facebook.react.bridge.ReactMarkerConstants;
import com.facebook.react.cxxbridge.CxxModuleWrapperBase;
import com.facebook.react.cxxbridge.JavaModuleWrapper;
import com.facebook.react.cxxbridge.ModuleHolder;
import com.facebook.systrace.Systrace;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class NativeModuleRegistry {
    private final ReactApplicationContext mReactApplicationContext;
    private final Map<Class<? extends NativeModule>, ModuleHolder> mModules;
    private final ArrayList<ModuleHolder> mBatchCompleteListenerModules;

    public NativeModuleRegistry(ReactApplicationContext reactApplicationContext, Map<Class<? extends NativeModule>, ModuleHolder> modules, ArrayList<ModuleHolder> batchCompleteListenerModules) {
        this.mReactApplicationContext = reactApplicationContext;
        this.mModules = modules;
        this.mBatchCompleteListenerModules = batchCompleteListenerModules;
    }

    Collection<JavaModuleWrapper> getJavaModules(JSInstance jsInstance) {
        ArrayList<JavaModuleWrapper> javaModules = new ArrayList<JavaModuleWrapper>();
        for (Map.Entry<Class<? extends NativeModule>, ModuleHolder> entry : this.mModules.entrySet()) {
            Class<? extends NativeModule> type = entry.getKey();
            if (CxxModuleWrapperBase.class.isAssignableFrom(type)) continue;
            javaModules.add(new JavaModuleWrapper(jsInstance, type, entry.getValue()));
        }
        return javaModules;
    }

    Collection<ModuleHolder> getCxxModules() {
        ArrayList<ModuleHolder> cxxModules = new ArrayList<ModuleHolder>();
        for (Map.Entry<Class<? extends NativeModule>, ModuleHolder> entry : this.mModules.entrySet()) {
            Class<? extends NativeModule> type = entry.getKey();
            if (!CxxModuleWrapperBase.class.isAssignableFrom(type)) continue;
            cxxModules.add(entry.getValue());
        }
        return cxxModules;
    }

    void notifyJSInstanceDestroy() {
        this.mReactApplicationContext.assertOnNativeModulesQueueThread();
        Systrace.beginSection(0L, "NativeModuleRegistry_notifyJSInstanceDestroy");
        try {
            for (ModuleHolder module : this.mModules.values()) {
                module.destroy();
            }
        }
        finally {
            Systrace.endSection(0L);
        }
    }

    void notifyJSInstanceInitialized() {
        this.mReactApplicationContext.assertOnNativeModulesQueueThread("From version React Native v0.44, native modules are explicitly not initialized on the UI thread. See https://github.com/facebook/react-native/wiki/Breaking-Changes#d4611211-reactnativeandroidbreaking-move-nativemodule-initialization-off-ui-thread---aaachiuuu  for more details.");
        ReactMarker.logMarker(ReactMarkerConstants.NATIVE_MODULE_INITIALIZE_START);
        Systrace.beginSection(0L, "NativeModuleRegistry_notifyJSInstanceInitialized");
        try {
            for (ModuleHolder module : this.mModules.values()) {
                module.initialize();
            }
        }
        finally {
            Systrace.endSection(0L);
            ReactMarker.logMarker(ReactMarkerConstants.NATIVE_MODULE_INITIALIZE_END);
        }
    }

    public void onBatchComplete() {
        for (ModuleHolder moduleHolder : this.mBatchCompleteListenerModules) {
            if (!moduleHolder.isInitialized()) continue;
            ((OnBatchCompleteListener)((Object)moduleHolder.getModule())).onBatchComplete();
        }
    }

    public <T extends NativeModule> boolean hasModule(Class<T> moduleInterface) {
        return this.mModules.containsKey(moduleInterface);
    }

    public <T extends NativeModule> T getModule(Class<T> moduleInterface) {
        return (T)((ModuleHolder)Assertions.assertNotNull((Object)this.mModules.get(moduleInterface))).getModule();
    }

    public List<NativeModule> getAllModules() {
        ArrayList<NativeModule> modules = new ArrayList<NativeModule>();
        for (ModuleHolder module : this.mModules.values()) {
            modules.add(module.getModule());
        }
        return modules;
    }
}

