/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.text;

import android.os.Build;
import android.text.BoringLayout;
import android.text.Layout;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.text.style.AbsoluteSizeSpan;
import android.text.style.BackgroundColorSpan;
import android.text.style.ForegroundColorSpan;
import android.text.style.StrikethroughSpan;
import android.text.style.UnderlineSpan;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.bridge.JSApplicationIllegalArgumentException;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.common.annotations.VisibleForTesting;
import com.facebook.react.uimanager.IllegalViewOperationException;
import com.facebook.react.uimanager.LayoutShadowNode;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.ReactShadowNode;
import com.facebook.react.uimanager.UIViewOperationQueue;
import com.facebook.react.uimanager.annotations.ReactProp;
import com.facebook.react.views.text.CustomLineHeightSpan;
import com.facebook.react.views.text.CustomStyleSpan;
import com.facebook.react.views.text.ReactTagSpan;
import com.facebook.react.views.text.ReactTextInlineImageShadowNode;
import com.facebook.react.views.text.ReactTextUpdate;
import com.facebook.react.views.text.ShadowStyleSpan;
import com.facebook.react.views.text.TextInlineImageSpan;
import com.facebook.yoga.YogaConstants;
import com.facebook.yoga.YogaDirection;
import com.facebook.yoga.YogaMeasureFunction;
import com.facebook.yoga.YogaMeasureMode;
import com.facebook.yoga.YogaMeasureOutput;
import com.facebook.yoga.YogaNode;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class ReactTextShadowNode
extends LayoutShadowNode {
    private static final String INLINE_IMAGE_PLACEHOLDER = "I";
    public static final int UNSET = -1;
    @VisibleForTesting
    public static final String PROP_TEXT = "text";
    public static final String PROP_SHADOW_OFFSET = "textShadowOffset";
    public static final String PROP_SHADOW_OFFSET_WIDTH = "width";
    public static final String PROP_SHADOW_OFFSET_HEIGHT = "height";
    public static final String PROP_SHADOW_RADIUS = "textShadowRadius";
    public static final String PROP_SHADOW_COLOR = "textShadowColor";
    public static final int DEFAULT_TEXT_SHADOW_COLOR = 0x55000000;
    private static final TextPaint sTextPaintInstance = new TextPaint(1);
    private final YogaMeasureFunction mTextMeasureFunction = new YogaMeasureFunction(){

        @Override
        public long measure(YogaNode node, float width, YogaMeasureMode widthMode, float height, YogaMeasureMode heightMode) {
            Object layout2;
            boolean unconstrainedWidth;
            TextPaint textPaint = sTextPaintInstance;
            Spanned text = (Spanned)Assertions.assertNotNull((Object)ReactTextShadowNode.this.mPreparedSpannableText, (String)"Spannable element has not been prepared in onBeforeLayout");
            BoringLayout.Metrics boring = BoringLayout.isBoring((CharSequence)text, (TextPaint)textPaint);
            float desiredWidth = boring == null ? Layout.getDesiredWidth((CharSequence)text, (TextPaint)textPaint) : Float.NaN;
            boolean bl = unconstrainedWidth = widthMode == YogaMeasureMode.UNDEFINED || width < 0.0f;
            if (boring == null && (unconstrainedWidth || !YogaConstants.isUndefined(desiredWidth) && desiredWidth <= width)) {
                int hintWidth = (int)Math.ceil(desiredWidth);
                layout2 = Build.VERSION.SDK_INT < 23 ? new StaticLayout((CharSequence)text, textPaint, hintWidth, Layout.Alignment.ALIGN_NORMAL, 1.0f, 0.0f, true) : StaticLayout.Builder.obtain((CharSequence)text, (int)0, (int)text.length(), (TextPaint)textPaint, (int)hintWidth).setAlignment(Layout.Alignment.ALIGN_NORMAL).setLineSpacing(0.0f, 1.0f).setIncludePad(true).setBreakStrategy(ReactTextShadowNode.this.mTextBreakStrategy).setHyphenationFrequency(1).build();
            } else {
                layout2 = boring != null && (unconstrainedWidth || (float)boring.width <= width) ? BoringLayout.make((CharSequence)text, (TextPaint)textPaint, (int)boring.width, (Layout.Alignment)Layout.Alignment.ALIGN_NORMAL, (float)1.0f, (float)0.0f, (BoringLayout.Metrics)boring, (boolean)true) : (Build.VERSION.SDK_INT < 23 ? new StaticLayout((CharSequence)text, textPaint, (int)width, Layout.Alignment.ALIGN_NORMAL, 1.0f, 0.0f, true) : StaticLayout.Builder.obtain((CharSequence)text, (int)0, (int)text.length(), (TextPaint)textPaint, (int)((int)width)).setAlignment(Layout.Alignment.ALIGN_NORMAL).setLineSpacing(0.0f, 1.0f).setIncludePad(true).setBreakStrategy(ReactTextShadowNode.this.mTextBreakStrategy).setHyphenationFrequency(1).build());
            }
            if (ReactTextShadowNode.this.mNumberOfLines != -1 && ReactTextShadowNode.this.mNumberOfLines < layout2.getLineCount()) {
                return YogaMeasureOutput.make(layout2.getWidth(), layout2.getLineBottom(ReactTextShadowNode.this.mNumberOfLines - 1));
            }
            return YogaMeasureOutput.make(layout2.getWidth(), layout2.getHeight());
        }
    };
    private float mLineHeight = Float.NaN;
    private boolean mIsColorSet = false;
    private boolean mAllowFontScaling = true;
    private int mColor;
    private boolean mIsBackgroundColorSet = false;
    private int mBackgroundColor;
    protected int mNumberOfLines = -1;
    protected int mFontSize = -1;
    protected float mFontSizeInput = -1.0f;
    protected int mLineHeightInput = -1;
    protected int mTextAlign = 0;
    protected int mTextBreakStrategy = Build.VERSION.SDK_INT < 23 ? 0 : 1;
    private float mTextShadowOffsetDx = 0.0f;
    private float mTextShadowOffsetDy = 0.0f;
    private float mTextShadowRadius = 1.0f;
    private int mTextShadowColor = 0x55000000;
    private boolean mIsUnderlineTextDecorationSet = false;
    private boolean mIsLineThroughTextDecorationSet = false;
    private int mFontStyle = -1;
    private int mFontWeight = -1;
    @Nullable
    private String mFontFamily = null;
    @Nullable
    private String mText = null;
    @Nullable
    private Spannable mPreparedSpannableText;
    protected boolean mContainsImages = false;
    private float mHeightOfTallestInlineImage = Float.NaN;

    private static void buildSpannedFromTextCSSNode(ReactTextShadowNode textShadowNode, SpannableStringBuilder sb, List<SetSpanOperation> ops) {
        int start = sb.length();
        if (textShadowNode.mText != null) {
            sb.append((CharSequence)textShadowNode.mText);
        }
        int length = textShadowNode.getChildCount();
        for (int i = 0; i < length; ++i) {
            ReactShadowNode child = textShadowNode.getChildAt(i);
            if (child instanceof ReactTextShadowNode) {
                ReactTextShadowNode.buildSpannedFromTextCSSNode((ReactTextShadowNode)child, sb, ops);
            } else if (child instanceof ReactTextInlineImageShadowNode) {
                sb.append((CharSequence)INLINE_IMAGE_PLACEHOLDER);
                ops.add(new SetSpanOperation(sb.length() - INLINE_IMAGE_PLACEHOLDER.length(), sb.length(), (Object)((ReactTextInlineImageShadowNode)child).buildInlineImageSpan()));
            } else {
                throw new IllegalViewOperationException("Unexpected view type nested under text node: " + child.getClass());
            }
            child.markUpdateSeen();
        }
        int end = sb.length();
        if (end >= start) {
            if (textShadowNode.mIsColorSet) {
                ops.add(new SetSpanOperation(start, end, new ForegroundColorSpan(textShadowNode.mColor)));
            }
            if (textShadowNode.mIsBackgroundColorSet) {
                ops.add(new SetSpanOperation(start, end, new BackgroundColorSpan(textShadowNode.mBackgroundColor)));
            }
            if (textShadowNode.mFontSize != -1) {
                ops.add(new SetSpanOperation(start, end, new AbsoluteSizeSpan(textShadowNode.mFontSize)));
            }
            if (textShadowNode.mFontStyle != -1 || textShadowNode.mFontWeight != -1 || textShadowNode.mFontFamily != null) {
                ops.add(new SetSpanOperation(start, end, (Object)new CustomStyleSpan(textShadowNode.mFontStyle, textShadowNode.mFontWeight, textShadowNode.mFontFamily, textShadowNode.getThemedContext().getAssets())));
            }
            if (textShadowNode.mIsUnderlineTextDecorationSet) {
                ops.add(new SetSpanOperation(start, end, new UnderlineSpan()));
            }
            if (textShadowNode.mIsLineThroughTextDecorationSet) {
                ops.add(new SetSpanOperation(start, end, new StrikethroughSpan()));
            }
            if (textShadowNode.mTextShadowOffsetDx != 0.0f || textShadowNode.mTextShadowOffsetDy != 0.0f) {
                ops.add(new SetSpanOperation(start, end, (Object)new ShadowStyleSpan(textShadowNode.mTextShadowOffsetDx, textShadowNode.mTextShadowOffsetDy, textShadowNode.mTextShadowRadius, textShadowNode.mTextShadowColor)));
            }
            if (!Float.isNaN(textShadowNode.getEffectiveLineHeight())) {
                ops.add(new SetSpanOperation(start, end, new CustomLineHeightSpan(textShadowNode.getEffectiveLineHeight())));
            }
            ops.add(new SetSpanOperation(start, end, new ReactTagSpan(textShadowNode.getReactTag())));
        }
    }

    protected static Spannable fromTextCSSNode(ReactTextShadowNode textCSSNode) {
        SpannableStringBuilder sb = new SpannableStringBuilder();
        ArrayList<SetSpanOperation> ops = new ArrayList<SetSpanOperation>();
        ReactTextShadowNode.buildSpannedFromTextCSSNode(textCSSNode, sb, ops);
        if (textCSSNode.mFontSize == -1) {
            sb.setSpan((Object)new AbsoluteSizeSpan(textCSSNode.mAllowFontScaling ? (int)Math.ceil(PixelUtil.toPixelFromSP(14.0f)) : (int)Math.ceil(PixelUtil.toPixelFromDIP(14.0f))), 0, sb.length(), 17);
        }
        textCSSNode.mContainsImages = false;
        textCSSNode.mHeightOfTallestInlineImage = Float.NaN;
        for (int i = ops.size() - 1; i >= 0; --i) {
            SetSpanOperation op = (SetSpanOperation)ops.get(i);
            if (op.what instanceof TextInlineImageSpan) {
                int height = ((TextInlineImageSpan)((Object)op.what)).getHeight();
                textCSSNode.mContainsImages = true;
                if (Float.isNaN(textCSSNode.mHeightOfTallestInlineImage) || (float)height > textCSSNode.mHeightOfTallestInlineImage) {
                    textCSSNode.mHeightOfTallestInlineImage = height;
                }
            }
            op.execute(sb);
        }
        return sb;
    }

    private static int parseNumericFontWeight(String fontWeightString) {
        return fontWeightString.length() == 3 && fontWeightString.endsWith("00") && fontWeightString.charAt(0) <= '9' && fontWeightString.charAt(0) >= '1' ? 100 * (fontWeightString.charAt(0) - 48) : -1;
    }

    public ReactTextShadowNode() {
        if (!this.isVirtual()) {
            this.setMeasureFunction(this.mTextMeasureFunction);
        }
    }

    public float getEffectiveLineHeight() {
        boolean useInlineViewHeight = !Float.isNaN(this.mLineHeight) && !Float.isNaN(this.mHeightOfTallestInlineImage) && this.mHeightOfTallestInlineImage > this.mLineHeight;
        return useInlineViewHeight ? this.mHeightOfTallestInlineImage : this.mLineHeight;
    }

    private int getTextAlign() {
        int textAlign = this.mTextAlign;
        if (this.getLayoutDirection() == YogaDirection.RTL) {
            if (textAlign == 5) {
                textAlign = 3;
            } else if (textAlign == 3) {
                textAlign = 5;
            }
        }
        return textAlign;
    }

    @Override
    public void onBeforeLayout() {
        if (this.isVirtual()) {
            return;
        }
        this.mPreparedSpannableText = ReactTextShadowNode.fromTextCSSNode(this);
        this.markUpdated();
    }

    @Override
    public void markUpdated() {
        super.markUpdated();
        if (!this.isVirtual()) {
            super.dirty();
        }
    }

    @ReactProp(name="text")
    public void setText(@Nullable String text) {
        this.mText = text;
        this.markUpdated();
    }

    @ReactProp(name="numberOfLines", defaultInt=-1)
    public void setNumberOfLines(int numberOfLines) {
        this.mNumberOfLines = numberOfLines == 0 ? -1 : numberOfLines;
        this.markUpdated();
    }

    @ReactProp(name="lineHeight", defaultInt=-1)
    public void setLineHeight(int lineHeight) {
        this.mLineHeightInput = lineHeight;
        this.mLineHeight = lineHeight == -1 ? Float.NaN : (this.mAllowFontScaling ? PixelUtil.toPixelFromSP(lineHeight) : PixelUtil.toPixelFromDIP(lineHeight));
        this.markUpdated();
    }

    @ReactProp(name="allowFontScaling", defaultBoolean=true)
    public void setAllowFontScaling(boolean allowFontScaling) {
        if (allowFontScaling != this.mAllowFontScaling) {
            this.mAllowFontScaling = allowFontScaling;
            this.setFontSize(this.mFontSizeInput);
            this.setLineHeight(this.mLineHeightInput);
            this.markUpdated();
        }
    }

    @ReactProp(name="textAlign")
    public void setTextAlign(@Nullable String textAlign) {
        if (textAlign == null || "auto".equals(textAlign)) {
            this.mTextAlign = 0;
        } else if ("left".equals(textAlign)) {
            this.mTextAlign = 3;
        } else if ("right".equals(textAlign)) {
            this.mTextAlign = 5;
        } else if ("center".equals(textAlign)) {
            this.mTextAlign = 1;
        } else if ("justify".equals(textAlign)) {
            this.mTextAlign = 3;
        } else {
            throw new JSApplicationIllegalArgumentException("Invalid textAlign: " + textAlign);
        }
        this.markUpdated();
    }

    @ReactProp(name="fontSize", defaultFloat=-1.0f)
    public void setFontSize(float fontSize) {
        this.mFontSizeInput = fontSize;
        if (fontSize != -1.0f) {
            fontSize = this.mAllowFontScaling ? (float)Math.ceil(PixelUtil.toPixelFromSP(fontSize)) : (float)Math.ceil(PixelUtil.toPixelFromDIP(fontSize));
        }
        this.mFontSize = (int)fontSize;
        this.markUpdated();
    }

    @ReactProp(name="color")
    public void setColor(@Nullable Integer color) {
        boolean bl = this.mIsColorSet = color != null;
        if (this.mIsColorSet) {
            this.mColor = color;
        }
        this.markUpdated();
    }

    @ReactProp(name="backgroundColor")
    public void setBackgroundColor(Integer color) {
        if (!this.isVirtualAnchor()) {
            boolean bl = this.mIsBackgroundColorSet = color != null;
            if (this.mIsBackgroundColorSet) {
                this.mBackgroundColor = color;
            }
            this.markUpdated();
        }
    }

    @ReactProp(name="fontFamily")
    public void setFontFamily(@Nullable String fontFamily) {
        this.mFontFamily = fontFamily;
        this.markUpdated();
    }

    @ReactProp(name="fontWeight")
    public void setFontWeight(@Nullable String fontWeightString) {
        int fontWeightNumeric = fontWeightString != null ? ReactTextShadowNode.parseNumericFontWeight(fontWeightString) : -1;
        int fontWeight = -1;
        if (fontWeightNumeric >= 500 || "bold".equals(fontWeightString)) {
            fontWeight = 1;
        } else if ("normal".equals(fontWeightString) || fontWeightNumeric != -1 && fontWeightNumeric < 500) {
            fontWeight = 0;
        }
        if (fontWeight != this.mFontWeight) {
            this.mFontWeight = fontWeight;
            this.markUpdated();
        }
    }

    @ReactProp(name="fontStyle")
    public void setFontStyle(@Nullable String fontStyleString) {
        int fontStyle = -1;
        if ("italic".equals(fontStyleString)) {
            fontStyle = 2;
        } else if ("normal".equals(fontStyleString)) {
            fontStyle = 0;
        }
        if (fontStyle != this.mFontStyle) {
            this.mFontStyle = fontStyle;
            this.markUpdated();
        }
    }

    @ReactProp(name="textDecorationLine")
    public void setTextDecorationLine(@Nullable String textDecorationLineString) {
        this.mIsUnderlineTextDecorationSet = false;
        this.mIsLineThroughTextDecorationSet = false;
        if (textDecorationLineString != null) {
            for (String textDecorationLineSubString : textDecorationLineString.split(" ")) {
                if ("underline".equals(textDecorationLineSubString)) {
                    this.mIsUnderlineTextDecorationSet = true;
                    continue;
                }
                if (!"line-through".equals(textDecorationLineSubString)) continue;
                this.mIsLineThroughTextDecorationSet = true;
            }
        }
        this.markUpdated();
    }

    @ReactProp(name="textBreakStrategy")
    public void setTextBreakStrategy(@Nullable String textBreakStrategy) {
        if (Build.VERSION.SDK_INT < 23) {
            return;
        }
        if (textBreakStrategy == null || "highQuality".equals(textBreakStrategy)) {
            this.mTextBreakStrategy = 1;
        } else if ("simple".equals(textBreakStrategy)) {
            this.mTextBreakStrategy = 0;
        } else if ("balanced".equals(textBreakStrategy)) {
            this.mTextBreakStrategy = 2;
        } else {
            throw new JSApplicationIllegalArgumentException("Invalid textBreakStrategy: " + textBreakStrategy);
        }
        this.markUpdated();
    }

    @ReactProp(name="textShadowOffset")
    public void setTextShadowOffset(ReadableMap offsetMap) {
        this.mTextShadowOffsetDx = 0.0f;
        this.mTextShadowOffsetDy = 0.0f;
        if (offsetMap != null) {
            if (offsetMap.hasKey(PROP_SHADOW_OFFSET_WIDTH) && !offsetMap.isNull(PROP_SHADOW_OFFSET_WIDTH)) {
                this.mTextShadowOffsetDx = PixelUtil.toPixelFromDIP(offsetMap.getDouble(PROP_SHADOW_OFFSET_WIDTH));
            }
            if (offsetMap.hasKey(PROP_SHADOW_OFFSET_HEIGHT) && !offsetMap.isNull(PROP_SHADOW_OFFSET_HEIGHT)) {
                this.mTextShadowOffsetDy = PixelUtil.toPixelFromDIP(offsetMap.getDouble(PROP_SHADOW_OFFSET_HEIGHT));
            }
        }
        this.markUpdated();
    }

    @ReactProp(name="textShadowRadius", defaultInt=1)
    public void setTextShadowRadius(float textShadowRadius) {
        if (textShadowRadius != this.mTextShadowRadius) {
            this.mTextShadowRadius = textShadowRadius;
            this.markUpdated();
        }
    }

    @ReactProp(name="textShadowColor", defaultInt=0x55000000, customType="Color")
    public void setTextShadowColor(int textShadowColor) {
        if (textShadowColor != this.mTextShadowColor) {
            this.mTextShadowColor = textShadowColor;
            this.markUpdated();
        }
    }

    @Override
    public boolean isVirtualAnchor() {
        return !this.isVirtual();
    }

    @Override
    public void onCollectExtraUpdates(UIViewOperationQueue uiViewOperationQueue) {
        if (this.isVirtual()) {
            return;
        }
        super.onCollectExtraUpdates(uiViewOperationQueue);
        if (this.mPreparedSpannableText != null) {
            ReactTextUpdate reactTextUpdate = new ReactTextUpdate(this.mPreparedSpannableText, -1, this.mContainsImages, this.getPadding(4), this.getPadding(1), this.getPadding(5), this.getPadding(3), this.getTextAlign(), this.mTextBreakStrategy);
            uiViewOperationQueue.enqueueUpdateExtraData(this.getReactTag(), reactTextUpdate);
        }
    }

    private static class SetSpanOperation {
        protected int start;
        protected int end;
        protected Object what;

        SetSpanOperation(int start, int end, Object what) {
            this.start = start;
            this.end = end;
            this.what = what;
        }

        public void execute(SpannableStringBuilder sb) {
            int spanFlags = 34;
            if (this.start == 0) {
                spanFlags = 18;
            }
            sb.setSpan(this.what, this.start, this.end, spanFlags);
        }
    }
}

