/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.common;

import android.graphics.Bitmap;
import com.facebook.imagepipeline.common.ImageDecodeOptionsBuilder;
import java.util.Locale;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ImageDecodeOptions {
    private static final ImageDecodeOptions DEFAULTS = ImageDecodeOptions.newBuilder().build();
    public final int minDecodeIntervalMs;
    public final boolean decodePreviewFrame;
    public final boolean useLastFrameForPreview;
    public final boolean decodeAllFrames;
    public final boolean forceStaticImage;
    public final Bitmap.Config bitmapConfig;

    public ImageDecodeOptions(ImageDecodeOptionsBuilder b) {
        this.minDecodeIntervalMs = b.getMinDecodeIntervalMs();
        this.decodePreviewFrame = b.getDecodePreviewFrame();
        this.useLastFrameForPreview = b.getUseLastFrameForPreview();
        this.decodeAllFrames = b.getDecodeAllFrames();
        this.forceStaticImage = b.getForceStaticImage();
        this.bitmapConfig = b.getBitmapConfig();
    }

    public static ImageDecodeOptions defaults() {
        return DEFAULTS;
    }

    public static ImageDecodeOptionsBuilder newBuilder() {
        return new ImageDecodeOptionsBuilder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImageDecodeOptions that = (ImageDecodeOptions)o;
        if (this.decodePreviewFrame != that.decodePreviewFrame) {
            return false;
        }
        if (this.useLastFrameForPreview != that.useLastFrameForPreview) {
            return false;
        }
        if (this.decodeAllFrames != that.decodeAllFrames) {
            return false;
        }
        if (this.forceStaticImage != that.forceStaticImage) {
            return false;
        }
        return this.bitmapConfig == that.bitmapConfig;
    }

    public int hashCode() {
        int result = this.minDecodeIntervalMs;
        result = 31 * result + (this.decodePreviewFrame ? 1 : 0);
        result = 31 * result + (this.useLastFrameForPreview ? 1 : 0);
        result = 31 * result + (this.decodeAllFrames ? 1 : 0);
        result = 31 * result + (this.forceStaticImage ? 1 : 0);
        result = 31 * result + this.bitmapConfig.ordinal();
        return result;
    }

    public String toString() {
        return String.format((Locale)null, "%d-%b-%b-%b-%b-%s", this.minDecodeIntervalMs, this.decodePreviewFrame, this.useLastFrameForPreview, this.decodeAllFrames, this.forceStaticImage, this.bitmapConfig.name());
    }
}

