/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.cxxbridge;

import com.facebook.infer.annotation.Assertions;
import com.facebook.react.bridge.NativeModule;
import com.facebook.react.bridge.ReactMarker;
import com.facebook.react.common.futures.SimpleSettableFuture;
import com.facebook.react.cxxbridge.CxxModuleWrapper;
import com.facebook.react.cxxbridge.SoftAssertions;
import com.facebook.react.cxxbridge.UiThreadUtil;
import com.facebook.systrace.Systrace;
import com.facebook.systrace.SystraceMessage;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;
import javax.inject.Provider;

public class ModuleHolder {
    private final String mName;
    private final boolean mCanOverrideExistingModule;
    private final boolean mSupportsWebWorkers;
    @Nullable
    private Provider<? extends NativeModule> mProvider;
    @Nullable
    private NativeModule mModule;
    private boolean mInitializeNeeded;

    public ModuleHolder(String name, boolean canOverrideExistingModule, boolean supportsWebWorkers, boolean needsEagerInit, Provider<? extends NativeModule> provider) {
        this.mName = name;
        this.mCanOverrideExistingModule = canOverrideExistingModule;
        this.mSupportsWebWorkers = supportsWebWorkers;
        this.mProvider = provider;
        if (needsEagerInit) {
            this.mModule = this.create();
        }
    }

    public ModuleHolder(NativeModule nativeModule) {
        this.mName = nativeModule.getName();
        this.mCanOverrideExistingModule = nativeModule.canOverrideExistingModule();
        this.mSupportsWebWorkers = nativeModule.supportsWebWorkers();
        this.mModule = nativeModule;
    }

    public synchronized void initialize() {
        if (this.mModule != null) {
            this.doInitialize(this.mModule);
        } else {
            this.mInitializeNeeded = true;
        }
    }

    public synchronized boolean isInitialized() {
        return this.mModule != null;
    }

    public synchronized void destroy() {
        if (this.mModule != null) {
            this.mModule.onCatalystInstanceDestroy();
        }
    }

    public String getName() {
        return this.mName;
    }

    public boolean getCanOverrideExistingModule() {
        return this.mCanOverrideExistingModule;
    }

    public boolean getSupportsWebWorkers() {
        return this.mSupportsWebWorkers;
    }

    public synchronized NativeModule getModule() {
        if (this.mModule == null) {
            this.mModule = this.create();
        }
        return this.mModule;
    }

    private NativeModule create() {
        SoftAssertions.assertCondition(this.mModule == null, "Creating an already created module.");
        ReactMarker.logMarker("CREATE_MODULE_START", this.mName);
        SystraceMessage.beginSection(0L, "createModule").arg("name", this.mName).flush();
        NativeModule module = (NativeModule)((Provider)Assertions.assertNotNull(this.mProvider)).get();
        this.mProvider = null;
        if (this.mInitializeNeeded) {
            this.doInitialize(module);
            this.mInitializeNeeded = false;
        }
        Systrace.endSection(0L);
        ReactMarker.logMarker("CREATE_MODULE_END");
        return module;
    }

    private void doInitialize(NativeModule module) {
        SystraceMessage.Builder section = SystraceMessage.beginSection(0L, "initialize");
        if (module instanceof CxxModuleWrapper) {
            section.arg("className", module.getClass().getSimpleName());
        } else {
            section.arg("name", this.mName);
        }
        section.flush();
        ModuleHolder.callInitializeOnUiThread(module);
        Systrace.endSection(0L);
    }

    private static void callInitializeOnUiThread(final NativeModule module) {
        if (UiThreadUtil.isOnUiThread()) {
            module.initialize();
            return;
        }
        final SimpleSettableFuture future = new SimpleSettableFuture();
        UiThreadUtil.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                Systrace.beginSection(0L, "initializeOnUiThread");
                try {
                    module.initialize();
                    future.set(null);
                }
                catch (Exception e) {
                    future.setException(e);
                }
                Systrace.endSection(0L);
            }
        });
        try {
            future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }
}

