/*
 * Decompiled with CFR 0.152.
 */
package com.reactnativecomponent.swiperefreshlayout;

import android.content.Context;
import android.support.annotation.Nullable;
import com.facebook.react.common.MapBuilder;
import com.facebook.react.common.SystemClock;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.UIManagerModule;
import com.facebook.react.uimanager.ViewGroupManager;
import com.facebook.react.uimanager.annotations.ReactProp;
import com.facebook.react.uimanager.events.Event;
import com.reactnativecomponent.swiperefreshlayout.RCTSwipeRefreshLayout;
import com.reactnativecomponent.swiperefreshlayout.TouchEvent;
import com.reactnativecomponent.swiperefreshlayout.TouchUpEvent;
import java.util.Map;

public class RCTSwipeRefreshLayoutManager
extends ViewGroupManager<RCTSwipeRefreshLayout> {
    public String getName() {
        return "RCTSwipeRefreshLayout";
    }

    @ReactProp(name="refreshing", defaultBoolean=false)
    public void setRefresh(RCTSwipeRefreshLayout view, @Nullable boolean enabled) {
        view.setRefreshing(enabled);
    }

    @ReactProp(name="enabledPullUp", defaultBoolean=true)
    public void setEnabledPullUp(RCTSwipeRefreshLayout view, @Nullable boolean enabled) {
        view.setEnabledPullUp(enabled);
    }

    @ReactProp(name="enabledPullDown", defaultBoolean=true)
    public void setEnalbedPullDown(RCTSwipeRefreshLayout view, @Nullable boolean enabled) {
        view.setEnalbedPullDown(enabled);
    }

    protected RCTSwipeRefreshLayout createViewInstance(ThemedReactContext reactContext) {
        return new RCTSwipeRefreshLayout((Context)reactContext);
    }

    protected void addEventEmitters(final ThemedReactContext reactContext, final RCTSwipeRefreshLayout view) {
        view.setOnEvTouchListener(new RCTSwipeRefreshLayout.OnEvTouchListener(){

            @Override
            public void onSwipe(int movement) {
                ((UIManagerModule)reactContext.getNativeModule(UIManagerModule.class)).getEventDispatcher().dispatchEvent((Event)new TouchEvent(view.getId(), SystemClock.nanoTime(), movement));
            }

            @Override
            public void onSwipeRefresh() {
                ((UIManagerModule)reactContext.getNativeModule(UIManagerModule.class)).getEventDispatcher().dispatchEvent((Event)new TouchUpEvent(view.getId(), SystemClock.nanoTime()));
            }
        });
    }

    public Map<String, Object> getExportedCustomDirectEventTypeConstants() {
        return MapBuilder.builder().put((Object)"RCTSwipeRefreshLayout.TouchMove", (Object)MapBuilder.of((Object)"registrationName", (Object)"onSwipe")).put((Object)"RCTSwipeRefreshLayout.TouchUp", (Object)MapBuilder.of((Object)"registrationName", (Object)"onSwipeRefresh")).build();
    }
}

