/*
 * Decompiled with CFR 0.152.
 */
package com.reactnativecomponent.swiperefreshlayout;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.v4.view.MotionEventCompat;
import android.support.v4.view.NestedScrollingChild;
import android.support.v4.view.NestedScrollingChildHelper;
import android.support.v4.view.NestedScrollingParent;
import android.support.v4.view.NestedScrollingParentHelper;
import android.support.v4.view.ViewCompat;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.widget.ScrollView;

public class RCTSwipeRefreshLayout
extends ViewGroup
implements NestedScrollingParent,
NestedScrollingChild {
    private static final String LOG_TAG = RCTSwipeRefreshLayout.class.getSimpleName();
    private static final int INVALID_POINTER = -1;
    private static final float DRAG_RATE = 0.5f;
    private View mTarget;
    private OnEvTouchListener mTouchListener;
    private boolean mRefreshing = false;
    private boolean enabledPullUp = true;
    private boolean enabledPullDown = true;
    private int mTouchSlop;
    private float mPrevTouchX;
    private boolean mIntercepted;
    private float mTotalUnconsumed;
    private final NestedScrollingParentHelper mNestedScrollingParentHelper;
    private final NestedScrollingChildHelper mNestedScrollingChildHelper;
    private final int[] mParentScrollConsumed = new int[2];
    private final int[] mParentOffsetInWindow = new int[2];
    private float mInitialDownY;
    private boolean mIsBeingDragged;
    private int mActivePointerId = -1;
    private boolean mReturningToStart;
    private static final int[] LAYOUT_ATTRS = new int[]{0x101000E};
    private float mLastMargin;
    private float mMoveMargin;
    private float density;
    private int moveDirection = 0;

    public RCTSwipeRefreshLayout(Context context) {
        this(context, null);
        DisplayMetrics dm = new DisplayMetrics();
        this.density = context.getResources().getDisplayMetrics().density;
        ViewCompat.setChildrenDrawingOrderEnabled((ViewGroup)this, (boolean)true);
        DisplayMetrics metrics = this.getResources().getDisplayMetrics();
        this.setNestedScrollingEnabled(true);
    }

    public RCTSwipeRefreshLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mTouchSlop = ViewConfiguration.get((Context)context).getScaledTouchSlop();
        this.setWillNotDraw(false);
        TypedArray a = context.obtainStyledAttributes(attrs, LAYOUT_ATTRS);
        this.setEnabled(a.getBoolean(0, true));
        a.recycle();
        this.density = context.getResources().getDisplayMetrics().density;
        ViewCompat.setChildrenDrawingOrderEnabled((ViewGroup)this, (boolean)true);
        this.mNestedScrollingParentHelper = new NestedScrollingParentHelper((ViewGroup)this);
        this.mNestedScrollingChildHelper = new NestedScrollingChildHelper((View)this);
        this.setNestedScrollingEnabled(true);
    }

    public void setOnEvTouchListener(OnEvTouchListener mTouchListener) {
        this.mTouchListener = mTouchListener;
    }

    private void ensureTarget() {
        block0: {
            View child;
            int i;
            if (this.mTarget != null || (i = 0) >= this.getChildCount()) break block0;
            this.mTarget = child = this.getChildAt(0);
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
    }

    public void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.mTarget == null) {
            this.ensureTarget();
        }
        if (this.mTarget == null) {
            return;
        }
        this.mTarget.measure(View.MeasureSpec.makeMeasureSpec((int)(this.getMeasuredWidth() - this.getPaddingLeft() - this.getPaddingRight()), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)(this.getMeasuredHeight() - this.getPaddingTop() - this.getPaddingBottom()), (int)0x40000000));
    }

    public boolean canChildScrollUp(float f) {
        boolean flag = false;
        if (!this.mRefreshing) {
            if (this.mTarget instanceof ScrollView) {
                ScrollView scrollView = (ScrollView)this.mTarget;
                int scrollY = scrollView.getScrollY();
                int height = scrollView.getHeight();
                int scrollViewMeasuredHeight = scrollView.getChildAt(0).getMeasuredHeight();
                flag = this.enabledPullDown && scrollY == 0 && f > 0.0f ? false : !this.enabledPullUp || scrollY + height < scrollViewMeasuredHeight || !(f < 0.0f);
            }
        } else {
            flag = true;
        }
        return flag;
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        this.ensureTarget();
        int action = MotionEventCompat.getActionMasked((MotionEvent)ev);
        if (this.mReturningToStart && action == 0) {
            this.mReturningToStart = false;
        }
        switch (action) {
            case 0: {
                this.mActivePointerId = MotionEventCompat.getPointerId((MotionEvent)ev, (int)0);
                this.mIsBeingDragged = false;
                float initialDownY = this.getMotionEventY(ev, this.mActivePointerId);
                if (initialDownY == -1.0f) {
                    return false;
                }
                this.mInitialDownY = initialDownY;
                break;
            }
            case 2: {
                if (this.mActivePointerId == -1) {
                    return false;
                }
                float y = ev.getY();
                if (y == -1.0f) {
                    return false;
                }
                float yDiff = (y - this.mInitialDownY) * 0.5f;
                if (!(yDiff > (float)this.mTouchSlop) && !(yDiff < (float)(-this.mTouchSlop))) break;
                this.mIsBeingDragged = !this.canChildScrollUp(yDiff);
                return this.mIsBeingDragged;
            }
            case 1: 
            case 3: {
                this.mIsBeingDragged = false;
                this.mActivePointerId = -1;
            }
        }
        return this.mIsBeingDragged;
    }

    private boolean shouldInterceptTouchEvent(MotionEvent ev) {
        switch (ev.getAction()) {
            case 0: {
                this.mPrevTouchX = ev.getX();
                this.mIntercepted = false;
                break;
            }
            case 2: {
                float eventX = ev.getX();
                float xDiff = Math.abs(eventX - this.mPrevTouchX);
                if (!this.mIntercepted && !(xDiff > (float)this.mTouchSlop)) break;
                this.mIntercepted = true;
                return false;
            }
        }
        return true;
    }

    private float getMotionEventY(MotionEvent ev, int activePointerId) {
        int index = MotionEventCompat.findPointerIndex((MotionEvent)ev, (int)activePointerId);
        if (index < 0) {
            return -1.0f;
        }
        return MotionEventCompat.getY((MotionEvent)ev, (int)index);
    }

    public void requestDisallowInterceptTouchEvent(boolean disallowIntercept) {
        if (this.getParent() != null) {
            this.getParent().requestDisallowInterceptTouchEvent(disallowIntercept);
        }
    }

    public boolean onStartNestedScroll(View child, View target, int nestedScrollAxes) {
        return this.isEnabled() && !this.mReturningToStart && (nestedScrollAxes & 2) != 0;
    }

    public void onNestedScrollAccepted(View child, View target, int axes) {
        this.mNestedScrollingParentHelper.onNestedScrollAccepted(child, target, axes);
        this.startNestedScroll(axes & 2);
        this.mTotalUnconsumed = 0.0f;
    }

    public void onNestedPreScroll(View target, int dx, int dy, int[] consumed) {
        int[] parentConsumed;
        if (dy > 0 && this.mTotalUnconsumed > 0.0f) {
            if ((float)dy > this.mTotalUnconsumed) {
                consumed[1] = dy - (int)this.mTotalUnconsumed;
                this.mTotalUnconsumed = 0.0f;
            } else {
                this.mTotalUnconsumed -= (float)dy;
                consumed[1] = dy;
            }
        }
        if (this.dispatchNestedPreScroll(dx - consumed[0], dy - consumed[1], parentConsumed = this.mParentScrollConsumed, null)) {
            consumed[0] = consumed[0] + parentConsumed[0];
            consumed[1] = consumed[1] + parentConsumed[1];
        }
    }

    public int getNestedScrollAxes() {
        return this.mNestedScrollingParentHelper.getNestedScrollAxes();
    }

    public void onStopNestedScroll(View target) {
        this.mNestedScrollingParentHelper.onStopNestedScroll(target);
        if (this.mTotalUnconsumed > 0.0f) {
            this.mTotalUnconsumed = 0.0f;
        }
        this.stopNestedScroll();
    }

    public void onNestedScroll(View target, int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed) {
        this.dispatchNestedScroll(dxConsumed, dyConsumed, dxUnconsumed, dyUnconsumed, this.mParentOffsetInWindow);
        int dy = dyUnconsumed + this.mParentOffsetInWindow[1];
        if (dy < 0) {
            this.mTotalUnconsumed += (float)Math.abs(dy);
        }
    }

    public void setNestedScrollingEnabled(boolean enabled) {
        this.mNestedScrollingChildHelper.setNestedScrollingEnabled(enabled);
    }

    public boolean isNestedScrollingEnabled() {
        return this.mNestedScrollingChildHelper.isNestedScrollingEnabled();
    }

    public boolean startNestedScroll(int axes) {
        return this.mNestedScrollingChildHelper.startNestedScroll(axes);
    }

    public void stopNestedScroll() {
        this.mNestedScrollingChildHelper.stopNestedScroll();
    }

    public boolean hasNestedScrollingParent() {
        return this.mNestedScrollingChildHelper.hasNestedScrollingParent();
    }

    public boolean dispatchNestedScroll(int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed, int[] offsetInWindow) {
        return this.mNestedScrollingChildHelper.dispatchNestedScroll(dxConsumed, dyConsumed, dxUnconsumed, dyUnconsumed, offsetInWindow);
    }

    public boolean dispatchNestedPreScroll(int dx, int dy, int[] consumed, int[] offsetInWindow) {
        return this.mNestedScrollingChildHelper.dispatchNestedPreScroll(dx, dy, consumed, offsetInWindow);
    }

    public boolean onNestedPreFling(View target, float velocityX, float velocityY) {
        return this.dispatchNestedPreFling(velocityX, velocityY);
    }

    public boolean onNestedFling(View target, float velocityX, float velocityY, boolean consumed) {
        return this.dispatchNestedFling(velocityX, velocityY, consumed);
    }

    public boolean dispatchNestedFling(float velocityX, float velocityY, boolean consumed) {
        return this.mNestedScrollingChildHelper.dispatchNestedFling(velocityX, velocityY, consumed);
    }

    public boolean dispatchNestedPreFling(float velocityX, float velocityY) {
        return this.mNestedScrollingChildHelper.dispatchNestedPreFling(velocityX, velocityY);
    }

    public boolean onTouchEvent(MotionEvent ev) {
        int action = MotionEventCompat.getActionMasked((MotionEvent)ev);
        int pointerIndex = -1;
        if (this.mReturningToStart && action == 0) {
            this.mReturningToStart = false;
        }
        switch (action) {
            case 0: {
                break;
            }
            case 2: {
                if (this.mTarget == null) break;
                pointerIndex = MotionEventCompat.findPointerIndex((MotionEvent)ev, (int)this.mActivePointerId);
                if (pointerIndex < 0) {
                    return false;
                }
                if (pointerIndex != this.mActivePointerId) {
                    return true;
                }
                float y = MotionEventCompat.getY((MotionEvent)ev, (int)pointerIndex);
                float overscrollTop = (y - this.mInitialDownY) * 0.5f;
                if (this.mMoveMargin == 0.0f) {
                    if (this.moveDirection == 0) {
                        this.mMoveMargin = overscrollTop;
                    }
                } else if (this.mMoveMargin > 0.0f) {
                    if (this.moveDirection == 0) {
                        this.moveDirection = 1;
                    }
                    this.mMoveMargin += overscrollTop - this.mLastMargin;
                    if (this.mLastMargin > 0.0f && this.mMoveMargin <= 0.0f) {
                        this.mMoveMargin = 0.0f;
                    }
                    if (this.moveDirection == -1) {
                        this.mMoveMargin = 0.0f;
                    }
                } else if (this.mMoveMargin < 0.0f) {
                    if (this.moveDirection == 0) {
                        this.moveDirection = -1;
                    }
                    this.mMoveMargin += overscrollTop - this.mLastMargin;
                    if (this.mLastMargin < 0.0f && this.mMoveMargin > 0.0f) {
                        this.mMoveMargin = 0.0f;
                    }
                    if (this.moveDirection == 1) {
                        this.mMoveMargin = 0.0f;
                    }
                }
                this.mLastMargin = overscrollTop;
                if (this.moveDirection == 1) {
                    float newOverscrollTop = this.mMoveMargin / this.density;
                    this.mTouchListener.onSwipe((int)newOverscrollTop);
                    break;
                }
                if (this.moveDirection != -1) break;
                float newOverscrollTop = this.mMoveMargin / this.density;
                this.mTouchListener.onSwipe((int)newOverscrollTop);
                break;
            }
            case 5: {
                pointerIndex = MotionEventCompat.getActionIndex((MotionEvent)ev);
                if (pointerIndex < 0) {
                    return false;
                }
                this.mActivePointerId = MotionEventCompat.getPointerId((MotionEvent)ev, (int)pointerIndex);
                float initialDownY = this.getMotionEventY(ev, this.mActivePointerId);
                if (initialDownY == -1.0f) {
                    return false;
                }
                this.mInitialDownY = initialDownY;
                this.mMoveMargin += this.mLastMargin;
                break;
            }
            case 6: {
                this.mActivePointerId = MotionEventCompat.getPointerId((MotionEvent)ev, (int)0);
                break;
            }
            case 1: {
                this.moveDirection = 0;
                this.mLastMargin = 0.0f;
                this.mMoveMargin = 0.0f;
                this.mTouchListener.onSwipeRefresh();
                this.mIsBeingDragged = false;
                this.mActivePointerId = -1;
                return false;
            }
            case 3: {
                this.mIsBeingDragged = false;
                return false;
            }
        }
        return true;
    }

    public void setRefreshing(boolean mRefreshing) {
        this.mRefreshing = mRefreshing;
    }

    public void setEnabledPullUp(boolean enabledPullUp) {
        this.enabledPullUp = enabledPullUp;
    }

    public void setEnalbedPullDown(boolean enalbedPullDown) {
        this.enabledPullDown = enalbedPullDown;
    }

    public static interface OnEvTouchListener {
        public void onSwipe(int var1);

        public void onSwipeRefresh();
    }
}

