/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.packagerconnection;

import com.facebook.common.logging.FLog;
import com.facebook.react.packagerconnection.ReconnectingWebSocket;
import java.util.Map;
import javax.annotation.Nullable;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import okhttp3.ws.WebSocket;
import org.json.JSONObject;

public final class JSPackagerClient
implements ReconnectingWebSocket.MessageCallback {
    private static final String TAG = JSPackagerClient.class.getSimpleName();
    private static final int PROTOCOL_VERSION = 2;
    private ReconnectingWebSocket mWebSocket;
    private Map<String, RequestHandler> mRequestHandlers;

    public JSPackagerClient(String url, Map<String, RequestHandler> requestHandlers) {
        this.mWebSocket = new ReconnectingWebSocket(url, this);
        this.mRequestHandlers = requestHandlers;
    }

    public void init() {
        this.mWebSocket.connect();
    }

    public void close() {
        this.mWebSocket.closeQuietly();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMessage(ResponseBody response) {
        if (response.contentType() != WebSocket.TEXT) {
            FLog.w((String)TAG, (String)("Websocket received message with payload of unexpected type " + response.contentType()));
            return;
        }
        try {
            JSONObject message = new JSONObject(response.string());
            int version = message.optInt("version");
            String method = message.optString("method");
            Object id2 = message.opt("id");
            Object params = message.opt("params");
            if (version != 2) {
                FLog.e((String)TAG, (String)("Message with incompatible or missing version of protocol received: " + version));
                return;
            }
            if (method == null) {
                this.abortOnMessage(id2, "No method provided");
                return;
            }
            RequestHandler handler = this.mRequestHandlers.get(method);
            if (handler == null) {
                this.abortOnMessage(id2, "No request handler for method: " + method);
                return;
            }
            if (id2 == null) {
                handler.onNotification(params);
            } else {
                handler.onRequest(params, new Responder(id2));
            }
        }
        catch (Exception e) {
            FLog.e((String)TAG, (String)"Handling the message failed", (Throwable)e);
        }
        finally {
            response.close();
        }
    }

    private void abortOnMessage(Object id2, String reason) {
        if (id2 != null) {
            new Responder(id2).error(reason);
        }
        FLog.e((String)TAG, (String)("Handling the message failed with reason: " + reason));
    }

    public static abstract class RequestOnlyHandler
    implements RequestHandler {
        @Override
        public abstract void onRequest(@Nullable Object var1, Responder var2);

        @Override
        public final void onNotification(@Nullable Object params) {
            FLog.e((String)TAG, (String)"Notification is not supported");
        }
    }

    public static abstract class NotificationOnlyHandler
    implements RequestHandler {
        @Override
        public final void onRequest(@Nullable Object params, Responder responder) {
            responder.error("Request is not supported");
            FLog.e((String)TAG, (String)"Request is not supported");
        }

        @Override
        public abstract void onNotification(@Nullable Object var1);
    }

    public static interface RequestHandler {
        public void onRequest(@Nullable Object var1, Responder var2);

        public void onNotification(@Nullable Object var1);
    }

    public class Responder {
        private Object mId;

        public Responder(Object id2) {
            this.mId = id2;
        }

        public void respond(Object result) {
            try {
                JSONObject message = new JSONObject();
                message.put("version", 2);
                message.put("id", this.mId);
                message.put("result", result);
                JSPackagerClient.this.mWebSocket.sendMessage(RequestBody.create((MediaType)WebSocket.TEXT, (String)message.toString()));
            }
            catch (Exception e) {
                FLog.e((String)TAG, (String)"Responding failed", (Throwable)e);
            }
        }

        public void error(Object error) {
            try {
                JSONObject message = new JSONObject();
                message.put("version", 2);
                message.put("id", this.mId);
                message.put("error", error);
                JSPackagerClient.this.mWebSocket.sendMessage(RequestBody.create((MediaType)WebSocket.TEXT, (String)message.toString()));
            }
            catch (Exception e) {
                FLog.e((String)TAG, (String)"Responding with error failed", (Throwable)e);
            }
        }
    }
}

