/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager;

import android.util.DisplayMetrics;
import android.widget.ImageView;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.common.MapBuilder;
import com.facebook.react.uimanager.DisplayMetricsHolder;
import com.facebook.react.uimanager.PointerEvents;
import com.facebook.react.uimanager.events.TouchEventType;
import java.util.HashMap;
import java.util.Map;

class UIManagerModuleConstants {
    public static final String ACTION_DISMISSED = "dismissed";
    public static final String ACTION_ITEM_SELECTED = "itemSelected";

    UIManagerModuleConstants() {
    }

    static Map getBubblingEventTypeConstants() {
        return MapBuilder.builder().put("topChange", MapBuilder.of("phasedRegistrationNames", MapBuilder.of("bubbled", "onChange", "captured", "onChangeCapture"))).put("topSelect", MapBuilder.of("phasedRegistrationNames", MapBuilder.of("bubbled", "onSelect", "captured", "onSelectCapture"))).put(TouchEventType.START.getJSEventName(), MapBuilder.of("phasedRegistrationNames", MapBuilder.of("bubbled", "onTouchStart", "captured", "onTouchStartCapture"))).put(TouchEventType.MOVE.getJSEventName(), MapBuilder.of("phasedRegistrationNames", MapBuilder.of("bubbled", "onTouchMove", "captured", "onTouchMoveCapture"))).put(TouchEventType.END.getJSEventName(), MapBuilder.of("phasedRegistrationNames", MapBuilder.of("bubbled", "onTouchEnd", "captured", "onTouchEndCapture"))).build();
    }

    static Map getDirectEventTypeConstants() {
        return MapBuilder.builder().put("topContentSizeChange", MapBuilder.of("registrationName", "onContentSizeChange")).put("topLayout", MapBuilder.of("registrationName", "onLayout")).put("topLoadingError", MapBuilder.of("registrationName", "onLoadingError")).put("topLoadingFinish", MapBuilder.of("registrationName", "onLoadingFinish")).put("topLoadingStart", MapBuilder.of("registrationName", "onLoadingStart")).put("topSelectionChange", MapBuilder.of("registrationName", "onSelectionChange")).put("topMessage", MapBuilder.of("registrationName", "onMessage")).build();
    }

    public static Map<String, Object> getConstants(float fontScale) {
        HashMap<String, Object> constants = new HashMap<String, Object>();
        constants.put("UIView", MapBuilder.of("ContentMode", MapBuilder.of("ScaleAspectFit", ImageView.ScaleType.FIT_CENTER.ordinal(), "ScaleAspectFill", ImageView.ScaleType.CENTER_CROP.ordinal(), "ScaleAspectCenter", ImageView.ScaleType.CENTER_INSIDE.ordinal())));
        constants.put("Dimensions", UIManagerModuleConstants.getDimensionsConstants(fontScale));
        constants.put("StyleConstants", MapBuilder.of("PointerEventsValues", MapBuilder.of("none", PointerEvents.NONE.ordinal(), "boxNone", PointerEvents.BOX_NONE.ordinal(), "boxOnly", PointerEvents.BOX_ONLY.ordinal(), "unspecified", PointerEvents.AUTO.ordinal())));
        constants.put("PopupMenu", MapBuilder.of(ACTION_DISMISSED, ACTION_DISMISSED, ACTION_ITEM_SELECTED, ACTION_ITEM_SELECTED));
        constants.put("AccessibilityEventTypes", MapBuilder.of("typeWindowStateChanged", 32, "typeViewClicked", 1));
        return constants;
    }

    public static WritableMap getDimensionsConstants(float fontScale) {
        DisplayMetrics windowDisplayMetrics = DisplayMetricsHolder.getWindowDisplayMetrics();
        DisplayMetrics screenDisplayMetrics = DisplayMetricsHolder.getScreenDisplayMetrics();
        WritableMap windowDisplayMetricsMap = Arguments.createMap();
        windowDisplayMetricsMap.putInt("width", windowDisplayMetrics.widthPixels);
        windowDisplayMetricsMap.putInt("height", windowDisplayMetrics.heightPixels);
        windowDisplayMetricsMap.putDouble("scale", windowDisplayMetrics.density);
        windowDisplayMetricsMap.putDouble("fontScale", fontScale);
        windowDisplayMetricsMap.putDouble("densityDpi", windowDisplayMetrics.densityDpi);
        WritableMap screenDisplayMetricsMap = Arguments.createMap();
        screenDisplayMetricsMap.putInt("width", screenDisplayMetrics.widthPixels);
        screenDisplayMetricsMap.putInt("height", screenDisplayMetrics.heightPixels);
        screenDisplayMetricsMap.putDouble("scale", screenDisplayMetrics.density);
        screenDisplayMetricsMap.putDouble("fontScale", fontScale);
        screenDisplayMetricsMap.putDouble("densityDpi", screenDisplayMetrics.densityDpi);
        WritableMap dimensionsMap = Arguments.createMap();
        dimensionsMap.putMap("windowPhysicalPixels", windowDisplayMetricsMap);
        dimensionsMap.putMap("screenPhysicalPixels", screenDisplayMetricsMap);
        return dimensionsMap;
    }
}

