/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager;

import com.facebook.react.bridge.Dynamic;
import com.facebook.react.bridge.ReadableType;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.ReactShadowNode;
import com.facebook.react.uimanager.ViewProps;
import com.facebook.react.uimanager.annotations.ReactProp;
import com.facebook.react.uimanager.annotations.ReactPropGroup;
import com.facebook.yoga.YogaAlign;
import com.facebook.yoga.YogaDisplay;
import com.facebook.yoga.YogaFlexDirection;
import com.facebook.yoga.YogaJustify;
import com.facebook.yoga.YogaOverflow;
import com.facebook.yoga.YogaPositionType;
import com.facebook.yoga.YogaUnit;
import com.facebook.yoga.YogaWrap;
import java.util.Locale;
import javax.annotation.Nullable;

public class LayoutShadowNode
extends ReactShadowNode {
    private final MutableYogaValue mTempYogaValue = new MutableYogaValue();

    @ReactProp(name="width")
    public void setWidth(Dynamic width) {
        if (this.isVirtual()) {
            return;
        }
        this.mTempYogaValue.setFromDynamic(width);
        switch (this.mTempYogaValue.unit) {
            case POINT: 
            case UNDEFINED: {
                this.setStyleWidth(this.mTempYogaValue.value);
                break;
            }
            case AUTO: {
                this.setStyleWidthAuto();
                break;
            }
            case PERCENT: {
                this.setStyleWidthPercent(this.mTempYogaValue.value);
            }
        }
        width.recycle();
    }

    @ReactProp(name="minWidth")
    public void setMinWidth(Dynamic minWidth) {
        if (this.isVirtual()) {
            return;
        }
        this.mTempYogaValue.setFromDynamic(minWidth);
        switch (this.mTempYogaValue.unit) {
            case POINT: 
            case UNDEFINED: {
                this.setStyleMinWidth(this.mTempYogaValue.value);
                break;
            }
            case PERCENT: {
                this.setStyleMinWidthPercent(this.mTempYogaValue.value);
            }
        }
        minWidth.recycle();
    }

    @ReactProp(name="maxWidth")
    public void setMaxWidth(Dynamic maxWidth) {
        if (this.isVirtual()) {
            return;
        }
        this.mTempYogaValue.setFromDynamic(maxWidth);
        switch (this.mTempYogaValue.unit) {
            case POINT: 
            case UNDEFINED: {
                this.setStyleMaxWidth(this.mTempYogaValue.value);
                break;
            }
            case PERCENT: {
                this.setStyleMaxWidthPercent(this.mTempYogaValue.value);
            }
        }
        maxWidth.recycle();
    }

    @ReactProp(name="height")
    public void setHeight(Dynamic height) {
        if (this.isVirtual()) {
            return;
        }
        this.mTempYogaValue.setFromDynamic(height);
        switch (this.mTempYogaValue.unit) {
            case POINT: 
            case UNDEFINED: {
                this.setStyleHeight(this.mTempYogaValue.value);
                break;
            }
            case AUTO: {
                this.setStyleHeightAuto();
                break;
            }
            case PERCENT: {
                this.setStyleHeightPercent(this.mTempYogaValue.value);
            }
        }
        height.recycle();
    }

    @ReactProp(name="minHeight")
    public void setMinHeight(Dynamic minHeight) {
        if (this.isVirtual()) {
            return;
        }
        this.mTempYogaValue.setFromDynamic(minHeight);
        switch (this.mTempYogaValue.unit) {
            case POINT: 
            case UNDEFINED: {
                this.setStyleMinHeight(this.mTempYogaValue.value);
                break;
            }
            case PERCENT: {
                this.setStyleMinHeightPercent(this.mTempYogaValue.value);
            }
        }
        minHeight.recycle();
    }

    @ReactProp(name="maxHeight")
    public void setMaxHeight(Dynamic maxHeight) {
        if (this.isVirtual()) {
            return;
        }
        this.mTempYogaValue.setFromDynamic(maxHeight);
        switch (this.mTempYogaValue.unit) {
            case POINT: 
            case UNDEFINED: {
                this.setStyleMaxHeight(this.mTempYogaValue.value);
                break;
            }
            case PERCENT: {
                this.setStyleMaxHeightPercent(this.mTempYogaValue.value);
            }
        }
        maxHeight.recycle();
    }

    @Override
    @ReactProp(name="flex", defaultFloat=0.0f)
    public void setFlex(float flex) {
        if (this.isVirtual()) {
            return;
        }
        super.setFlex(flex);
    }

    @Override
    @ReactProp(name="flexGrow", defaultFloat=0.0f)
    public void setFlexGrow(float flexGrow) {
        if (this.isVirtual()) {
            return;
        }
        super.setFlexGrow(flexGrow);
    }

    @Override
    @ReactProp(name="flexShrink", defaultFloat=0.0f)
    public void setFlexShrink(float flexShrink) {
        if (this.isVirtual()) {
            return;
        }
        super.setFlexShrink(flexShrink);
    }

    @ReactProp(name="flexBasis")
    public void setFlexBasis(Dynamic flexBasis) {
        if (this.isVirtual()) {
            return;
        }
        this.mTempYogaValue.setFromDynamic(flexBasis);
        switch (this.mTempYogaValue.unit) {
            case POINT: 
            case UNDEFINED: {
                this.setFlexBasis(this.mTempYogaValue.value);
                break;
            }
            case AUTO: {
                this.setFlexBasisAuto();
                break;
            }
            case PERCENT: {
                this.setFlexBasisPercent(this.mTempYogaValue.value);
            }
        }
        flexBasis.recycle();
    }

    @ReactProp(name="aspectRatio", defaultFloat=NaNf)
    public void setAspectRatio(float aspectRatio) {
        this.setStyleAspectRatio(aspectRatio);
    }

    @ReactProp(name="flexDirection")
    public void setFlexDirection(@Nullable String flexDirection) {
        if (this.isVirtual()) {
            return;
        }
        this.setFlexDirection(flexDirection == null ? YogaFlexDirection.COLUMN : YogaFlexDirection.valueOf(flexDirection.toUpperCase(Locale.US).replace("-", "_")));
    }

    @ReactProp(name="flexWrap")
    public void setFlexWrap(@Nullable String flexWrap) {
        if (this.isVirtual()) {
            return;
        }
        if (flexWrap == null || flexWrap.equals("nowrap")) {
            this.setFlexWrap(YogaWrap.NO_WRAP);
        } else if (flexWrap.equals("wrap")) {
            this.setFlexWrap(YogaWrap.WRAP);
        } else {
            throw new IllegalArgumentException("Unknown flexWrap value: " + flexWrap);
        }
    }

    @ReactProp(name="alignSelf")
    public void setAlignSelf(@Nullable String alignSelf) {
        if (this.isVirtual()) {
            return;
        }
        this.setAlignSelf(alignSelf == null ? YogaAlign.AUTO : YogaAlign.valueOf(alignSelf.toUpperCase(Locale.US).replace("-", "_")));
    }

    @ReactProp(name="alignItems")
    public void setAlignItems(@Nullable String alignItems) {
        if (this.isVirtual()) {
            return;
        }
        this.setAlignItems(alignItems == null ? YogaAlign.STRETCH : YogaAlign.valueOf(alignItems.toUpperCase(Locale.US).replace("-", "_")));
    }

    @ReactProp(name="alignContent")
    public void setAlignContent(@Nullable String alignContent) {
        if (this.isVirtual()) {
            return;
        }
        this.setAlignContent(alignContent == null ? YogaAlign.FLEX_START : YogaAlign.valueOf(alignContent.toUpperCase(Locale.US).replace("-", "_")));
    }

    @ReactProp(name="justifyContent")
    public void setJustifyContent(@Nullable String justifyContent) {
        if (this.isVirtual()) {
            return;
        }
        this.setJustifyContent(justifyContent == null ? YogaJustify.FLEX_START : YogaJustify.valueOf(justifyContent.toUpperCase(Locale.US).replace("-", "_")));
    }

    @ReactProp(name="overflow")
    public void setOverflow(@Nullable String overflow) {
        if (this.isVirtual()) {
            return;
        }
        this.setOverflow(overflow == null ? YogaOverflow.VISIBLE : YogaOverflow.valueOf(overflow.toUpperCase(Locale.US).replace("-", "_")));
    }

    @ReactProp(name="display")
    public void setDisplay(@Nullable String display) {
        if (this.isVirtual()) {
            return;
        }
        this.setDisplay(display == null ? YogaDisplay.FLEX : YogaDisplay.valueOf(display.toUpperCase(Locale.US).replace("-", "_")));
    }

    @ReactPropGroup(names={"margin", "marginVertical", "marginHorizontal", "marginLeft", "marginRight", "marginTop", "marginBottom"})
    public void setMargins(int index, Dynamic margin) {
        if (this.isVirtual()) {
            return;
        }
        this.mTempYogaValue.setFromDynamic(margin);
        switch (this.mTempYogaValue.unit) {
            case POINT: 
            case UNDEFINED: {
                this.setMargin(ViewProps.PADDING_MARGIN_SPACING_TYPES[index], this.mTempYogaValue.value);
                break;
            }
            case AUTO: {
                this.setMarginAuto(ViewProps.PADDING_MARGIN_SPACING_TYPES[index]);
                break;
            }
            case PERCENT: {
                this.setMarginPercent(ViewProps.PADDING_MARGIN_SPACING_TYPES[index], this.mTempYogaValue.value);
            }
        }
        margin.recycle();
    }

    @ReactPropGroup(names={"padding", "paddingVertical", "paddingHorizontal", "paddingLeft", "paddingRight", "paddingTop", "paddingBottom"})
    public void setPaddings(int index, Dynamic padding) {
        if (this.isVirtual()) {
            return;
        }
        this.mTempYogaValue.setFromDynamic(padding);
        switch (this.mTempYogaValue.unit) {
            case POINT: 
            case UNDEFINED: {
                this.setPadding(ViewProps.PADDING_MARGIN_SPACING_TYPES[index], this.mTempYogaValue.value);
                break;
            }
            case PERCENT: {
                this.setPaddingPercent(ViewProps.PADDING_MARGIN_SPACING_TYPES[index], this.mTempYogaValue.value);
            }
        }
        padding.recycle();
    }

    @ReactPropGroup(names={"borderWidth", "borderLeftWidth", "borderRightWidth", "borderTopWidth", "borderBottomWidth"}, defaultFloat=NaNf)
    public void setBorderWidths(int index, float borderWidth) {
        if (this.isVirtual()) {
            return;
        }
        this.setBorder(ViewProps.BORDER_SPACING_TYPES[index], PixelUtil.toPixelFromDIP(borderWidth));
    }

    @ReactPropGroup(names={"left", "right", "top", "bottom"})
    public void setPositionValues(int index, Dynamic position) {
        if (this.isVirtual()) {
            return;
        }
        this.mTempYogaValue.setFromDynamic(position);
        switch (this.mTempYogaValue.unit) {
            case POINT: 
            case UNDEFINED: {
                this.setPosition(ViewProps.POSITION_SPACING_TYPES[index], this.mTempYogaValue.value);
                break;
            }
            case PERCENT: {
                this.setPositionPercent(ViewProps.POSITION_SPACING_TYPES[index], this.mTempYogaValue.value);
            }
        }
        position.recycle();
    }

    @ReactProp(name="position")
    public void setPosition(@Nullable String position) {
        if (this.isVirtual()) {
            return;
        }
        YogaPositionType positionType = position == null ? YogaPositionType.RELATIVE : YogaPositionType.valueOf(position.toUpperCase(Locale.US));
        this.setPositionType(positionType);
    }

    @Override
    @ReactProp(name="onLayout")
    public void setShouldNotifyOnLayout(boolean shouldNotifyOnLayout) {
        super.setShouldNotifyOnLayout(shouldNotifyOnLayout);
    }

    private static class MutableYogaValue {
        float value;
        YogaUnit unit;

        private MutableYogaValue() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        void setFromDynamic(Dynamic dynamic) {
            if (dynamic.isNull()) {
                this.unit = YogaUnit.UNDEFINED;
                this.value = Float.NaN;
                return;
            } else if (dynamic.getType() == ReadableType.String) {
                String s = dynamic.asString();
                if (s.equals("auto")) {
                    this.unit = YogaUnit.AUTO;
                    this.value = Float.NaN;
                    return;
                } else {
                    if (!s.endsWith("%")) throw new IllegalArgumentException("Unknown value: " + s);
                    this.unit = YogaUnit.PERCENT;
                    this.value = Float.parseFloat(s.substring(0, s.length() - 1));
                }
                return;
            } else {
                this.unit = YogaUnit.POINT;
                this.value = PixelUtil.toPixelFromDIP(dynamic.asDouble());
            }
        }
    }
}

