/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.picker;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.widget.AdapterView;
import android.widget.Spinner;
import com.facebook.react.common.annotations.VisibleForTesting;
import javax.annotation.Nullable;

public class ReactPicker
extends Spinner {
    private int mMode = 0;
    @Nullable
    private Integer mPrimaryColor;
    private boolean mSuppressNextEvent;
    @Nullable
    private OnSelectListener mOnSelectListener;
    @Nullable
    private Integer mStagedSelection;
    private final Runnable measureAndLayout = new Runnable(){

        @Override
        public void run() {
            ReactPicker.this.measure(View.MeasureSpec.makeMeasureSpec((int)ReactPicker.this.getWidth(), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)ReactPicker.this.getHeight(), (int)0x40000000));
            ReactPicker.this.layout(ReactPicker.this.getLeft(), ReactPicker.this.getTop(), ReactPicker.this.getRight(), ReactPicker.this.getBottom());
        }
    };

    public ReactPicker(Context context) {
        super(context);
    }

    public ReactPicker(Context context, int mode) {
        super(context, mode);
        this.mMode = mode;
    }

    public ReactPicker(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public ReactPicker(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public ReactPicker(Context context, AttributeSet attrs, int defStyle, int mode) {
        super(context, attrs, defStyle, mode);
        this.mMode = mode;
    }

    public void requestLayout() {
        super.requestLayout();
        this.post(this.measureAndLayout);
    }

    public void setOnSelectListener(@Nullable OnSelectListener onSelectListener) {
        if (this.getOnItemSelectedListener() == null) {
            this.mSuppressNextEvent = true;
            this.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener(){

                public void onItemSelected(AdapterView<?> parent, View view, int position, long id2) {
                    if (!ReactPicker.this.mSuppressNextEvent && ReactPicker.this.mOnSelectListener != null) {
                        ReactPicker.this.mOnSelectListener.onItemSelected(position);
                    }
                    ReactPicker.this.mSuppressNextEvent = false;
                }

                public void onNothingSelected(AdapterView<?> parent) {
                    if (!ReactPicker.this.mSuppressNextEvent && ReactPicker.this.mOnSelectListener != null) {
                        ReactPicker.this.mOnSelectListener.onItemSelected(-1);
                    }
                    ReactPicker.this.mSuppressNextEvent = false;
                }
            });
        }
        this.mOnSelectListener = onSelectListener;
    }

    @Nullable
    public OnSelectListener getOnSelectListener() {
        return this.mOnSelectListener;
    }

    public void setStagedSelection(int selection) {
        this.mStagedSelection = selection;
    }

    public void updateStagedSelection() {
        if (this.mStagedSelection != null) {
            this.setSelectionWithSuppressEvent(this.mStagedSelection);
            this.mStagedSelection = null;
        }
    }

    private void setSelectionWithSuppressEvent(int position) {
        if (position != this.getSelectedItemPosition()) {
            this.mSuppressNextEvent = true;
            this.setSelection(position);
        }
    }

    @Nullable
    public Integer getPrimaryColor() {
        return this.mPrimaryColor;
    }

    public void setPrimaryColor(@Nullable Integer primaryColor) {
        this.mPrimaryColor = primaryColor;
    }

    @VisibleForTesting
    public int getMode() {
        return this.mMode;
    }

    public static interface OnSelectListener {
        public void onItemSelected(int var1);
    }
}

