/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.flat;

import com.facebook.infer.annotation.Assertions;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.flat.FlatShadowNode;
import com.facebook.react.uimanager.ReactShadowNode;
import javax.annotation.Nullable;

final class MoveProxy {
    @Nullable
    private ReadableArray mMoveTo;
    private int mSize;
    private int[] mMapping = new int[8];
    private ReactShadowNode[] mChildren = new ReactShadowNode[4];

    MoveProxy() {
    }

    public int size() {
        return this.mSize;
    }

    public void setChildMoveFrom(int moveFromIndex, ReactShadowNode node) {
        this.mChildren[this.moveFromToIndex((int)moveFromIndex)] = node;
    }

    public ReactShadowNode getChildMoveTo(int moveToIndex) {
        return this.mChildren[MoveProxy.moveToToIndex(moveToIndex)];
    }

    public int getMoveFrom(int moveFromIndex) {
        return this.moveFromToValue(moveFromIndex);
    }

    public int getMoveTo(int moveToIndex) {
        return this.moveToToValue(moveToIndex);
    }

    public void setup(ReadableArray moveFrom, ReadableArray moveTo) {
        this.mMoveTo = moveTo;
        if (moveFrom == null) {
            this.setSize(0);
            return;
        }
        int size = moveFrom.size();
        int requiredSpace = size + size;
        if (this.mMapping.length < requiredSpace) {
            this.mMapping = new int[requiredSpace];
            this.mChildren = new FlatShadowNode[size];
        }
        this.setSize(size);
        this.setKeyValue(0, 0, moveFrom.getInt(0));
        for (int i = 1; i < size; ++i) {
            int j;
            int current = moveFrom.getInt(i);
            for (j = i - 1; j >= 0 && this.moveFromToValue(j) >= current; --j) {
                this.setKeyValue(j + 1, this.moveFromToIndex(j), this.moveFromToValue(j));
            }
            this.setKeyValue(j + 1, i, current);
        }
    }

    private static int k(int i) {
        return i * 2;
    }

    private static int v(int i) {
        return i * 2 + 1;
    }

    private void setKeyValue(int index, int key, int value) {
        this.mMapping[MoveProxy.k((int)index)] = key;
        this.mMapping[MoveProxy.v((int)index)] = value;
    }

    private int moveFromToIndex(int index) {
        return this.mMapping[MoveProxy.k(index)];
    }

    private int moveFromToValue(int index) {
        return this.mMapping[MoveProxy.v(index)];
    }

    private static int moveToToIndex(int index) {
        return index;
    }

    private int moveToToValue(int index) {
        return ((ReadableArray)Assertions.assumeNotNull((Object)this.mMoveTo)).getInt(index);
    }

    private void setSize(int newSize) {
        for (int i = newSize; i < this.mSize; ++i) {
            this.mChildren[i] = null;
        }
        this.mSize = newSize;
    }
}

