/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Process;
import com.facebook.common.logging.FLog;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.CoreModulesPackage;
import com.facebook.react.JSCConfig;
import com.facebook.react.MemoryPressureRouter;
import com.facebook.react.NativeModuleRegistryBuilder;
import com.facebook.react.ReactInstanceManagerBuilder;
import com.facebook.react.ReactPackage;
import com.facebook.react.ReactPackageLogger;
import com.facebook.react.ReactRootView;
import com.facebook.react.bridge.CatalystInstance;
import com.facebook.react.bridge.JavaJSExecutor;
import com.facebook.react.bridge.JavaScriptModule;
import com.facebook.react.bridge.JavaScriptModuleRegistry;
import com.facebook.react.bridge.NativeModuleCallExceptionHandler;
import com.facebook.react.bridge.NotThreadSafeBridgeIdleDebugListener;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.ReactMarker;
import com.facebook.react.bridge.WritableNativeMap;
import com.facebook.react.bridge.queue.ReactQueueConfigurationSpec;
import com.facebook.react.common.ApplicationHolder;
import com.facebook.react.common.LifecycleState;
import com.facebook.react.common.annotations.VisibleForTesting;
import com.facebook.react.cxxbridge.Arguments;
import com.facebook.react.cxxbridge.CatalystInstanceImpl;
import com.facebook.react.cxxbridge.JSBundleLoader;
import com.facebook.react.cxxbridge.JSCJavaScriptExecutor;
import com.facebook.react.cxxbridge.JavaScriptExecutor;
import com.facebook.react.cxxbridge.NativeModuleRegistry;
import com.facebook.react.cxxbridge.ProxyJavaScriptExecutor;
import com.facebook.react.cxxbridge.UiThreadUtil;
import com.facebook.react.devsupport.DevSupportManagerFactory;
import com.facebook.react.devsupport.ReactInstanceDevCommandsHandler;
import com.facebook.react.devsupport.RedBoxHandler;
import com.facebook.react.devsupport.interfaces.DevSupportManager;
import com.facebook.react.devsupport.interfaces.PackagerStatusCallback;
import com.facebook.react.modules.appregistry.AppRegistry;
import com.facebook.react.modules.core.DefaultHardwareBackBtnHandler;
import com.facebook.react.modules.core.DeviceEventManagerModule;
import com.facebook.react.modules.debug.interfaces.DeveloperSettings;
import com.facebook.react.uimanager.DisplayMetricsHolder;
import com.facebook.react.uimanager.UIImplementationProvider;
import com.facebook.react.uimanager.UIManagerModule;
import com.facebook.react.uimanager.ViewManager;
import com.facebook.react.views.imagehelper.ResourceDrawableIdHelper;
import com.facebook.soloader.SoLoader;
import com.facebook.systrace.Systrace;
import com.facebook.systrace.SystraceMessage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;

public class ReactInstanceManager {
    private static final String TAG = ReactInstanceManager.class.getSimpleName();
    private final List<ReactRootView> mAttachedRootViews = new ArrayList<ReactRootView>();
    private LifecycleState mLifecycleState;
    @Nullable
    private ReactContextInitParams mPendingReactContextInitParams;
    @Nullable
    private ReactContextInitAsyncTask mReactContextInitAsyncTask;
    @Nullable
    private final JSBundleLoader mBundleLoader;
    @Nullable
    private final String mJSMainModuleName;
    private final List<ReactPackage> mPackages;
    private final DevSupportManager mDevSupportManager;
    private final boolean mUseDeveloperSupport;
    @Nullable
    private final NotThreadSafeBridgeIdleDebugListener mBridgeIdleDebugListener;
    @Nullable
    private volatile ReactContext mCurrentReactContext;
    private final Context mApplicationContext;
    @Nullable
    private DefaultHardwareBackBtnHandler mDefaultBackButtonImpl;
    @Nullable
    private Activity mCurrentActivity;
    private final Collection<ReactInstanceEventListener> mReactInstanceEventListeners = Collections.synchronizedSet(new HashSet());
    private volatile boolean mHasStartedCreatingInitialContext = false;
    private final UIImplementationProvider mUIImplementationProvider;
    private final MemoryPressureRouter mMemoryPressureRouter;
    @Nullable
    private final NativeModuleCallExceptionHandler mNativeModuleCallExceptionHandler;
    private final JSCConfig mJSCConfig;
    private final boolean mLazyNativeModulesEnabled;
    private final boolean mLazyViewManagersEnabled;
    private final ReactInstanceDevCommandsHandler mDevInterface = new ReactInstanceDevCommandsHandler(){

        @Override
        public void onReloadWithJSDebugger(JavaJSExecutor.Factory jsExecutorFactory) {
            ReactInstanceManager.this.onReloadWithJSDebugger(jsExecutorFactory);
        }

        @Override
        public void onJSBundleLoadedFromServer() {
            ReactInstanceManager.this.onJSBundleLoadedFromServer();
        }

        @Override
        public void toggleElementInspector() {
            ReactInstanceManager.this.toggleElementInspector();
        }
    };
    private final DefaultHardwareBackBtnHandler mBackBtnHandler = new DefaultHardwareBackBtnHandler(){

        @Override
        public void invokeDefaultOnBackPressed() {
            ReactInstanceManager.this.invokeDefaultOnBackPressed();
        }
    };

    public static ReactInstanceManagerBuilder builder() {
        return new ReactInstanceManagerBuilder();
    }

    ReactInstanceManager(Context applicationContext, @Nullable Activity currentActivity, @Nullable DefaultHardwareBackBtnHandler defaultHardwareBackBtnHandler, @Nullable JSBundleLoader bundleLoader, @Nullable String jsMainModuleName, List<ReactPackage> packages, boolean useDeveloperSupport, @Nullable NotThreadSafeBridgeIdleDebugListener bridgeIdleDebugListener, LifecycleState initialLifecycleState, UIImplementationProvider uiImplementationProvider, NativeModuleCallExceptionHandler nativeModuleCallExceptionHandler, JSCConfig jscConfig, @Nullable RedBoxHandler redBoxHandler, boolean lazyNativeModulesEnabled, boolean lazyViewManagersEnabled) {
        ReactInstanceManager.initializeSoLoaderIfNecessary(applicationContext);
        ApplicationHolder.setApplication((Application)applicationContext.getApplicationContext());
        DisplayMetricsHolder.initDisplayMetricsIfNotInitialized(applicationContext);
        this.mApplicationContext = applicationContext;
        this.mCurrentActivity = currentActivity;
        this.mDefaultBackButtonImpl = defaultHardwareBackBtnHandler;
        this.mBundleLoader = bundleLoader;
        this.mJSMainModuleName = jsMainModuleName;
        this.mPackages = packages;
        this.mUseDeveloperSupport = useDeveloperSupport;
        this.mDevSupportManager = DevSupportManagerFactory.create(applicationContext, this.mDevInterface, this.mJSMainModuleName, useDeveloperSupport, redBoxHandler);
        this.mBridgeIdleDebugListener = bridgeIdleDebugListener;
        this.mLifecycleState = initialLifecycleState;
        this.mUIImplementationProvider = uiImplementationProvider;
        this.mMemoryPressureRouter = new MemoryPressureRouter(applicationContext);
        this.mNativeModuleCallExceptionHandler = nativeModuleCallExceptionHandler;
        this.mJSCConfig = jscConfig;
        this.mLazyNativeModulesEnabled = lazyNativeModulesEnabled;
        this.mLazyViewManagersEnabled = lazyViewManagersEnabled;
    }

    public DevSupportManager getDevSupportManager() {
        return this.mDevSupportManager;
    }

    public MemoryPressureRouter getMemoryPressureRouter() {
        return this.mMemoryPressureRouter;
    }

    private static void initializeSoLoaderIfNecessary(Context applicationContext) {
        SoLoader.init((Context)applicationContext, (boolean)false);
    }

    public void createReactContextInBackground() {
        Assertions.assertCondition((!this.mHasStartedCreatingInitialContext ? 1 : 0) != 0, (String)"createReactContextInBackground should only be called when creating the react application for the first time. When reloading JS, e.g. from a new file, explicitlyuse recreateReactContextInBackground");
        this.mHasStartedCreatingInitialContext = true;
        this.recreateReactContextInBackgroundInner();
    }

    public void recreateReactContextInBackground() {
        Assertions.assertCondition((boolean)this.mHasStartedCreatingInitialContext, (String)"recreateReactContextInBackground should only be called after the initial createReactContextInBackground call.");
        this.recreateReactContextInBackgroundInner();
    }

    private void recreateReactContextInBackgroundInner() {
        UiThreadUtil.assertOnUiThread();
        if (this.mUseDeveloperSupport && this.mJSMainModuleName != null) {
            final DeveloperSettings devSettings = this.mDevSupportManager.getDevSettings();
            if (this.mDevSupportManager.hasUpToDateJSBundleInCache() && !devSettings.isRemoteJSDebugEnabled()) {
                this.onJSBundleLoadedFromServer();
            } else if (this.mBundleLoader == null) {
                this.mDevSupportManager.handleReloadJS();
            } else {
                this.mDevSupportManager.isPackagerRunning(new PackagerStatusCallback(){

                    @Override
                    public void onPackagerStatusFetched(final boolean packagerIsRunning) {
                        UiThreadUtil.runOnUiThread(new Runnable(){

                            @Override
                            public void run() {
                                if (packagerIsRunning) {
                                    ReactInstanceManager.this.mDevSupportManager.handleReloadJS();
                                } else {
                                    devSettings.setRemoteJSDebugEnabled(false);
                                    ReactInstanceManager.this.recreateReactContextInBackgroundFromBundleLoader();
                                }
                            }
                        });
                    }
                });
            }
            return;
        }
        this.recreateReactContextInBackgroundFromBundleLoader();
    }

    private void recreateReactContextInBackgroundFromBundleLoader() {
        this.recreateReactContextInBackground(new JSCJavaScriptExecutor.Factory(this.mJSCConfig.getConfigMap()), this.mBundleLoader);
    }

    public boolean hasStartedCreatingInitialContext() {
        return this.mHasStartedCreatingInitialContext;
    }

    public void onBackPressed() {
        UiThreadUtil.assertOnUiThread();
        ReactContext reactContext = this.mCurrentReactContext;
        if (this.mCurrentReactContext == null) {
            FLog.w((String)"React", (String)"Instance detached from instance manager");
            this.invokeDefaultOnBackPressed();
        } else {
            DeviceEventManagerModule deviceEventManagerModule = ((ReactContext)((Object)Assertions.assertNotNull((Object)((Object)reactContext)))).getNativeModule(DeviceEventManagerModule.class);
            deviceEventManagerModule.emitHardwareBackPressed();
        }
    }

    private void invokeDefaultOnBackPressed() {
        UiThreadUtil.assertOnUiThread();
        if (this.mDefaultBackButtonImpl != null) {
            this.mDefaultBackButtonImpl.invokeDefaultOnBackPressed();
        }
    }

    public void onNewIntent(Intent intent) {
        if (this.mCurrentReactContext == null) {
            FLog.w((String)"React", (String)"Instance detached from instance manager");
        } else {
            String action = intent.getAction();
            Uri uri = intent.getData();
            if ("android.intent.action.VIEW".equals(action) && uri != null) {
                DeviceEventManagerModule deviceEventManagerModule = ((ReactContext)((Object)Assertions.assertNotNull((Object)((Object)this.mCurrentReactContext)))).getNativeModule(DeviceEventManagerModule.class);
                deviceEventManagerModule.emitNewIntentReceived(uri);
            }
            this.mCurrentReactContext.onNewIntent(this.mCurrentActivity, intent);
        }
    }

    private void toggleElementInspector() {
        if (this.mCurrentReactContext != null) {
            this.mCurrentReactContext.getJSModule(DeviceEventManagerModule.RCTDeviceEventEmitter.class).emit("toggleElementInspector", null);
        }
    }

    public void onHostPause() {
        UiThreadUtil.assertOnUiThread();
        this.mDefaultBackButtonImpl = null;
        if (this.mUseDeveloperSupport) {
            this.mDevSupportManager.setDevSupportEnabled(false);
        }
        this.moveToBeforeResumeLifecycleState();
    }

    public void onHostPause(Activity activity) {
        Assertions.assertNotNull((Object)this.mCurrentActivity);
        Assertions.assertCondition((activity == this.mCurrentActivity ? 1 : 0) != 0, (String)("Pausing an activity that is not the current activity, this is incorrect! Current activity: " + this.mCurrentActivity.getClass().getSimpleName() + " " + "Paused activity: " + activity.getClass().getSimpleName()));
        this.onHostPause();
    }

    public void onHostResume(Activity activity, DefaultHardwareBackBtnHandler defaultBackButtonImpl) {
        UiThreadUtil.assertOnUiThread();
        this.mDefaultBackButtonImpl = defaultBackButtonImpl;
        if (this.mUseDeveloperSupport) {
            this.mDevSupportManager.setDevSupportEnabled(true);
        }
        this.mCurrentActivity = activity;
        this.moveToResumedLifecycleState(false);
    }

    public void onHostDestroy() {
        UiThreadUtil.assertOnUiThread();
        if (this.mUseDeveloperSupport) {
            this.mDevSupportManager.setDevSupportEnabled(false);
        }
        this.moveToBeforeCreateLifecycleState();
        this.mCurrentActivity = null;
    }

    public void onHostDestroy(Activity activity) {
        if (activity == this.mCurrentActivity) {
            this.onHostDestroy();
        }
    }

    public void destroy() {
        UiThreadUtil.assertOnUiThread();
        if (this.mUseDeveloperSupport) {
            this.mDevSupportManager.setDevSupportEnabled(false);
        }
        this.moveToBeforeCreateLifecycleState();
        if (this.mReactContextInitAsyncTask != null) {
            this.mReactContextInitAsyncTask.cancel(true);
        }
        this.mMemoryPressureRouter.destroy(this.mApplicationContext);
        if (this.mCurrentReactContext != null) {
            this.mCurrentReactContext.destroy();
            this.mCurrentReactContext = null;
            this.mHasStartedCreatingInitialContext = false;
        }
        this.mCurrentActivity = null;
        ResourceDrawableIdHelper.getInstance().clear();
    }

    private void moveToResumedLifecycleState(boolean force) {
        if (this.mCurrentReactContext != null && (force || this.mLifecycleState == LifecycleState.BEFORE_RESUME || this.mLifecycleState == LifecycleState.BEFORE_CREATE)) {
            this.mCurrentReactContext.onHostResume(this.mCurrentActivity);
        }
        this.mLifecycleState = LifecycleState.RESUMED;
    }

    private void moveToBeforeResumeLifecycleState() {
        if (this.mCurrentReactContext != null) {
            if (this.mLifecycleState == LifecycleState.BEFORE_CREATE) {
                this.mCurrentReactContext.onHostResume(this.mCurrentActivity);
                this.mCurrentReactContext.onHostPause();
            } else if (this.mLifecycleState == LifecycleState.RESUMED) {
                this.mCurrentReactContext.onHostPause();
            }
        }
        this.mLifecycleState = LifecycleState.BEFORE_RESUME;
    }

    private void moveToBeforeCreateLifecycleState() {
        if (this.mCurrentReactContext != null) {
            if (this.mLifecycleState == LifecycleState.RESUMED) {
                this.mCurrentReactContext.onHostPause();
                this.mLifecycleState = LifecycleState.BEFORE_RESUME;
            }
            if (this.mLifecycleState == LifecycleState.BEFORE_RESUME) {
                this.mCurrentReactContext.onHostDestroy();
            }
        }
        this.mLifecycleState = LifecycleState.BEFORE_CREATE;
    }

    public void onActivityResult(Activity activity, int requestCode, int resultCode, Intent data) {
        if (this.mCurrentReactContext != null) {
            this.mCurrentReactContext.onActivityResult(activity, requestCode, resultCode, data);
        }
    }

    public void showDevOptionsDialog() {
        UiThreadUtil.assertOnUiThread();
        this.mDevSupportManager.showDevOptionsDialog();
    }

    public void attachMeasuredRootView(ReactRootView rootView) {
        UiThreadUtil.assertOnUiThread();
        this.mAttachedRootViews.add(rootView);
        if (this.mReactContextInitAsyncTask == null && this.mCurrentReactContext != null) {
            this.attachMeasuredRootViewToInstance(rootView, this.mCurrentReactContext.getCatalystInstance());
        }
    }

    public void detachRootView(ReactRootView rootView) {
        UiThreadUtil.assertOnUiThread();
        if (this.mAttachedRootViews.remove(rootView) && this.mCurrentReactContext != null && this.mCurrentReactContext.hasActiveCatalystInstance()) {
            this.detachViewFromInstance(rootView, this.mCurrentReactContext.getCatalystInstance());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ViewManager> createAllViewManagers(ReactApplicationContext catalystApplicationContext) {
        ReactMarker.logMarker("CREATE_VIEW_MANAGERS_START");
        Systrace.beginSection(0L, "createAllViewManagers");
        try {
            ArrayList<ViewManager> allViewManagers = new ArrayList<ViewManager>();
            for (ReactPackage reactPackage : this.mPackages) {
                allViewManagers.addAll(reactPackage.createViewManagers(catalystApplicationContext));
            }
            ArrayList<ViewManager> arrayList = allViewManagers;
            return arrayList;
        }
        finally {
            Systrace.endSection(0L);
            ReactMarker.logMarker("CREATE_VIEW_MANAGERS_END");
        }
    }

    public void addReactInstanceEventListener(ReactInstanceEventListener listener) {
        this.mReactInstanceEventListeners.add(listener);
    }

    public void removeReactInstanceEventListener(ReactInstanceEventListener listener) {
        this.mReactInstanceEventListeners.remove(listener);
    }

    @Nullable
    @VisibleForTesting
    public ReactContext getCurrentReactContext() {
        return this.mCurrentReactContext;
    }

    public LifecycleState getLifecycleState() {
        return this.mLifecycleState;
    }

    private void onReloadWithJSDebugger(JavaJSExecutor.Factory jsExecutorFactory) {
        this.recreateReactContextInBackground(new ProxyJavaScriptExecutor.Factory(jsExecutorFactory), JSBundleLoader.createRemoteDebuggerBundleLoader(this.mDevSupportManager.getJSBundleURLForRemoteDebugging(), this.mDevSupportManager.getSourceUrl()));
    }

    private void onJSBundleLoadedFromServer() {
        this.recreateReactContextInBackground(new JSCJavaScriptExecutor.Factory(this.mJSCConfig.getConfigMap()), JSBundleLoader.createCachedBundleFromNetworkLoader(this.mDevSupportManager.getSourceUrl(), this.mDevSupportManager.getDownloadedJSBundleFile()));
    }

    private void recreateReactContextInBackground(JavaScriptExecutor.Factory jsExecutorFactory, JSBundleLoader jsBundleLoader) {
        UiThreadUtil.assertOnUiThread();
        ReactContextInitParams initParams = new ReactContextInitParams(jsExecutorFactory, jsBundleLoader);
        if (this.mReactContextInitAsyncTask == null) {
            this.mReactContextInitAsyncTask = new ReactContextInitAsyncTask();
            this.mReactContextInitAsyncTask.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new ReactContextInitParams[]{initParams});
        } else {
            this.mPendingReactContextInitParams = initParams;
        }
    }

    private void setupReactContext(ReactApplicationContext reactContext) {
        ReactMarker.logMarker("SETUP_REACT_CONTEXT_START");
        Systrace.beginSection(0L, "setupReactContext");
        UiThreadUtil.assertOnUiThread();
        Assertions.assertCondition((this.mCurrentReactContext == null ? 1 : 0) != 0);
        this.mCurrentReactContext = (ReactContext)((Object)Assertions.assertNotNull((Object)((Object)reactContext)));
        CatalystInstance catalystInstance = (CatalystInstance)Assertions.assertNotNull((Object)reactContext.getCatalystInstance());
        catalystInstance.initialize();
        this.mDevSupportManager.onNewReactContextCreated(reactContext);
        this.mMemoryPressureRouter.addMemoryPressureListener(catalystInstance);
        this.moveReactContextToCurrentLifecycleState();
        for (ReactRootView rootView : this.mAttachedRootViews) {
            this.attachMeasuredRootViewToInstance(rootView, catalystInstance);
        }
        ReactInstanceEventListener[] listeners = new ReactInstanceEventListener[this.mReactInstanceEventListeners.size()];
        for (ReactInstanceEventListener listener : listeners = this.mReactInstanceEventListeners.toArray(listeners)) {
            listener.onReactContextInitialized(reactContext);
        }
        Systrace.endSection(0L);
        ReactMarker.logMarker("SETUP_REACT_CONTEXT_END");
    }

    private void attachMeasuredRootViewToInstance(ReactRootView rootView, CatalystInstance catalystInstance) {
        Systrace.beginSection(0L, "attachMeasuredRootViewToInstance");
        UiThreadUtil.assertOnUiThread();
        rootView.removeAllViews();
        rootView.setId(-1);
        UIManagerModule uiManagerModule = catalystInstance.getNativeModule(UIManagerModule.class);
        int rootTag = uiManagerModule.addMeasuredRootView(rootView);
        rootView.setRootViewTag(rootTag);
        Bundle launchOptions = rootView.getLaunchOptions();
        WritableNativeMap initialProps = Arguments.makeNativeMap(launchOptions);
        String jsAppModuleName = rootView.getJSModuleName();
        WritableNativeMap appParams = new WritableNativeMap();
        appParams.putDouble("rootTag", rootTag);
        appParams.putMap("initialProps", initialProps);
        catalystInstance.getJSModule(AppRegistry.class).runApplication(jsAppModuleName, appParams);
        rootView.onAttachedToReactInstance();
        Systrace.endSection(0L);
    }

    private void detachViewFromInstance(ReactRootView rootView, CatalystInstance catalystInstance) {
        UiThreadUtil.assertOnUiThread();
        catalystInstance.getJSModule(AppRegistry.class).unmountApplicationComponentAtRootTag(rootView.getId());
    }

    private void tearDownReactContext(ReactContext reactContext) {
        UiThreadUtil.assertOnUiThread();
        if (this.mLifecycleState == LifecycleState.RESUMED) {
            reactContext.onHostPause();
        }
        for (ReactRootView rootView : this.mAttachedRootViews) {
            this.detachViewFromInstance(rootView, reactContext.getCatalystInstance());
        }
        reactContext.destroy();
        this.mDevSupportManager.onReactInstanceDestroyed(reactContext);
        this.mMemoryPressureRouter.removeMemoryPressureListener(reactContext.getCatalystInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReactApplicationContext createReactContext(JavaScriptExecutor jsExecutor, JSBundleLoader jsBundleLoader) {
        CatalystInstanceImpl catalystInstance;
        NativeModuleRegistry nativeModuleRegistry;
        FLog.i((String)"React", (String)"Creating react context.");
        ReactMarker.logMarker("CREATE_REACT_CONTEXT_START");
        ReactApplicationContext reactContext = new ReactApplicationContext(this.mApplicationContext);
        NativeModuleRegistryBuilder nativeModuleRegistryBuilder = new NativeModuleRegistryBuilder(reactContext, this.mLazyNativeModulesEnabled);
        JavaScriptModuleRegistry.Builder jsModulesBuilder = new JavaScriptModuleRegistry.Builder();
        if (this.mUseDeveloperSupport) {
            reactContext.setNativeModuleCallExceptionHandler(this.mDevSupportManager);
        }
        ReactMarker.logMarker("PROCESS_PACKAGES_START");
        Systrace.beginSection(0L, "createAndProcessCoreModulesPackage");
        try {
            CoreModulesPackage coreModulesPackage = new CoreModulesPackage(this, this.mBackBtnHandler, this.mUIImplementationProvider, this.mLazyViewManagersEnabled);
            this.processPackage(coreModulesPackage, nativeModuleRegistryBuilder, jsModulesBuilder);
        }
        finally {
            Systrace.endSection(0L);
        }
        for (ReactPackage reactPackage : this.mPackages) {
            Systrace.beginSection(0L, "createAndProcessCustomReactPackage");
            try {
                this.processPackage(reactPackage, nativeModuleRegistryBuilder, jsModulesBuilder);
            }
            finally {
                Systrace.endSection(0L);
            }
        }
        ReactMarker.logMarker("PROCESS_PACKAGES_END");
        ReactMarker.logMarker("BUILD_NATIVE_MODULE_REGISTRY_START");
        Systrace.beginSection(0L, "buildNativeModuleRegistry");
        try {
            nativeModuleRegistry = nativeModuleRegistryBuilder.build();
        }
        finally {
            Systrace.endSection(0L);
            ReactMarker.logMarker("BUILD_NATIVE_MODULE_REGISTRY_END");
        }
        NativeModuleCallExceptionHandler exceptionHandler = this.mNativeModuleCallExceptionHandler != null ? this.mNativeModuleCallExceptionHandler : this.mDevSupportManager;
        CatalystInstanceImpl.Builder catalystInstanceBuilder = new CatalystInstanceImpl.Builder().setReactQueueConfigurationSpec(ReactQueueConfigurationSpec.createDefault()).setJSExecutor(jsExecutor).setRegistry(nativeModuleRegistry).setJSModuleRegistry(jsModulesBuilder.build()).setJSBundleLoader(jsBundleLoader).setNativeModuleCallExceptionHandler(exceptionHandler);
        ReactMarker.logMarker("CREATE_CATALYST_INSTANCE_START");
        Systrace.beginSection(0L, "createCatalystInstance");
        try {
            catalystInstance = catalystInstanceBuilder.build();
        }
        finally {
            Systrace.endSection(0L);
            ReactMarker.logMarker("CREATE_CATALYST_INSTANCE_END");
        }
        if (this.mBridgeIdleDebugListener != null) {
            catalystInstance.addBridgeIdleDebugListener(this.mBridgeIdleDebugListener);
        }
        reactContext.initializeWithInstance(catalystInstance);
        catalystInstance.runJSBundle();
        return reactContext;
    }

    private void processPackage(ReactPackage reactPackage, NativeModuleRegistryBuilder nativeModuleRegistryBuilder, JavaScriptModuleRegistry.Builder jsModulesBuilder) {
        SystraceMessage.beginSection(0L, "processPackage").arg("className", reactPackage.getClass().getSimpleName()).flush();
        if (reactPackage instanceof ReactPackageLogger) {
            ((ReactPackageLogger)((Object)reactPackage)).startProcessPackage();
        }
        nativeModuleRegistryBuilder.processPackage(reactPackage);
        for (Class<? extends JavaScriptModule> jsModuleClass : reactPackage.createJSModules()) {
            jsModulesBuilder.add(jsModuleClass);
        }
        if (reactPackage instanceof ReactPackageLogger) {
            ((ReactPackageLogger)((Object)reactPackage)).endProcessPackage();
        }
        Systrace.endSection(0L);
    }

    private void moveReactContextToCurrentLifecycleState() {
        if (this.mLifecycleState == LifecycleState.RESUMED) {
            this.moveToResumedLifecycleState(true);
        }
    }

    private static class Result<T> {
        @Nullable
        private final T mResult;
        @Nullable
        private final Exception mException;

        public static <T, U extends T> Result<T> of(U result) {
            return new Result<U>(result);
        }

        public static <T> Result<T> of(Exception exception) {
            return new Result<T>(exception);
        }

        private Result(T result) {
            this.mException = null;
            this.mResult = result;
        }

        private Result(Exception exception) {
            this.mException = exception;
            this.mResult = null;
        }

        public T get() throws Exception {
            if (this.mException != null) {
                throw this.mException;
            }
            Assertions.assertNotNull(this.mResult);
            return this.mResult;
        }
    }

    private final class ReactContextInitAsyncTask
    extends AsyncTask<ReactContextInitParams, Void, Result<ReactApplicationContext>> {
        private ReactContextInitAsyncTask() {
        }

        protected void onPreExecute() {
            if (ReactInstanceManager.this.mCurrentReactContext != null) {
                ReactInstanceManager.this.tearDownReactContext(ReactInstanceManager.this.mCurrentReactContext);
                ReactInstanceManager.this.mCurrentReactContext = null;
            }
        }

        protected Result<ReactApplicationContext> doInBackground(ReactContextInitParams ... params) {
            Process.setThreadPriority((int)0);
            Assertions.assertCondition((params != null && params.length > 0 && params[0] != null ? 1 : 0) != 0);
            try {
                JavaScriptExecutor jsExecutor = params[0].getJsExecutorFactory().create();
                return Result.of(ReactInstanceManager.this.createReactContext(jsExecutor, params[0].getJsBundleLoader()));
            }
            catch (Exception e) {
                return Result.of(e);
            }
        }

        protected void onPostExecute(Result<ReactApplicationContext> result) {
            try {
                ReactInstanceManager.this.setupReactContext(result.get());
            }
            catch (Exception e) {
                ReactInstanceManager.this.mDevSupportManager.handleException(e);
            }
            finally {
                ReactInstanceManager.this.mReactContextInitAsyncTask = null;
            }
            if (ReactInstanceManager.this.mPendingReactContextInitParams != null) {
                ReactInstanceManager.this.recreateReactContextInBackground(ReactInstanceManager.this.mPendingReactContextInitParams.getJsExecutorFactory(), ReactInstanceManager.this.mPendingReactContextInitParams.getJsBundleLoader());
                ReactInstanceManager.this.mPendingReactContextInitParams = null;
            }
        }

        protected void onCancelled(Result<ReactApplicationContext> reactApplicationContextResult) {
            try {
                ReactInstanceManager.this.mMemoryPressureRouter.destroy((Context)reactApplicationContextResult.get());
            }
            catch (Exception e) {
                FLog.w((String)"React", (String)"Caught exception after cancelling react context init", (Throwable)e);
            }
            finally {
                ReactInstanceManager.this.mReactContextInitAsyncTask = null;
            }
        }
    }

    private class ReactContextInitParams {
        private final JavaScriptExecutor.Factory mJsExecutorFactory;
        private final JSBundleLoader mJsBundleLoader;

        public ReactContextInitParams(JavaScriptExecutor.Factory jsExecutorFactory, JSBundleLoader jsBundleLoader) {
            this.mJsExecutorFactory = (JavaScriptExecutor.Factory)Assertions.assertNotNull((Object)jsExecutorFactory);
            this.mJsBundleLoader = (JSBundleLoader)Assertions.assertNotNull((Object)jsBundleLoader);
        }

        public JavaScriptExecutor.Factory getJsExecutorFactory() {
            return this.mJsExecutorFactory;
        }

        public JSBundleLoader getJsBundleLoader() {
            return this.mJsBundleLoader;
        }
    }

    public static interface ReactInstanceEventListener {
        public void onReactContextInitialized(ReactContext var1);
    }
}

