/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.animated;

import com.facebook.react.animated.AnimatedNode;
import com.facebook.react.animated.AnimatedNodeValueListener;
import com.facebook.react.bridge.ReadableMap;
import javax.annotation.Nullable;

class ValueAnimatedNode
extends AnimatedNode {
    double mValue = Double.NaN;
    double mOffset = 0.0;
    @Nullable
    private AnimatedNodeValueListener mValueListener;

    public ValueAnimatedNode() {
    }

    public ValueAnimatedNode(ReadableMap config) {
        this.mValue = config.getDouble("value");
        this.mOffset = config.getDouble("offset");
    }

    public double getValue() {
        return this.mOffset + this.mValue;
    }

    public void flattenOffset() {
        this.mValue += this.mOffset;
        this.mOffset = 0.0;
    }

    public void extractOffset() {
        this.mOffset += this.mValue;
        this.mValue = 0.0;
    }

    public void onValueUpdate() {
        if (this.mValueListener == null) {
            return;
        }
        this.mValueListener.onValueUpdate(this.mValue);
    }

    public void setValueListener(@Nullable AnimatedNodeValueListener listener) {
        this.mValueListener = listener;
    }
}

