/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2;

import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CaptureFailure;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.TotalCaptureResult;
import android.os.Handler;
import android.view.Surface;
import java.util.List;

public abstract class CameraCaptureSession
implements AutoCloseable {
    public abstract CameraDevice getDevice();

    public abstract void prepare(Surface var1) throws CameraAccessException;

    public abstract int capture(CaptureRequest var1, CaptureCallback var2, Handler var3) throws CameraAccessException;

    public abstract int captureBurst(List<CaptureRequest> var1, CaptureCallback var2, Handler var3) throws CameraAccessException;

    public abstract int setRepeatingRequest(CaptureRequest var1, CaptureCallback var2, Handler var3) throws CameraAccessException;

    public abstract int setRepeatingBurst(List<CaptureRequest> var1, CaptureCallback var2, Handler var3) throws CameraAccessException;

    public abstract void stopRepeating() throws CameraAccessException;

    public abstract void abortCaptures() throws CameraAccessException;

    public abstract boolean isReprocessable();

    public abstract Surface getInputSurface();

    @Override
    public abstract void close();

    public static abstract class CaptureCallback {
        public void onCaptureStarted(CameraCaptureSession session, CaptureRequest request, long timestamp, long frameNumber) {
            throw new RuntimeException("Method onCaptureStarted in android.hardware.camera2.CameraCaptureSession$CaptureCallback not mocked. See https://sites.google.com/a/android.com/tools/tech-docs/unit-testing-support for details.");
        }

        public void onCaptureProgressed(CameraCaptureSession session, CaptureRequest request, CaptureResult partialResult) {
            throw new RuntimeException("Method onCaptureProgressed in android.hardware.camera2.CameraCaptureSession$CaptureCallback not mocked. See https://sites.google.com/a/android.com/tools/tech-docs/unit-testing-support for details.");
        }

        public void onCaptureCompleted(CameraCaptureSession session, CaptureRequest request, TotalCaptureResult result) {
            throw new RuntimeException("Method onCaptureCompleted in android.hardware.camera2.CameraCaptureSession$CaptureCallback not mocked. See https://sites.google.com/a/android.com/tools/tech-docs/unit-testing-support for details.");
        }

        public void onCaptureFailed(CameraCaptureSession session, CaptureRequest request, CaptureFailure failure) {
            throw new RuntimeException("Method onCaptureFailed in android.hardware.camera2.CameraCaptureSession$CaptureCallback not mocked. See https://sites.google.com/a/android.com/tools/tech-docs/unit-testing-support for details.");
        }

        public void onCaptureSequenceCompleted(CameraCaptureSession session, int sequenceId, long frameNumber) {
            throw new RuntimeException("Method onCaptureSequenceCompleted in android.hardware.camera2.CameraCaptureSession$CaptureCallback not mocked. See https://sites.google.com/a/android.com/tools/tech-docs/unit-testing-support for details.");
        }

        public void onCaptureSequenceAborted(CameraCaptureSession session, int sequenceId) {
            throw new RuntimeException("Method onCaptureSequenceAborted in android.hardware.camera2.CameraCaptureSession$CaptureCallback not mocked. See https://sites.google.com/a/android.com/tools/tech-docs/unit-testing-support for details.");
        }
    }

    public static abstract class StateCallback {
        public abstract void onConfigured(CameraCaptureSession var1);

        public abstract void onConfigureFailed(CameraCaptureSession var1);

        public void onReady(CameraCaptureSession session) {
            throw new RuntimeException("Method onReady in android.hardware.camera2.CameraCaptureSession$StateCallback not mocked. See https://sites.google.com/a/android.com/tools/tech-docs/unit-testing-support for details.");
        }

        public void onActive(CameraCaptureSession session) {
            throw new RuntimeException("Method onActive in android.hardware.camera2.CameraCaptureSession$StateCallback not mocked. See https://sites.google.com/a/android.com/tools/tech-docs/unit-testing-support for details.");
        }

        public void onClosed(CameraCaptureSession session) {
            throw new RuntimeException("Method onClosed in android.hardware.camera2.CameraCaptureSession$StateCallback not mocked. See https://sites.google.com/a/android.com/tools/tech-docs/unit-testing-support for details.");
        }

        public void onSurfacePrepared(CameraCaptureSession session, Surface surface) {
            throw new RuntimeException("Method onSurfacePrepared in android.hardware.camera2.CameraCaptureSession$StateCallback not mocked. See https://sites.google.com/a/android.com/tools/tech-docs/unit-testing-support for details.");
        }
    }
}

