/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react;

import com.facebook.react.ReactPackage;
import com.facebook.react.bridge.JavaScriptModule;
import com.facebook.react.bridge.NativeModule;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.uimanager.ViewManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class CompositeReactPackage
implements ReactPackage {
    private final List<ReactPackage> mChildReactPackages = new ArrayList<ReactPackage>();

    public CompositeReactPackage(ReactPackage arg1, ReactPackage arg2, ReactPackage ... args) {
        this.mChildReactPackages.add(arg1);
        this.mChildReactPackages.add(arg2);
        for (ReactPackage reactPackage : args) {
            this.mChildReactPackages.add(reactPackage);
        }
    }

    @Override
    public List<NativeModule> createNativeModules(ReactApplicationContext reactContext) {
        HashMap<String, NativeModule> moduleMap = new HashMap<String, NativeModule>();
        for (ReactPackage reactPackage : this.mChildReactPackages) {
            for (NativeModule nativeModule : reactPackage.createNativeModules(reactContext)) {
                moduleMap.put(nativeModule.getName(), nativeModule);
            }
        }
        return new ArrayList<NativeModule>(moduleMap.values());
    }

    @Override
    public List<Class<? extends JavaScriptModule>> createJSModules() {
        HashSet<Class<? extends JavaScriptModule>> moduleSet = new HashSet<Class<? extends JavaScriptModule>>();
        for (ReactPackage reactPackage : this.mChildReactPackages) {
            for (Class<? extends JavaScriptModule> jsModule : reactPackage.createJSModules()) {
                moduleSet.add(jsModule);
            }
        }
        return new ArrayList<Class<? extends JavaScriptModule>>(moduleSet);
    }

    @Override
    public List<ViewManager> createViewManagers(ReactApplicationContext reactContext) {
        HashMap<String, ViewManager> viewManagerMap = new HashMap<String, ViewManager>();
        for (ReactPackage reactPackage : this.mChildReactPackages) {
            for (ViewManager viewManager : reactPackage.createViewManagers(reactContext)) {
                viewManagerMap.put(viewManager.getName(), viewManager);
            }
        }
        return new ArrayList<ViewManager>(viewManagerMap.values());
    }
}

