/*
 * Decompiled with CFR 0.152.
 */
package com.gbox.segmentanalytics;

import android.content.Context;
import android.support.annotation.Nullable;
import android.util.Log;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.ReadableMapKeySetIterator;
import com.facebook.react.bridge.ReadableType;
import com.segment.analytics.Analytics;
import com.segment.analytics.Properties;
import com.segment.analytics.Traits;

public class SegmentAnalyticsModule
extends ReactContextBaseJavaModule {
    public SegmentAnalyticsModule(ReactApplicationContext reactContext) {
        super(reactContext);
    }

    public String getName() {
        return "SegmentAnalytics";
    }

    @ReactMethod
    public void setup(String configKey) {
        try {
            Analytics analytics = new Analytics.Builder((Context)this.getReactApplicationContext(), configKey).trackApplicationLifecycleEvents().recordScreenViews().build();
            Analytics.setSingletonInstance((Analytics)analytics);
        }
        catch (Exception e) {
            Log.e((String)"SegmentAnalyticsModule", (String)e.getMessage());
        }
    }

    @ReactMethod
    public void identify(String userId, ReadableMap traits) {
        Analytics.with((Context)this.getReactApplicationContext()).identify(userId, this.toTraits(traits), null);
    }

    @ReactMethod
    public void track(String trackText, ReadableMap properties) {
        Analytics.with((Context)this.getReactApplicationContext()).track(trackText, this.toProperties(properties));
    }

    @ReactMethod
    public void screen(String screenName, ReadableMap properties) {
        Analytics.with((Context)this.getReactApplicationContext()).screen(null, screenName, this.toProperties(properties));
    }

    public Properties toProperties(@Nullable ReadableMap readableMap) {
        if (readableMap == null) {
            return null;
        }
        ReadableMapKeySetIterator iterator = readableMap.keySetIterator();
        if (!iterator.hasNextKey()) {
            return null;
        }
        Properties properties = new Properties();
        block8: while (iterator.hasNextKey()) {
            String key = iterator.nextKey();
            ReadableType readableType = readableMap.getType(key);
            switch (readableType) {
                case Null: {
                    properties.putValue(key, null);
                    continue block8;
                }
                case Boolean: {
                    properties.putValue(key, (Object)readableMap.getBoolean(key));
                    continue block8;
                }
                case Number: {
                    properties.putValue(key, (Object)readableMap.getDouble(key));
                    continue block8;
                }
                case String: {
                    properties.putValue(key, (Object)readableMap.getString(key));
                    continue block8;
                }
                case Map: {
                    properties.putValue(key, (Object)this.toProperties(readableMap.getMap(key)));
                    continue block8;
                }
                case Array: {
                    throw new UnsupportedOperationException("Arrays aren't supported yet.");
                }
            }
            throw new IllegalArgumentException("Could not convert object with key: " + key + ".");
        }
        return properties;
    }

    public Traits toTraits(@Nullable ReadableMap readableMap) {
        if (readableMap == null) {
            return null;
        }
        ReadableMapKeySetIterator iterator = readableMap.keySetIterator();
        if (!iterator.hasNextKey()) {
            return null;
        }
        Traits traits = new Traits();
        block8: while (iterator.hasNextKey()) {
            String key = iterator.nextKey();
            ReadableType readableType = readableMap.getType(key);
            switch (readableType) {
                case Null: {
                    traits.putValue(key, null);
                    continue block8;
                }
                case Boolean: {
                    traits.putValue(key, (Object)readableMap.getBoolean(key));
                    continue block8;
                }
                case Number: {
                    traits.putValue(key, (Object)readableMap.getDouble(key));
                    continue block8;
                }
                case String: {
                    traits.putValue(key, (Object)readableMap.getString(key));
                    continue block8;
                }
                case Map: {
                    traits.putValue(key, (Object)this.toTraits(readableMap.getMap(key)));
                    continue block8;
                }
                case Array: {
                    throw new UnsupportedOperationException("Arrays aren't supported yet.");
                }
            }
            throw new IllegalArgumentException("Could not convert object with key: " + key + ".");
        }
        return traits;
    }
}

