/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.internal.widget;

import android.content.Context;
import android.graphics.Rect;
import android.support.v4.view.ViewCompat;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.widget.FrameLayout;

public class ContentFrameLayout
extends FrameLayout {
    private TypedValue mMinWidthMajor;
    private TypedValue mMinWidthMinor;
    private TypedValue mFixedWidthMajor;
    private TypedValue mFixedWidthMinor;
    private TypedValue mFixedHeightMajor;
    private TypedValue mFixedHeightMinor;
    private final Rect mDecorPadding = new Rect();

    public ContentFrameLayout(Context context) {
        this(context, null);
    }

    public ContentFrameLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ContentFrameLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public void dispatchFitSystemWindows(Rect insets) {
        this.fitSystemWindows(insets);
    }

    public void setDecorPadding(int left, int top, int right, int bottom) {
        this.mDecorPadding.set(left, top, right, bottom);
        if (ViewCompat.isLaidOut((View)this)) {
            this.requestLayout();
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        DisplayMetrics metrics = this.getContext().getResources().getDisplayMetrics();
        boolean isPortrait = metrics.widthPixels < metrics.heightPixels;
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        boolean fixedWidth = false;
        if (widthMode == Integer.MIN_VALUE) {
            TypedValue tvw;
            TypedValue typedValue = tvw = isPortrait ? this.mFixedWidthMinor : this.mFixedWidthMajor;
            if (tvw != null && tvw.type != 0) {
                int w = 0;
                if (tvw.type == 5) {
                    w = (int)tvw.getDimension(metrics);
                } else if (tvw.type == 6) {
                    w = (int)tvw.getFraction((float)metrics.widthPixels, (float)metrics.widthPixels);
                }
                if (w > 0) {
                    int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
                    widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)Math.min(w -= this.mDecorPadding.left + this.mDecorPadding.right, widthSize), (int)0x40000000);
                    fixedWidth = true;
                }
            }
        }
        if (heightMode == Integer.MIN_VALUE) {
            TypedValue tvh;
            TypedValue typedValue = tvh = isPortrait ? this.mFixedHeightMajor : this.mFixedHeightMinor;
            if (tvh != null && tvh.type != 0) {
                int h = 0;
                if (tvh.type == 5) {
                    h = (int)tvh.getDimension(metrics);
                } else if (tvh.type == 6) {
                    h = (int)tvh.getFraction((float)metrics.heightPixels, (float)metrics.heightPixels);
                }
                if (h > 0) {
                    int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
                    heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)Math.min(h -= this.mDecorPadding.top + this.mDecorPadding.bottom, heightSize), (int)0x40000000);
                }
            }
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int width = this.getMeasuredWidth();
        boolean measure = false;
        widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)width, (int)0x40000000);
        if (!fixedWidth && widthMode == Integer.MIN_VALUE) {
            TypedValue tv;
            TypedValue typedValue = tv = isPortrait ? this.mMinWidthMinor : this.mMinWidthMajor;
            if (tv != null && tv.type != 0) {
                int min = 0;
                if (tv.type == 5) {
                    min = (int)tv.getDimension(metrics);
                } else if (tv.type == 6) {
                    min = (int)tv.getFraction((float)metrics.widthPixels, (float)metrics.widthPixels);
                }
                if (min > 0) {
                    min -= this.mDecorPadding.left + this.mDecorPadding.right;
                }
                if (width < min) {
                    widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)min, (int)0x40000000);
                    measure = true;
                }
            }
        }
        if (measure) {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        }
    }

    public TypedValue getMinWidthMajor() {
        if (this.mMinWidthMajor == null) {
            this.mMinWidthMajor = new TypedValue();
        }
        return this.mMinWidthMajor;
    }

    public TypedValue getMinWidthMinor() {
        if (this.mMinWidthMinor == null) {
            this.mMinWidthMinor = new TypedValue();
        }
        return this.mMinWidthMinor;
    }

    public TypedValue getFixedWidthMajor() {
        if (this.mFixedWidthMajor == null) {
            this.mFixedWidthMajor = new TypedValue();
        }
        return this.mFixedWidthMajor;
    }

    public TypedValue getFixedWidthMinor() {
        if (this.mFixedWidthMinor == null) {
            this.mFixedWidthMinor = new TypedValue();
        }
        return this.mFixedWidthMinor;
    }

    public TypedValue getFixedHeightMajor() {
        if (this.mFixedHeightMajor == null) {
            this.mFixedHeightMajor = new TypedValue();
        }
        return this.mFixedHeightMajor;
    }

    public TypedValue getFixedHeightMinor() {
        if (this.mFixedHeightMinor == null) {
            this.mFixedHeightMinor = new TypedValue();
        }
        return this.mFixedHeightMinor;
    }
}

