"use strict";

exports.__esModule = true;
exports.default = annotateAsPure;

var t = _interopRequireWildcard(require("@babel/types"));

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; return newObj; } }

var PURE_ANNOTATION = "#__PURE__";

var isPureAnnotated = function isPureAnnotated(_ref) {
  var leadingComments = _ref.leadingComments;
  return !!leadingComments && leadingComments.some(function (comment) {
    return /[@#]__PURE__/.test(comment.value);
  });
};

function annotateAsPure(pathOrNode) {
  var node = pathOrNode.node || pathOrNode;

  if (isPureAnnotated(node)) {
    return;
  }

  t.addComment(node, "leading", PURE_ANNOTATION);
}