"use strict";

exports.__esModule = true;
exports.default = void 0;

var _helperPluginUtils = require("@babel/helper-plugin-utils");

var _default = (0, _helperPluginUtils.declare)(function (api, options) {
  api.assertVersion(7);
  var spec = options.spec;
  return {
    visitor: {
      ArrowFunctionExpression: function ArrowFunctionExpression(path) {
        if (!path.isArrowFunctionExpression()) return;
        path.arrowFunctionToExpression({
          allowInsertArrow: false,
          specCompliant: !!spec
        });
      }
    }
  };
});

exports.default = _default;