"use strict";

exports.__esModule = true;
exports.visitor = void 0;

var _core = require("@babel/core");

function getTDZStatus(refPath, bindingPath) {
  var executionStatus = bindingPath._guessExecutionStatusRelativeTo(refPath);

  if (executionStatus === "before") {
    return "inside";
  } else if (executionStatus === "after") {
    return "outside";
  } else {
    return "maybe";
  }
}

function buildTDZAssert(node, state) {
  return _core.types.callExpression(state.addHelper("temporalRef"), [node, _core.types.stringLiteral(node.name)]);
}

function isReference(node, scope, state) {
  var declared = state.letReferences[node.name];
  if (!declared) return false;
  return scope.getBindingIdentifier(node.name) === declared;
}

var visitor = {
  ReferencedIdentifier: function ReferencedIdentifier(path, state) {
    if (!state.tdzEnabled) return;
    var node = path.node,
        parent = path.parent,
        scope = path.scope;
    if (path.parentPath.isFor({
      left: node
    })) return;
    if (!isReference(node, scope, state)) return;
    var bindingPath = scope.getBinding(node.name).path;
    if (bindingPath.isFunctionDeclaration()) return;
    var status = getTDZStatus(path, bindingPath);
    if (status === "inside") return;

    if (status === "maybe") {
      var assert = buildTDZAssert(node, state);
      bindingPath.parent._tdzThis = true;
      path.skip();

      if (path.parentPath.isUpdateExpression()) {
        if (parent._ignoreBlockScopingTDZ) return;
        path.parentPath.replaceWith(_core.types.sequenceExpression([assert, parent]));
      } else {
        path.replaceWith(assert);
      }
    } else if (status === "outside") {
      path.replaceWith(_core.types.throwStatement(_core.types.inherits(_core.types.newExpression(_core.types.identifier("ReferenceError"), [_core.types.stringLiteral(node.name + " is not defined - temporal dead zone")]), node)));
    }
  },
  AssignmentExpression: {
    exit: function exit(path, state) {
      if (!state.tdzEnabled) return;
      var node = path.node;
      if (node._ignoreBlockScopingTDZ) return;
      var nodes = [];
      var ids = path.getBindingIdentifiers();

      for (var name in ids) {
        var id = ids[name];

        if (isReference(id, path.scope, state)) {
          nodes.push(buildTDZAssert(id, state));
        }
      }

      if (nodes.length) {
        node._ignoreBlockScopingTDZ = true;
        nodes.push(node);
        path.replaceWithMultiple(nodes.map(_core.types.expressionStatement));
      }
    }
  }
};
exports.visitor = visitor;