/**
 * Copyright (c) 2015-present, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 */

package com.facebook.react.bridge;

import org.junit.Test;

import static org.fest.assertions.api.Assertions.assertThat;

/**
 * Tests for {@link JavaOnlyArray}
 */
public class JavaOnlyArrayTest {

  @Test
  public void testGetType() throws Exception {
    JavaOnlyArray values = JavaOnlyArray.of(
        1,
        2f,
        3.,
        "4",
        false,
        JavaOnlyArray.of(),
        JavaOnlyMap.of(),
        null);
    ReadableType[] expectedTypes = new ReadableType[] {
      ReadableType.Number,
      ReadableType.Number,
      ReadableType.Number,
      ReadableType.String,
      ReadableType.Boolean,
      ReadableType.Array,
      ReadableType.Map,
      ReadableType.Null
    };

    for (int i = 0; i < values.size(); i++) {
      assertThat(values.getType(i)).isEqualTo(expectedTypes[i]);
    }
  }
}
