/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.animated;

import com.facebook.react.animated.AnimationDriver;
import com.facebook.react.bridge.ReadableMap;

public class DecayAnimation
extends AnimationDriver {
    private final double mVelocity;
    private final double mDeceleration;
    private long mStartFrameTimeMillis = -1L;
    private double mFromValue = 0.0;
    private double mLastValue = 0.0;
    private int mIterations;
    private int mCurrentLoop;

    public DecayAnimation(ReadableMap config) {
        this.mVelocity = config.getDouble("velocity");
        this.mDeceleration = config.getDouble("deceleration");
        this.mIterations = config.hasKey("iterations") ? config.getInt("iterations") : 1;
        this.mCurrentLoop = 1;
        this.mHasFinished = this.mIterations == 0;
    }

    @Override
    public void runAnimationStep(long frameTimeNanos) {
        double value;
        long frameTimeMillis = frameTimeNanos / 1000000L;
        if (this.mStartFrameTimeMillis == -1L) {
            this.mStartFrameTimeMillis = frameTimeMillis - 16L;
            if (this.mFromValue == this.mLastValue) {
                this.mFromValue = this.mAnimatedValue.mValue;
            } else {
                this.mAnimatedValue.mValue = this.mFromValue;
            }
            this.mLastValue = this.mAnimatedValue.mValue;
        }
        if (Math.abs(this.mLastValue - (value = this.mFromValue + this.mVelocity / (1.0 - this.mDeceleration) * (1.0 - Math.exp(-(1.0 - this.mDeceleration) * (double)(frameTimeMillis - this.mStartFrameTimeMillis))))) < 0.1) {
            if (this.mIterations == -1 || this.mCurrentLoop < this.mIterations) {
                this.mStartFrameTimeMillis = -1L;
                ++this.mCurrentLoop;
            } else {
                this.mHasFinished = true;
                return;
            }
        }
        this.mLastValue = value;
        this.mAnimatedValue.mValue = value;
    }
}

