/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.bridge;

import java.io.Closeable;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayDeque;
import java.util.Deque;

public class JsonWriter
implements Closeable {
    private final Writer mWriter;
    private final Deque<Scope> mScopes;

    public JsonWriter(Writer writer) {
        this.mWriter = writer;
        this.mScopes = new ArrayDeque<Scope>();
    }

    public JsonWriter beginArray() throws IOException {
        this.open(Scope.EMPTY_ARRAY, '[');
        return this;
    }

    public JsonWriter endArray() throws IOException {
        this.close(']');
        return this;
    }

    public JsonWriter beginObject() throws IOException {
        this.open(Scope.EMPTY_OBJECT, '{');
        return this;
    }

    public JsonWriter endObject() throws IOException {
        this.close('}');
        return this;
    }

    public JsonWriter name(String name) throws IOException {
        if (name == null) {
            throw new NullPointerException("name can not be null");
        }
        this.beforeName();
        this.string(name);
        this.mWriter.write(58);
        return this;
    }

    public JsonWriter value(String value) throws IOException {
        if (value == null) {
            return this.nullValue();
        }
        this.beforeValue();
        this.string(value);
        return this;
    }

    public JsonWriter nullValue() throws IOException {
        this.beforeValue();
        this.mWriter.write("null");
        return this;
    }

    public JsonWriter rawValue(String json) throws IOException {
        this.beforeValue();
        this.mWriter.write(json);
        return this;
    }

    public JsonWriter value(boolean value) throws IOException {
        this.beforeValue();
        this.mWriter.write(value ? "true" : "false");
        return this;
    }

    public JsonWriter value(double value) throws IOException {
        this.beforeValue();
        this.mWriter.append(Double.toString(value));
        return this;
    }

    public JsonWriter value(long value) throws IOException {
        this.beforeValue();
        this.mWriter.write(Long.toString(value));
        return this;
    }

    public JsonWriter value(Number value) throws IOException {
        if (value == null) {
            return this.nullValue();
        }
        this.beforeValue();
        this.mWriter.append(value.toString());
        return this;
    }

    @Override
    public void close() throws IOException {
        this.mWriter.close();
    }

    private void beforeValue() throws IOException {
        Scope scope = this.mScopes.peek();
        switch (scope) {
            case EMPTY_ARRAY: {
                this.replace(Scope.ARRAY);
                break;
            }
            case EMPTY_OBJECT: {
                throw new IllegalArgumentException(Scope.EMPTY_OBJECT.name());
            }
            case ARRAY: {
                this.mWriter.write(44);
                break;
            }
            case OBJECT: {
                break;
            }
            default: {
                throw new IllegalStateException("Unknown scope: " + (Object)((Object)scope));
            }
        }
    }

    private void beforeName() throws IOException {
        Scope scope = this.mScopes.peek();
        switch (scope) {
            case EMPTY_ARRAY: 
            case ARRAY: {
                throw new IllegalStateException("name not allowed in array");
            }
            case EMPTY_OBJECT: {
                this.replace(Scope.OBJECT);
                break;
            }
            case OBJECT: {
                this.mWriter.write(44);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown scope: " + (Object)((Object)scope));
            }
        }
    }

    private void open(Scope scope, char bracket) throws IOException {
        this.mScopes.push(scope);
        this.mWriter.write(bracket);
    }

    private void close(char bracket) throws IOException {
        this.mScopes.pop();
        this.mWriter.write(bracket);
    }

    private void string(String string2) throws IOException {
        this.mWriter.write(34);
        int length = string2.length();
        block9: for (int i = 0; i < length; ++i) {
            char c = string2.charAt(i);
            switch (c) {
                case '\t': {
                    this.mWriter.write("\\t");
                    continue block9;
                }
                case '\b': {
                    this.mWriter.write("\\b");
                    continue block9;
                }
                case '\n': {
                    this.mWriter.write("\\n");
                    continue block9;
                }
                case '\r': {
                    this.mWriter.write("\\r");
                    continue block9;
                }
                case '\f': {
                    this.mWriter.write("\\f");
                    continue block9;
                }
                case '\"': 
                case '\\': {
                    this.mWriter.write(92);
                    this.mWriter.write(c);
                    continue block9;
                }
                case '\u2028': 
                case '\u2029': {
                    this.mWriter.write(String.format("\\u%04x", c));
                    continue block9;
                }
                default: {
                    if (c <= '\u001f') {
                        this.mWriter.write(String.format("\\u%04x", c));
                        continue block9;
                    }
                    this.mWriter.write(c);
                }
            }
        }
        this.mWriter.write(34);
    }

    private void replace(Scope scope) {
        this.mScopes.pop();
        this.mScopes.push(scope);
    }

    private static enum Scope {
        EMPTY_OBJECT,
        OBJECT,
        EMPTY_ARRAY,
        ARRAY;

    }
}

