/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.bridge;

import com.facebook.infer.annotation.Assertions;
import com.facebook.jni.HybridData;
import com.facebook.proguard.annotations.DoNotStrip;
import com.facebook.react.bridge.Dynamic;
import com.facebook.react.bridge.DynamicFromMap;
import com.facebook.react.bridge.NativeMap;
import com.facebook.react.bridge.NoSuchKeyException;
import com.facebook.react.bridge.ReactBridge;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.ReadableMapKeySetIterator;
import com.facebook.react.bridge.ReadableNativeArray;
import com.facebook.react.bridge.ReadableType;
import java.util.HashMap;
import javax.annotation.Nullable;

@DoNotStrip
public class ReadableNativeMap
extends NativeMap
implements ReadableMap {
    @Nullable
    private String[] mKeys;
    @Nullable
    private HashMap<String, Object> mLocalMap;
    @Nullable
    private HashMap<String, ReadableType> mLocalTypeMap;
    private static boolean mUseNativeAccessor;
    private static int mJniCallCounter;

    protected ReadableNativeMap(HybridData hybridData) {
        super(hybridData);
    }

    public static void setUseNativeAccessor(boolean useNativeAccessor) {
        mUseNativeAccessor = useNativeAccessor;
    }

    public static int getJNIPassCounter() {
        return mJniCallCounter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap<String, Object> getLocalMap() {
        if (this.mLocalMap != null) {
            return this.mLocalMap;
        }
        ReadableNativeMap readableNativeMap = this;
        synchronized (readableNativeMap) {
            if (this.mKeys == null) {
                this.mKeys = (String[])Assertions.assertNotNull((Object)this.importKeys());
                ++mJniCallCounter;
            }
            if (this.mLocalMap == null) {
                Object[] values = (Object[])Assertions.assertNotNull((Object)this.importValues());
                ++mJniCallCounter;
                this.mLocalMap = new HashMap();
                for (int i = 0; i < this.mKeys.length; ++i) {
                    this.mLocalMap.put(this.mKeys[i], values[i]);
                }
            }
        }
        return this.mLocalMap;
    }

    private native String[] importKeys();

    private native Object[] importValues();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap<String, ReadableType> getLocalTypeMap() {
        if (this.mLocalTypeMap != null) {
            return this.mLocalTypeMap;
        }
        ReadableNativeMap readableNativeMap = this;
        synchronized (readableNativeMap) {
            if (this.mKeys == null) {
                this.mKeys = (String[])Assertions.assertNotNull((Object)this.importKeys());
                ++mJniCallCounter;
            }
            if (this.mLocalTypeMap == null) {
                Object[] types = (Object[])Assertions.assertNotNull((Object)this.importTypes());
                ++mJniCallCounter;
                this.mLocalTypeMap = new HashMap();
                for (int i = 0; i < this.mKeys.length; ++i) {
                    this.mLocalTypeMap.put(this.mKeys[i], (ReadableType)((Object)types[i]));
                }
            }
        }
        return this.mLocalTypeMap;
    }

    private native Object[] importTypes();

    @Override
    public boolean hasKey(String name) {
        if (mUseNativeAccessor) {
            ++mJniCallCounter;
            return this.hasKeyNative(name);
        }
        return this.getLocalMap().containsKey(name);
    }

    private native boolean hasKeyNative(String var1);

    @Override
    public boolean isNull(String name) {
        if (mUseNativeAccessor) {
            ++mJniCallCounter;
            return this.isNullNative(name);
        }
        if (this.getLocalMap().containsKey(name)) {
            return this.getLocalMap().get(name) == null;
        }
        throw new NoSuchKeyException(name);
    }

    private native boolean isNullNative(String var1);

    private Object getValue(String name) {
        if (this.hasKey(name) && !this.isNull(name)) {
            return Assertions.assertNotNull((Object)this.getLocalMap().get(name));
        }
        throw new NoSuchKeyException(name);
    }

    @Nullable
    private Object getNullableValue(String name) {
        if (this.hasKey(name)) {
            return this.getLocalMap().get(name);
        }
        throw new NoSuchKeyException(name);
    }

    @Override
    public boolean getBoolean(String name) {
        if (mUseNativeAccessor) {
            ++mJniCallCounter;
            return this.getBooleanNative(name);
        }
        return (Boolean)this.getValue(name);
    }

    private native boolean getBooleanNative(String var1);

    @Override
    public double getDouble(String name) {
        if (mUseNativeAccessor) {
            ++mJniCallCounter;
            return this.getDoubleNative(name);
        }
        return (Double)this.getValue(name);
    }

    private native double getDoubleNative(String var1);

    @Override
    public int getInt(String name) {
        if (mUseNativeAccessor) {
            ++mJniCallCounter;
            return this.getIntNative(name);
        }
        return ((Double)this.getValue(name)).intValue();
    }

    private native int getIntNative(String var1);

    @Override
    @Nullable
    public String getString(String name) {
        if (mUseNativeAccessor) {
            ++mJniCallCounter;
            return this.getStringNative(name);
        }
        return (String)this.getNullableValue(name);
    }

    private native String getStringNative(String var1);

    @Override
    @Nullable
    public ReadableArray getArray(String name) {
        if (mUseNativeAccessor) {
            ++mJniCallCounter;
            return this.getArrayNative(name);
        }
        return (ReadableArray)this.getNullableValue(name);
    }

    private native ReadableNativeArray getArrayNative(String var1);

    @Override
    @Nullable
    public ReadableNativeMap getMap(String name) {
        if (mUseNativeAccessor) {
            ++mJniCallCounter;
            return this.getMapNative(name);
        }
        return (ReadableNativeMap)this.getNullableValue(name);
    }

    private native ReadableNativeMap getMapNative(String var1);

    @Override
    public ReadableType getType(String name) {
        if (mUseNativeAccessor) {
            ++mJniCallCounter;
            return this.getTypeNative(name);
        }
        if (this.getLocalTypeMap().containsKey(name)) {
            return (ReadableType)((Object)Assertions.assertNotNull((Object)((Object)this.getLocalTypeMap().get(name))));
        }
        throw new NoSuchKeyException(name);
    }

    private native ReadableType getTypeNative(String var1);

    @Override
    public Dynamic getDynamic(String name) {
        return DynamicFromMap.create(this, name);
    }

    @Override
    public ReadableMapKeySetIterator keySetIterator() {
        return new ReadableNativeMapKeySetIterator(this);
    }

    @Override
    public HashMap<String, Object> toHashMap() {
        if (mUseNativeAccessor) {
            ReadableMapKeySetIterator iterator = this.keySetIterator();
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            block8: while (iterator.hasNextKey()) {
                ++mJniCallCounter;
                String key = iterator.nextKey();
                ++mJniCallCounter;
                switch (this.getType(key)) {
                    case Null: {
                        hashMap.put(key, null);
                        continue block8;
                    }
                    case Boolean: {
                        hashMap.put(key, this.getBoolean(key));
                        continue block8;
                    }
                    case Number: {
                        hashMap.put(key, this.getDouble(key));
                        continue block8;
                    }
                    case String: {
                        hashMap.put(key, this.getString(key));
                        continue block8;
                    }
                    case Map: {
                        hashMap.put(key, ((ReadableNativeMap)Assertions.assertNotNull((Object)this.getMap(key))).toHashMap());
                        continue block8;
                    }
                    case Array: {
                        hashMap.put(key, ((ReadableArray)Assertions.assertNotNull((Object)this.getArray(key))).toArrayList());
                        continue block8;
                    }
                }
                throw new IllegalArgumentException("Could not convert object with key: " + key + ".");
            }
            return hashMap;
        }
        return this.getLocalMap();
    }

    static {
        ReactBridge.staticInit();
    }

    @DoNotStrip
    private static class ReadableNativeMapKeySetIterator
    implements ReadableMapKeySetIterator {
        @DoNotStrip
        private final HybridData mHybridData;
        @DoNotStrip
        private final ReadableNativeMap mMap;

        public ReadableNativeMapKeySetIterator(ReadableNativeMap readableNativeMap) {
            this.mMap = readableNativeMap;
            this.mHybridData = ReadableNativeMapKeySetIterator.initHybrid(readableNativeMap);
        }

        @Override
        public native boolean hasNextKey();

        @Override
        public native String nextKey();

        private static native HybridData initHybrid(ReadableNativeMap var0);
    }
}

