"use strict";

exports.__esModule = true;
exports.default = void 0;

var _helperPluginUtils = require("@babel/helper-plugin-utils");

var _core = require("@babel/core");

var _default = (0, _helperPluginUtils.declare)(function (api, options) {
  api.assertVersion(7);
  var loose = options.loose;
  var pushComputedProps = loose ? pushComputedPropsLoose : pushComputedPropsSpec;
  var buildMutatorMapAssign = (0, _core.template)("\n    MUTATOR_MAP_REF[KEY] = MUTATOR_MAP_REF[KEY] || {};\n    MUTATOR_MAP_REF[KEY].KIND = VALUE;\n  ");

  function getValue(prop) {
    if (_core.types.isObjectProperty(prop)) {
      return prop.value;
    } else if (_core.types.isObjectMethod(prop)) {
      return _core.types.functionExpression(null, prop.params, prop.body, prop.generator, prop.async);
    }
  }

  function pushAssign(objId, prop, body) {
    if (prop.kind === "get" && prop.kind === "set") {
      pushMutatorDefine(objId, prop, body);
    } else {
      body.push(_core.types.expressionStatement(_core.types.assignmentExpression("=", _core.types.memberExpression(_core.types.cloneNode(objId), prop.key, prop.computed || _core.types.isLiteral(prop.key)), getValue(prop))));
    }
  }

  function pushMutatorDefine(_ref, prop) {
    var body = _ref.body,
        getMutatorId = _ref.getMutatorId,
        scope = _ref.scope;
    var key = !prop.computed && _core.types.isIdentifier(prop.key) ? _core.types.stringLiteral(prop.key.name) : prop.key;
    var maybeMemoise = scope.maybeGenerateMemoised(key);

    if (maybeMemoise) {
      body.push(_core.types.expressionStatement(_core.types.assignmentExpression("=", maybeMemoise, key)));
      key = maybeMemoise;
    }

    body.push.apply(body, buildMutatorMapAssign({
      MUTATOR_MAP_REF: getMutatorId(),
      KEY: _core.types.cloneNode(key),
      VALUE: getValue(prop),
      KIND: _core.types.identifier(prop.kind)
    }));
  }

  function pushComputedPropsLoose(info) {
    for (var _iterator = info.computedProps, _isArray = Array.isArray(_iterator), _i = 0, _iterator = _isArray ? _iterator : _iterator[Symbol.iterator]();;) {
      var _ref2;

      if (_isArray) {
        if (_i >= _iterator.length) break;
        _ref2 = _iterator[_i++];
      } else {
        _i = _iterator.next();
        if (_i.done) break;
        _ref2 = _i.value;
      }

      var _prop = _ref2;

      if (_prop.kind === "get" || _prop.kind === "set") {
        pushMutatorDefine(info, _prop);
      } else {
        pushAssign(_core.types.cloneNode(info.objId), _prop, info.body);
      }
    }
  }

  function pushComputedPropsSpec(info) {
    var objId = info.objId,
        body = info.body,
        computedProps = info.computedProps,
        state = info.state;

    for (var _iterator2 = computedProps, _isArray2 = Array.isArray(_iterator2), _i2 = 0, _iterator2 = _isArray2 ? _iterator2 : _iterator2[Symbol.iterator]();;) {
      var _ref3;

      if (_isArray2) {
        if (_i2 >= _iterator2.length) break;
        _ref3 = _iterator2[_i2++];
      } else {
        _i2 = _iterator2.next();
        if (_i2.done) break;
        _ref3 = _i2.value;
      }

      var _prop2 = _ref3;

      var key = _core.types.toComputedKey(_prop2);

      if (_prop2.kind === "get" || _prop2.kind === "set") {
        pushMutatorDefine(info, _prop2);
      } else if (_core.types.isStringLiteral(key, {
        value: "__proto__"
      })) {
        pushAssign(objId, _prop2, body);
      } else {
        if (computedProps.length === 1) {
          return _core.types.callExpression(state.addHelper("defineProperty"), [info.initPropExpression, key, getValue(_prop2)]);
        } else {
          body.push(_core.types.expressionStatement(_core.types.callExpression(state.addHelper("defineProperty"), [_core.types.cloneNode(objId), key, getValue(_prop2)])));
        }
      }
    }
  }

  return {
    visitor: {
      ObjectExpression: {
        exit: function exit(path, state) {
          var node = path.node,
              parent = path.parent,
              scope = path.scope;
          var hasComputed = false;
          var _arr = node.properties;

          for (var _i3 = 0; _i3 < _arr.length; _i3++) {
            var prop = _arr[_i3];
            hasComputed = prop.computed === true;
            if (hasComputed) break;
          }

          if (!hasComputed) return;
          var initProps = [];
          var computedProps = [];
          var foundComputed = false;

          for (var _iterator3 = node.properties, _isArray3 = Array.isArray(_iterator3), _i4 = 0, _iterator3 = _isArray3 ? _iterator3 : _iterator3[Symbol.iterator]();;) {
            var _ref4;

            if (_isArray3) {
              if (_i4 >= _iterator3.length) break;
              _ref4 = _iterator3[_i4++];
            } else {
              _i4 = _iterator3.next();
              if (_i4.done) break;
              _ref4 = _i4.value;
            }

            var _prop4 = _ref4;

            if (_prop4.computed) {
              foundComputed = true;
            }

            if (foundComputed) {
              computedProps.push(_prop4);
            } else {
              initProps.push(_prop4);
            }
          }

          var objId = scope.generateUidIdentifierBasedOnNode(parent);

          var initPropExpression = _core.types.objectExpression(initProps);

          var body = [];
          body.push(_core.types.variableDeclaration("var", [_core.types.variableDeclarator(objId, initPropExpression)]));
          var mutatorRef;

          var getMutatorId = function getMutatorId() {
            if (!mutatorRef) {
              mutatorRef = scope.generateUidIdentifier("mutatorMap");
              body.push(_core.types.variableDeclaration("var", [_core.types.variableDeclarator(mutatorRef, _core.types.objectExpression([]))]));
            }

            return _core.types.cloneNode(mutatorRef);
          };

          var single = pushComputedProps({
            scope: scope,
            objId: objId,
            body: body,
            computedProps: computedProps,
            initPropExpression: initPropExpression,
            getMutatorId: getMutatorId,
            state: state
          });

          if (mutatorRef) {
            body.push(_core.types.expressionStatement(_core.types.callExpression(state.addHelper("defineEnumerableProperties"), [_core.types.cloneNode(objId), _core.types.cloneNode(mutatorRef)])));
          }

          if (single) {
            path.replaceWith(single);
          } else {
            body.push(_core.types.expressionStatement(_core.types.cloneNode(objId)));
            path.replaceWithMultiple(body);
          }
        }
      }
    }
  };
});

exports.default = _default;