/**
 * Copyright (c) 2015-present, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 */

const fs = require('fs-extra');
const path = require('path');
const groupFilesByType = require('../groupFilesByType');

/**
 * Copies each file from an array of assets provided to targetPath directory
 *
 * For now, the only types of files that are handled are:
 * - Fonts (otf, ttf) - copied to targetPath/fonts under original name
 */
module.exports = function unlinkAssetsAndroid(files, project) {
  const assets = groupFilesByType(files);

  (assets.font || []).forEach((file) => {
    const filePath = path.join(project.assetsPath, 'fonts', path.basename(file));
    if (fs.existsSync(filePath)) {
      fs.unlinkSync(filePath);
    }
  });
};
