/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;
import com.facebook.common.logging.FLog;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.CoreModulesPackage;
import com.facebook.react.JSCConfig;
import com.facebook.react.LifecycleState;
import com.facebook.react.MemoryPressureRouter;
import com.facebook.react.ReactInstanceManager;
import com.facebook.react.ReactPackage;
import com.facebook.react.ReactRootView;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.CatalystInstance;
import com.facebook.react.bridge.CatalystInstanceImpl;
import com.facebook.react.bridge.JSBundleLoader;
import com.facebook.react.bridge.JSCJavaScriptExecutor;
import com.facebook.react.bridge.JavaJSExecutor;
import com.facebook.react.bridge.JavaScriptExecutor;
import com.facebook.react.bridge.JavaScriptModulesConfig;
import com.facebook.react.bridge.NativeModule;
import com.facebook.react.bridge.NativeModuleCallExceptionHandler;
import com.facebook.react.bridge.NativeModuleRegistry;
import com.facebook.react.bridge.NotThreadSafeBridgeIdleDebugListener;
import com.facebook.react.bridge.ProxyJavaScriptExecutor;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.ReactMarker;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.bridge.WritableNativeMap;
import com.facebook.react.bridge.queue.ReactQueueConfigurationSpec;
import com.facebook.react.common.ApplicationHolder;
import com.facebook.react.common.annotations.VisibleForTesting;
import com.facebook.react.devsupport.DevServerHelper;
import com.facebook.react.devsupport.DevSupportManager;
import com.facebook.react.devsupport.DevSupportManagerFactory;
import com.facebook.react.devsupport.ReactInstanceDevCommandsHandler;
import com.facebook.react.modules.core.DefaultHardwareBackBtnHandler;
import com.facebook.react.modules.core.DeviceEventManagerModule;
import com.facebook.react.uimanager.AppRegistry;
import com.facebook.react.uimanager.DisplayMetricsHolder;
import com.facebook.react.uimanager.UIImplementationProvider;
import com.facebook.react.uimanager.UIManagerModule;
import com.facebook.react.uimanager.ViewManager;
import com.facebook.soloader.SoLoader;
import com.facebook.systrace.Systrace;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;

class ReactInstanceManagerImpl
extends ReactInstanceManager {
    private final List<ReactRootView> mAttachedRootViews = new ArrayList<ReactRootView>();
    private LifecycleState mLifecycleState;
    @Nullable
    private ReactContextInitParams mPendingReactContextInitParams;
    @Nullable
    private ReactContextInitAsyncTask mReactContextInitAsyncTask;
    @Nullable
    private String mJSBundleFile;
    @Nullable
    private final String mJSMainModuleName;
    private final List<ReactPackage> mPackages;
    private final DevSupportManager mDevSupportManager;
    private final boolean mUseDeveloperSupport;
    @Nullable
    private final NotThreadSafeBridgeIdleDebugListener mBridgeIdleDebugListener;
    @Nullable
    private volatile ReactContext mCurrentReactContext;
    private final Context mApplicationContext;
    @Nullable
    private DefaultHardwareBackBtnHandler mDefaultBackButtonImpl;
    private String mSourceUrl;
    @Nullable
    private Activity mCurrentActivity;
    private final Collection<ReactInstanceManager.ReactInstanceEventListener> mReactInstanceEventListeners = Collections.synchronizedSet(new HashSet());
    private volatile boolean mHasStartedCreatingInitialContext = false;
    private final UIImplementationProvider mUIImplementationProvider;
    private final MemoryPressureRouter mMemoryPressureRouter;
    @Nullable
    private final NativeModuleCallExceptionHandler mNativeModuleCallExceptionHandler;
    @Nullable
    private final JSCConfig mJSCConfig;
    private final ReactInstanceDevCommandsHandler mDevInterface = new ReactInstanceDevCommandsHandler(){

        @Override
        public void onReloadWithJSDebugger(JavaJSExecutor.Factory jsExecutorFactory) {
            ReactInstanceManagerImpl.this.onReloadWithJSDebugger(jsExecutorFactory);
        }

        @Override
        public void onJSBundleLoadedFromServer() {
            ReactInstanceManagerImpl.this.onJSBundleLoadedFromServer();
        }

        @Override
        public void toggleElementInspector() {
            ReactInstanceManagerImpl.this.toggleElementInspector();
        }
    };
    private final DefaultHardwareBackBtnHandler mBackBtnHandler = new DefaultHardwareBackBtnHandler(){

        @Override
        public void invokeDefaultOnBackPressed() {
            ReactInstanceManagerImpl.this.invokeDefaultOnBackPressed();
        }
    };

    ReactInstanceManagerImpl(Context applicationContext, @Nullable String jsBundleFile, @Nullable String jsMainModuleName, List<ReactPackage> packages, boolean useDeveloperSupport, @Nullable NotThreadSafeBridgeIdleDebugListener bridgeIdleDebugListener, LifecycleState initialLifecycleState, UIImplementationProvider uiImplementationProvider, NativeModuleCallExceptionHandler nativeModuleCallExceptionHandler, @Nullable JSCConfig jscConfig) {
        ReactInstanceManagerImpl.initializeSoLoaderIfNecessary(applicationContext);
        ApplicationHolder.setApplication((Application)applicationContext.getApplicationContext());
        ReactInstanceManagerImpl.setDisplayMetrics(applicationContext);
        this.mApplicationContext = applicationContext;
        this.mJSBundleFile = jsBundleFile;
        this.mJSMainModuleName = jsMainModuleName;
        this.mPackages = packages;
        this.mUseDeveloperSupport = useDeveloperSupport;
        this.mDevSupportManager = DevSupportManagerFactory.create(applicationContext, this.mDevInterface, this.mJSMainModuleName, useDeveloperSupport);
        this.mBridgeIdleDebugListener = bridgeIdleDebugListener;
        this.mLifecycleState = initialLifecycleState;
        this.mUIImplementationProvider = uiImplementationProvider;
        this.mMemoryPressureRouter = new MemoryPressureRouter(applicationContext);
        this.mNativeModuleCallExceptionHandler = nativeModuleCallExceptionHandler;
        this.mJSCConfig = jscConfig;
    }

    @Override
    public DevSupportManager getDevSupportManager() {
        return this.mDevSupportManager;
    }

    @Override
    public MemoryPressureRouter getMemoryPressureRouter() {
        return this.mMemoryPressureRouter;
    }

    private static void initializeSoLoaderIfNecessary(Context applicationContext) {
        SoLoader.init(applicationContext, false);
    }

    private static void setDisplayMetrics(Context context) {
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        DisplayMetricsHolder.setWindowDisplayMetrics(displayMetrics);
        DisplayMetrics screenDisplayMetrics = new DisplayMetrics();
        screenDisplayMetrics.setTo(displayMetrics);
        WindowManager wm = (WindowManager)context.getSystemService("window");
        Display display = wm.getDefaultDisplay();
        if (Build.VERSION.SDK_INT >= 17) {
            display.getRealMetrics(screenDisplayMetrics);
        } else {
            try {
                Method mGetRawH = Display.class.getMethod("getRawHeight", new Class[0]);
                Method mGetRawW = Display.class.getMethod("getRawWidth", new Class[0]);
                screenDisplayMetrics.widthPixels = (Integer)mGetRawW.invoke((Object)display, new Object[0]);
                screenDisplayMetrics.heightPixels = (Integer)mGetRawH.invoke((Object)display, new Object[0]);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException("Error getting real dimensions for API level < 17", e);
            }
        }
        DisplayMetricsHolder.setScreenDisplayMetrics(screenDisplayMetrics);
    }

    @Override
    public void createReactContextInBackground() {
        Assertions.assertCondition((!this.mHasStartedCreatingInitialContext ? 1 : 0) != 0, (String)"createReactContextInBackground should only be called when creating the react application for the first time. When reloading JS, e.g. from a new file, explicitlyuse recreateReactContextInBackground");
        this.mHasStartedCreatingInitialContext = true;
        this.recreateReactContextInBackgroundInner();
    }

    public void recreateReactContextInBackground() {
        Assertions.assertCondition((boolean)this.mHasStartedCreatingInitialContext, (String)"recreateReactContextInBackground should only be called after the initial createReactContextInBackground call.");
        this.recreateReactContextInBackgroundInner();
    }

    private void recreateReactContextInBackgroundInner() {
        UiThreadUtil.assertOnUiThread();
        if (this.mUseDeveloperSupport && this.mJSMainModuleName != null) {
            if (this.mDevSupportManager.hasUpToDateJSBundleInCache()) {
                this.onJSBundleLoadedFromServer();
            } else if (this.mJSBundleFile == null) {
                this.mDevSupportManager.handleReloadJS();
            } else {
                this.mDevSupportManager.isPackagerRunning(new DevServerHelper.PackagerStatusCallback(){

                    @Override
                    public void onPackagerStatusFetched(final boolean packagerIsRunning) {
                        UiThreadUtil.runOnUiThread(new Runnable(){

                            @Override
                            public void run() {
                                if (packagerIsRunning) {
                                    ReactInstanceManagerImpl.this.mDevSupportManager.handleReloadJS();
                                } else {
                                    ReactInstanceManagerImpl.this.recreateReactContextInBackgroundFromBundleFile();
                                }
                            }
                        });
                    }
                });
            }
            return;
        }
        this.recreateReactContextInBackgroundFromBundleFile();
    }

    private void recreateReactContextInBackgroundFromBundleFile() {
        this.recreateReactContextInBackground(new JSCJavaScriptExecutor.Factory(), JSBundleLoader.createFileLoader(this.mApplicationContext, this.mJSBundleFile));
    }

    @Override
    public boolean hasStartedCreatingInitialContext() {
        return this.mHasStartedCreatingInitialContext;
    }

    @Override
    public void onBackPressed() {
        UiThreadUtil.assertOnUiThread();
        ReactContext reactContext = this.mCurrentReactContext;
        if (this.mCurrentReactContext == null) {
            FLog.w((String)"React", (String)"Instance detached from instance manager");
            this.invokeDefaultOnBackPressed();
        } else {
            DeviceEventManagerModule deviceEventManagerModule = ((ReactContext)((Object)Assertions.assertNotNull((Object)((Object)reactContext)))).getNativeModule(DeviceEventManagerModule.class);
            deviceEventManagerModule.emitHardwareBackPressed();
        }
    }

    private void invokeDefaultOnBackPressed() {
        UiThreadUtil.assertOnUiThread();
        if (this.mDefaultBackButtonImpl != null) {
            this.mDefaultBackButtonImpl.invokeDefaultOnBackPressed();
        }
    }

    private void toggleElementInspector() {
        if (this.mCurrentReactContext != null) {
            this.mCurrentReactContext.getJSModule(DeviceEventManagerModule.RCTDeviceEventEmitter.class).emit("toggleElementInspector", null);
        }
    }

    @Override
    public void onHostPause() {
        UiThreadUtil.assertOnUiThread();
        this.mDefaultBackButtonImpl = null;
        if (this.mUseDeveloperSupport) {
            this.mDevSupportManager.setDevSupportEnabled(false);
        }
        this.moveToBeforeResumeLifecycleState();
        this.mCurrentActivity = null;
    }

    @Override
    public void onHostResume(Activity activity, DefaultHardwareBackBtnHandler defaultBackButtonImpl) {
        UiThreadUtil.assertOnUiThread();
        this.mDefaultBackButtonImpl = defaultBackButtonImpl;
        if (this.mUseDeveloperSupport) {
            this.mDevSupportManager.setDevSupportEnabled(true);
        }
        this.mCurrentActivity = activity;
        this.moveToResumedLifecycleState(false);
    }

    @Override
    public void onHostDestroy() {
        UiThreadUtil.assertOnUiThread();
        if (this.mUseDeveloperSupport) {
            this.mDevSupportManager.setDevSupportEnabled(false);
        }
        this.moveToBeforeCreateLifecycleState();
        this.mCurrentActivity = null;
    }

    @Override
    public void destroy() {
        UiThreadUtil.assertOnUiThread();
        if (this.mUseDeveloperSupport) {
            this.mDevSupportManager.setDevSupportEnabled(false);
        }
        this.moveToBeforeCreateLifecycleState();
        if (this.mReactContextInitAsyncTask != null) {
            this.mReactContextInitAsyncTask.cancel(true);
        }
        this.mMemoryPressureRouter.destroy(this.mApplicationContext);
        if (this.mCurrentReactContext != null) {
            this.mCurrentReactContext.destroy();
            this.mCurrentReactContext = null;
            this.mHasStartedCreatingInitialContext = false;
        }
        this.mCurrentActivity = null;
    }

    private void moveToResumedLifecycleState(boolean force) {
        if (this.mCurrentReactContext != null && (force || this.mLifecycleState == LifecycleState.BEFORE_RESUME || this.mLifecycleState == LifecycleState.BEFORE_CREATE)) {
            this.mCurrentReactContext.onHostResume(this.mCurrentActivity);
        }
        this.mLifecycleState = LifecycleState.RESUMED;
    }

    private void moveToBeforeResumeLifecycleState() {
        if (this.mCurrentReactContext != null) {
            if (this.mLifecycleState == LifecycleState.BEFORE_CREATE) {
                this.mCurrentReactContext.onHostResume(this.mCurrentActivity);
                this.mCurrentReactContext.onHostPause();
            } else if (this.mLifecycleState == LifecycleState.RESUMED) {
                this.mCurrentReactContext.onHostPause();
            }
        }
        this.mLifecycleState = LifecycleState.BEFORE_RESUME;
    }

    private void moveToBeforeCreateLifecycleState() {
        if (this.mCurrentReactContext != null) {
            if (this.mLifecycleState == LifecycleState.RESUMED) {
                this.mCurrentReactContext.onHostPause();
                this.mLifecycleState = LifecycleState.BEFORE_RESUME;
            }
            if (this.mLifecycleState == LifecycleState.BEFORE_RESUME) {
                this.mCurrentReactContext.onHostDestroy();
            }
        }
        this.mLifecycleState = LifecycleState.BEFORE_CREATE;
    }

    @Override
    public LifecycleState getLifecycleState() {
        return this.mLifecycleState;
    }

    @Override
    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (this.mCurrentReactContext != null) {
            this.mCurrentReactContext.onActivityResult(requestCode, resultCode, data);
        }
    }

    @Override
    public void showDevOptionsDialog() {
        UiThreadUtil.assertOnUiThread();
        this.mDevSupportManager.showDevOptionsDialog();
    }

    @Override
    public String getSourceUrl() {
        return (String)Assertions.assertNotNull((Object)this.mSourceUrl);
    }

    @Override
    public void attachMeasuredRootView(ReactRootView rootView) {
        UiThreadUtil.assertOnUiThread();
        this.mAttachedRootViews.add(rootView);
        if (this.mReactContextInitAsyncTask == null && this.mCurrentReactContext != null) {
            this.attachMeasuredRootViewToInstance(rootView, this.mCurrentReactContext.getCatalystInstance());
        }
    }

    @Override
    public void detachRootView(ReactRootView rootView) {
        UiThreadUtil.assertOnUiThread();
        if (this.mAttachedRootViews.remove(rootView) && this.mCurrentReactContext != null && this.mCurrentReactContext.hasActiveCatalystInstance()) {
            this.detachViewFromInstance(rootView, this.mCurrentReactContext.getCatalystInstance());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ViewManager> createAllViewManagers(ReactApplicationContext catalystApplicationContext) {
        Systrace.beginSection(0L, "createAllViewManagers");
        try {
            ArrayList<ViewManager> allViewManagers = new ArrayList<ViewManager>();
            for (ReactPackage reactPackage : this.mPackages) {
                allViewManagers.addAll(reactPackage.createViewManagers(catalystApplicationContext));
            }
            ArrayList<ViewManager> arrayList = allViewManagers;
            return arrayList;
        }
        finally {
            Systrace.endSection(0L);
        }
    }

    @Override
    public void addReactInstanceEventListener(ReactInstanceManager.ReactInstanceEventListener listener) {
        this.mReactInstanceEventListeners.add(listener);
    }

    @Override
    public void removeReactInstanceEventListener(ReactInstanceManager.ReactInstanceEventListener listener) {
        this.mReactInstanceEventListeners.remove(listener);
    }

    @Override
    @Nullable
    @VisibleForTesting
    public ReactContext getCurrentReactContext() {
        return this.mCurrentReactContext;
    }

    private void onReloadWithJSDebugger(JavaJSExecutor.Factory jsExecutorFactory) {
        this.recreateReactContextInBackground(new ProxyJavaScriptExecutor.Factory(jsExecutorFactory), JSBundleLoader.createRemoteDebuggerBundleLoader(this.mDevSupportManager.getJSBundleURLForRemoteDebugging(), this.mDevSupportManager.getSourceUrl()));
    }

    private void onJSBundleLoadedFromServer() {
        this.recreateReactContextInBackground(new JSCJavaScriptExecutor.Factory(), JSBundleLoader.createCachedBundleFromNetworkLoader(this.mDevSupportManager.getSourceUrl(), this.mDevSupportManager.getDownloadedJSBundleFile()));
    }

    private void recreateReactContextInBackground(JavaScriptExecutor.Factory jsExecutorFactory, JSBundleLoader jsBundleLoader) {
        UiThreadUtil.assertOnUiThread();
        ReactContextInitParams initParams = new ReactContextInitParams(jsExecutorFactory, jsBundleLoader);
        if (this.mReactContextInitAsyncTask == null) {
            this.mReactContextInitAsyncTask = new ReactContextInitAsyncTask();
            this.mReactContextInitAsyncTask.execute(new ReactContextInitParams[]{initParams});
        } else {
            this.mPendingReactContextInitParams = initParams;
        }
    }

    private void setupReactContext(ReactApplicationContext reactContext) {
        UiThreadUtil.assertOnUiThread();
        Assertions.assertCondition((this.mCurrentReactContext == null ? 1 : 0) != 0);
        this.mCurrentReactContext = (ReactContext)((Object)Assertions.assertNotNull((Object)((Object)reactContext)));
        CatalystInstance catalystInstance = (CatalystInstance)Assertions.assertNotNull((Object)reactContext.getCatalystInstance());
        catalystInstance.initialize();
        this.mDevSupportManager.onNewReactContextCreated(reactContext);
        this.mMemoryPressureRouter.addMemoryPressureListener(catalystInstance);
        this.moveReactContextToCurrentLifecycleState();
        for (ReactRootView rootView : this.mAttachedRootViews) {
            this.attachMeasuredRootViewToInstance(rootView, catalystInstance);
        }
        ReactInstanceManager.ReactInstanceEventListener[] listeners = new ReactInstanceManager.ReactInstanceEventListener[this.mReactInstanceEventListeners.size()];
        for (ReactInstanceManager.ReactInstanceEventListener listener : listeners = this.mReactInstanceEventListeners.toArray(listeners)) {
            listener.onReactContextInitialized(reactContext);
        }
    }

    private void attachMeasuredRootViewToInstance(ReactRootView rootView, CatalystInstance catalystInstance) {
        UiThreadUtil.assertOnUiThread();
        rootView.removeAllViews();
        rootView.setId(-1);
        UIManagerModule uiManagerModule = catalystInstance.getNativeModule(UIManagerModule.class);
        int rootTag = uiManagerModule.addMeasuredRootView(rootView);
        Bundle launchOptions = rootView.getLaunchOptions();
        WritableMap initialProps = launchOptions != null ? Arguments.fromBundle(launchOptions) : Arguments.createMap();
        String jsAppModuleName = rootView.getJSModuleName();
        WritableNativeMap appParams = new WritableNativeMap();
        appParams.putDouble("rootTag", rootTag);
        appParams.putMap("initialProps", initialProps);
        catalystInstance.getJSModule(AppRegistry.class).runApplication(jsAppModuleName, appParams);
    }

    private void detachViewFromInstance(ReactRootView rootView, CatalystInstance catalystInstance) {
        UiThreadUtil.assertOnUiThread();
        catalystInstance.getJSModule(AppRegistry.class).unmountApplicationComponentAtRootTag(rootView.getId());
    }

    private void tearDownReactContext(ReactContext reactContext) {
        UiThreadUtil.assertOnUiThread();
        if (this.mLifecycleState == LifecycleState.RESUMED) {
            reactContext.onHostPause();
        }
        for (ReactRootView rootView : this.mAttachedRootViews) {
            this.detachViewFromInstance(rootView, reactContext.getCatalystInstance());
        }
        reactContext.destroy();
        this.mDevSupportManager.onReactInstanceDestroyed(reactContext);
        this.mMemoryPressureRouter.removeMemoryPressureListener(reactContext.getCatalystInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReactApplicationContext createReactContext(JavaScriptExecutor jsExecutor, JSBundleLoader jsBundleLoader) {
        CatalystInstanceImpl catalystInstance;
        JavaScriptModulesConfig javaScriptModulesConfig;
        NativeModuleRegistry nativeModuleRegistry;
        FLog.i((String)"React", (String)"Creating react context.");
        ReactMarker.logMarker("CREATE_REACT_CONTEXT_START");
        this.mSourceUrl = jsBundleLoader.getSourceUrl();
        NativeModuleRegistry.Builder nativeRegistryBuilder = new NativeModuleRegistry.Builder();
        JavaScriptModulesConfig.Builder jsModulesBuilder = new JavaScriptModulesConfig.Builder();
        ReactApplicationContext reactContext = new ReactApplicationContext(this.mApplicationContext);
        if (this.mUseDeveloperSupport) {
            reactContext.setNativeModuleCallExceptionHandler(this.mDevSupportManager);
        }
        ReactMarker.logMarker("PROCESS_PACKAGES_START");
        Systrace.beginSection(0L, "createAndProcessCoreModulesPackage");
        try {
            CoreModulesPackage coreModulesPackage = new CoreModulesPackage(this, this.mBackBtnHandler, this.mUIImplementationProvider);
            this.processPackage(coreModulesPackage, reactContext, nativeRegistryBuilder, jsModulesBuilder);
        }
        finally {
            Systrace.endSection(0L);
        }
        for (ReactPackage reactPackage : this.mPackages) {
            Systrace.beginSection(0L, "createAndProcessCustomReactPackage");
            try {
                this.processPackage(reactPackage, reactContext, nativeRegistryBuilder, jsModulesBuilder);
            }
            finally {
                Systrace.endSection(0L);
            }
        }
        ReactMarker.logMarker("PROCESS_PACKAGES_END");
        ReactMarker.logMarker("BUILD_NATIVE_MODULE_REGISTRY_START");
        Systrace.beginSection(0L, "buildNativeModuleRegistry");
        try {
            nativeModuleRegistry = nativeRegistryBuilder.build();
        }
        finally {
            Systrace.endSection(0L);
            ReactMarker.logMarker("BUILD_NATIVE_MODULE_REGISTRY_END");
        }
        ReactMarker.logMarker("BUILD_JS_MODULE_CONFIG_START");
        Systrace.beginSection(0L, "buildJSModuleConfig");
        try {
            javaScriptModulesConfig = jsModulesBuilder.build();
        }
        finally {
            Systrace.endSection(0L);
            ReactMarker.logMarker("BUILD_JS_MODULE_CONFIG_END");
        }
        NativeModuleCallExceptionHandler exceptionHandler = this.mNativeModuleCallExceptionHandler != null ? this.mNativeModuleCallExceptionHandler : this.mDevSupportManager;
        CatalystInstanceImpl.Builder catalystInstanceBuilder = new CatalystInstanceImpl.Builder().setReactQueueConfigurationSpec(ReactQueueConfigurationSpec.createDefault()).setJSExecutor(jsExecutor).setRegistry(nativeModuleRegistry).setJSModulesConfig(javaScriptModulesConfig).setJSBundleLoader(jsBundleLoader).setNativeModuleCallExceptionHandler(exceptionHandler);
        ReactMarker.logMarker("CREATE_CATALYST_INSTANCE_START");
        Systrace.beginSection(0L, "createCatalystInstance");
        try {
            catalystInstance = catalystInstanceBuilder.build();
        }
        finally {
            Systrace.endSection(0L);
            ReactMarker.logMarker("CREATE_CATALYST_INSTANCE_END");
        }
        if (this.mBridgeIdleDebugListener != null) {
            catalystInstance.addBridgeIdleDebugListener(this.mBridgeIdleDebugListener);
        }
        reactContext.initializeWithInstance(catalystInstance);
        ReactMarker.logMarker("RUN_JS_BUNDLE_START");
        Systrace.beginSection(0L, "runJSBundle");
        try {
            catalystInstance.runJSBundle();
        }
        finally {
            Systrace.endSection(0L);
            ReactMarker.logMarker("RUN_JS_BUNDLE_END");
        }
        ReactMarker.logMarker("CREATE_REACT_CONTEXT_END");
        return reactContext;
    }

    private void processPackage(ReactPackage reactPackage, ReactApplicationContext reactContext, NativeModuleRegistry.Builder nativeRegistryBuilder, JavaScriptModulesConfig.Builder jsModulesBuilder) {
        for (NativeModule nativeModule : reactPackage.createNativeModules(reactContext)) {
            nativeRegistryBuilder.add(nativeModule);
        }
        for (Class clazz : reactPackage.createJSModules()) {
            jsModulesBuilder.add(clazz);
        }
    }

    private void moveReactContextToCurrentLifecycleState() {
        if (this.mLifecycleState == LifecycleState.RESUMED) {
            this.moveToResumedLifecycleState(true);
        }
    }

    private static class Result<T> {
        @Nullable
        private final T mResult;
        @Nullable
        private final Exception mException;

        public static <T, U extends T> Result<T> of(U result) {
            return new Result<U>(result);
        }

        public static <T> Result<T> of(Exception exception) {
            return new Result<T>(exception);
        }

        private Result(T result) {
            this.mException = null;
            this.mResult = result;
        }

        private Result(Exception exception) {
            this.mException = exception;
            this.mResult = null;
        }

        public T get() throws Exception {
            if (this.mException != null) {
                throw this.mException;
            }
            Assertions.assertNotNull(this.mResult);
            return this.mResult;
        }
    }

    private final class ReactContextInitAsyncTask
    extends AsyncTask<ReactContextInitParams, Void, Result<ReactApplicationContext>> {
        private ReactContextInitAsyncTask() {
        }

        protected void onPreExecute() {
            if (ReactInstanceManagerImpl.this.mCurrentReactContext != null) {
                ReactInstanceManagerImpl.this.tearDownReactContext(ReactInstanceManagerImpl.this.mCurrentReactContext);
                ReactInstanceManagerImpl.this.mCurrentReactContext = null;
            }
        }

        protected Result<ReactApplicationContext> doInBackground(ReactContextInitParams ... params) {
            Assertions.assertCondition((params != null && params.length > 0 && params[0] != null ? 1 : 0) != 0);
            try {
                JavaScriptExecutor jsExecutor = params[0].getJsExecutorFactory().create(ReactInstanceManagerImpl.this.mJSCConfig == null ? new WritableNativeMap() : ReactInstanceManagerImpl.this.mJSCConfig.getConfigMap());
                return Result.of(ReactInstanceManagerImpl.this.createReactContext(jsExecutor, params[0].getJsBundleLoader()));
            }
            catch (Exception e) {
                return Result.of(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void onPostExecute(Result<ReactApplicationContext> result) {
            try {
                ReactInstanceManagerImpl.this.setupReactContext(result.get());
            }
            catch (Exception e) {
                ReactInstanceManagerImpl.this.mDevSupportManager.handleException(e);
            }
            finally {
                ReactInstanceManagerImpl.this.mReactContextInitAsyncTask = null;
            }
            if (ReactInstanceManagerImpl.this.mPendingReactContextInitParams != null) {
                ReactInstanceManagerImpl.this.recreateReactContextInBackground(ReactInstanceManagerImpl.this.mPendingReactContextInitParams.getJsExecutorFactory(), ReactInstanceManagerImpl.this.mPendingReactContextInitParams.getJsBundleLoader());
                ReactInstanceManagerImpl.this.mPendingReactContextInitParams = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void onCancelled(Result<ReactApplicationContext> reactApplicationContextResult) {
            try {
                ReactInstanceManagerImpl.this.mMemoryPressureRouter.destroy((Context)reactApplicationContextResult.get());
            }
            catch (Exception e) {
                FLog.w((String)"React", (String)"Caught exception after cancelling react context init", (Throwable)e);
            }
            finally {
                ReactInstanceManagerImpl.this.mReactContextInitAsyncTask = null;
            }
        }
    }

    private class ReactContextInitParams {
        private final JavaScriptExecutor.Factory mJsExecutorFactory;
        private final JSBundleLoader mJsBundleLoader;

        public ReactContextInitParams(JavaScriptExecutor.Factory jsExecutorFactory, JSBundleLoader jsBundleLoader) {
            this.mJsExecutorFactory = (JavaScriptExecutor.Factory)Assertions.assertNotNull((Object)jsExecutorFactory);
            this.mJsBundleLoader = (JSBundleLoader)Assertions.assertNotNull((Object)jsBundleLoader);
        }

        public JavaScriptExecutor.Factory getJsExecutorFactory() {
            return this.mJsExecutorFactory;
        }

        public JSBundleLoader getJsBundleLoader() {
            return this.mJsBundleLoader;
        }
    }
}

