/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.bridge;

import com.facebook.infer.annotation.Assertions;
import com.facebook.react.bridge.Callback;
import com.facebook.react.bridge.CallbackImpl;
import com.facebook.react.bridge.CatalystInstance;
import com.facebook.react.bridge.ExecutorToken;
import com.facebook.react.bridge.JsonWriter;
import com.facebook.react.bridge.JsonWriterHelper;
import com.facebook.react.bridge.NativeArgumentsParseException;
import com.facebook.react.bridge.NativeModule;
import com.facebook.react.bridge.Promise;
import com.facebook.react.bridge.PromiseImpl;
import com.facebook.react.bridge.ReactBridge;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.ReadableNativeArray;
import com.facebook.react.bridge.UnexpectedNativeTypeException;
import com.facebook.systrace.Systrace;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public abstract class BaseJavaModule
implements NativeModule {
    public static final String METHOD_TYPE_REMOTE = "remote";
    public static final String METHOD_TYPE_REMOTE_ASYNC = "remoteAsync";
    private static final ArgumentExtractor<Boolean> ARGUMENT_EXTRACTOR_BOOLEAN = new ArgumentExtractor<Boolean>(){

        @Override
        public Boolean extractArgument(CatalystInstance catalystInstance, ExecutorToken executorToken, ReadableNativeArray jsArguments, int atIndex) {
            return jsArguments.getBoolean(atIndex);
        }
    };
    private static final ArgumentExtractor<Double> ARGUMENT_EXTRACTOR_DOUBLE = new ArgumentExtractor<Double>(){

        @Override
        public Double extractArgument(CatalystInstance catalystInstance, ExecutorToken executorToken, ReadableNativeArray jsArguments, int atIndex) {
            return jsArguments.getDouble(atIndex);
        }
    };
    private static final ArgumentExtractor<Float> ARGUMENT_EXTRACTOR_FLOAT = new ArgumentExtractor<Float>(){

        @Override
        public Float extractArgument(CatalystInstance catalystInstance, ExecutorToken executorToken, ReadableNativeArray jsArguments, int atIndex) {
            return Float.valueOf((float)jsArguments.getDouble(atIndex));
        }
    };
    private static final ArgumentExtractor<Integer> ARGUMENT_EXTRACTOR_INTEGER = new ArgumentExtractor<Integer>(){

        @Override
        public Integer extractArgument(CatalystInstance catalystInstance, ExecutorToken executorToken, ReadableNativeArray jsArguments, int atIndex) {
            return (int)jsArguments.getDouble(atIndex);
        }
    };
    private static final ArgumentExtractor<String> ARGUMENT_EXTRACTOR_STRING = new ArgumentExtractor<String>(){

        @Override
        public String extractArgument(CatalystInstance catalystInstance, ExecutorToken executorToken, ReadableNativeArray jsArguments, int atIndex) {
            return jsArguments.getString(atIndex);
        }
    };
    private static final ArgumentExtractor<ReadableNativeArray> ARGUMENT_EXTRACTOR_ARRAY = new ArgumentExtractor<ReadableNativeArray>(){

        @Override
        public ReadableNativeArray extractArgument(CatalystInstance catalystInstance, ExecutorToken executorToken, ReadableNativeArray jsArguments, int atIndex) {
            return jsArguments.getArray(atIndex);
        }
    };
    private static final ArgumentExtractor<ReadableMap> ARGUMENT_EXTRACTOR_MAP = new ArgumentExtractor<ReadableMap>(){

        @Override
        public ReadableMap extractArgument(CatalystInstance catalystInstance, ExecutorToken executorToken, ReadableNativeArray jsArguments, int atIndex) {
            return jsArguments.getMap(atIndex);
        }
    };
    private static final ArgumentExtractor<Callback> ARGUMENT_EXTRACTOR_CALLBACK = new ArgumentExtractor<Callback>(){

        @Override
        @Nullable
        public Callback extractArgument(CatalystInstance catalystInstance, ExecutorToken executorToken, ReadableNativeArray jsArguments, int atIndex) {
            if (jsArguments.isNull(atIndex)) {
                return null;
            }
            int id = (int)jsArguments.getDouble(atIndex);
            return new CallbackImpl(catalystInstance, executorToken, id);
        }
    };
    private static final ArgumentExtractor<Promise> ARGUMENT_EXTRACTOR_PROMISE = new ArgumentExtractor<Promise>(){

        @Override
        public int getJSArgumentsNeeded() {
            return 2;
        }

        @Override
        public Promise extractArgument(CatalystInstance catalystInstance, ExecutorToken executorToken, ReadableNativeArray jsArguments, int atIndex) {
            Callback resolve = (Callback)ARGUMENT_EXTRACTOR_CALLBACK.extractArgument(catalystInstance, executorToken, jsArguments, atIndex);
            Callback reject = (Callback)ARGUMENT_EXTRACTOR_CALLBACK.extractArgument(catalystInstance, executorToken, jsArguments, atIndex + 1);
            return new PromiseImpl(resolve, reject);
        }
    };

    @Override
    public final Map<String, NativeModule.NativeMethod> getMethods() {
        HashMap<String, NativeModule.NativeMethod> methods = new HashMap<String, NativeModule.NativeMethod>();
        Method[] targetMethods = this.getClass().getDeclaredMethods();
        for (int i = 0; i < targetMethods.length; ++i) {
            Method targetMethod = targetMethods[i];
            if (targetMethod.getAnnotation(ReactMethod.class) == null) continue;
            String methodName = targetMethod.getName();
            if (methods.containsKey(methodName)) {
                throw new IllegalArgumentException("Java Module " + this.getName() + " method name already registered: " + methodName);
            }
            methods.put(methodName, new JavaMethod(targetMethod));
        }
        return methods;
    }

    @Nullable
    public Map<String, Object> getConstants() {
        return null;
    }

    @Override
    public final void writeConstantsField(JsonWriter writer, String fieldName) throws IOException {
        Map<String, Object> constants = this.getConstants();
        if (constants == null || constants.isEmpty()) {
            return;
        }
        writer.name(fieldName).beginObject();
        for (Map.Entry<String, Object> constant : constants.entrySet()) {
            writer.name(constant.getKey());
            JsonWriterHelper.value(writer, constant.getValue());
        }
        writer.endObject();
    }

    @Override
    public void initialize() {
    }

    @Override
    public boolean canOverrideExistingModule() {
        return false;
    }

    @Override
    public void onReactBridgeInitialized(ReactBridge bridge) {
    }

    @Override
    public void onCatalystInstanceDestroy() {
    }

    @Override
    public boolean supportsWebWorkers() {
        return false;
    }

    private class JavaMethod
    implements NativeModule.NativeMethod {
        private Method mMethod;
        private final ArgumentExtractor[] mArgumentExtractors;
        private final Object[] mArguments;
        private String mType = "remote";
        private final int mJSArgumentsNeeded;

        public JavaMethod(Method method) {
            this.mMethod = method;
            Class[] parameterTypes = method.getParameterTypes();
            this.mArgumentExtractors = this.buildArgumentExtractors(parameterTypes);
            this.mArguments = new Object[parameterTypes.length];
            this.mJSArgumentsNeeded = this.calculateJSArgumentsNeeded();
        }

        private ArgumentExtractor[] buildArgumentExtractors(Class[] paramTypes) {
            int executorTokenOffset = 0;
            if (BaseJavaModule.this.supportsWebWorkers()) {
                if (paramTypes[0] != ExecutorToken.class) {
                    throw new RuntimeException("Module " + BaseJavaModule.this + " supports web workers, but " + this.mMethod.getName() + "does not take an ExecutorToken as its first parameter.");
                }
                executorTokenOffset = 1;
            }
            ArgumentExtractor[] argumentExtractors = new ArgumentExtractor[paramTypes.length - executorTokenOffset];
            for (int i = 0; i < paramTypes.length - executorTokenOffset; i += argumentExtractors[i].getJSArgumentsNeeded()) {
                Class argumentClass = paramTypes[i + executorTokenOffset];
                if (argumentClass == Boolean.class || argumentClass == Boolean.TYPE) {
                    argumentExtractors[i] = ARGUMENT_EXTRACTOR_BOOLEAN;
                    continue;
                }
                if (argumentClass == Integer.class || argumentClass == Integer.TYPE) {
                    argumentExtractors[i] = ARGUMENT_EXTRACTOR_INTEGER;
                    continue;
                }
                if (argumentClass == Double.class || argumentClass == Double.TYPE) {
                    argumentExtractors[i] = ARGUMENT_EXTRACTOR_DOUBLE;
                    continue;
                }
                if (argumentClass == Float.class || argumentClass == Float.TYPE) {
                    argumentExtractors[i] = ARGUMENT_EXTRACTOR_FLOAT;
                    continue;
                }
                if (argumentClass == String.class) {
                    argumentExtractors[i] = ARGUMENT_EXTRACTOR_STRING;
                    continue;
                }
                if (argumentClass == Callback.class) {
                    argumentExtractors[i] = ARGUMENT_EXTRACTOR_CALLBACK;
                    continue;
                }
                if (argumentClass == Promise.class) {
                    argumentExtractors[i] = ARGUMENT_EXTRACTOR_PROMISE;
                    Assertions.assertCondition((i == paramTypes.length - 1 ? 1 : 0) != 0, (String)"Promise must be used as last parameter only");
                    this.mType = BaseJavaModule.METHOD_TYPE_REMOTE_ASYNC;
                    continue;
                }
                if (argumentClass == ReadableMap.class) {
                    argumentExtractors[i] = ARGUMENT_EXTRACTOR_MAP;
                    continue;
                }
                if (argumentClass == ReadableArray.class) {
                    argumentExtractors[i] = ARGUMENT_EXTRACTOR_ARRAY;
                    continue;
                }
                throw new RuntimeException("Got unknown argument class: " + argumentClass.getSimpleName());
            }
            return argumentExtractors;
        }

        private int calculateJSArgumentsNeeded() {
            int n = 0;
            for (ArgumentExtractor extractor : this.mArgumentExtractors) {
                n += extractor.getJSArgumentsNeeded();
            }
            return n;
        }

        private String getAffectedRange(int startIndex, int jsArgumentsNeeded) {
            return jsArgumentsNeeded > 1 ? "" + startIndex + "-" + (startIndex + jsArgumentsNeeded - 1) : "" + startIndex;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void invoke(CatalystInstance catalystInstance, ExecutorToken executorToken, ReadableNativeArray parameters) {
            Systrace.beginSection(0L, "callJavaModuleMethod");
            try {
                if (this.mJSArgumentsNeeded != parameters.size()) {
                    throw new NativeArgumentsParseException(BaseJavaModule.this.getName() + "." + this.mMethod.getName() + " got " + parameters.size() + " arguments, expected " + this.mJSArgumentsNeeded);
                }
                int i = 0;
                int jsArgumentsConsumed = 0;
                int executorTokenOffset = 0;
                if (BaseJavaModule.this.supportsWebWorkers()) {
                    this.mArguments[0] = executorToken;
                    executorTokenOffset = 1;
                }
                try {
                    while (i < this.mArgumentExtractors.length) {
                        this.mArguments[i + executorTokenOffset] = this.mArgumentExtractors[i].extractArgument(catalystInstance, executorToken, parameters, jsArgumentsConsumed);
                        jsArgumentsConsumed += this.mArgumentExtractors[i].getJSArgumentsNeeded();
                        ++i;
                    }
                }
                catch (UnexpectedNativeTypeException e) {
                    throw new NativeArgumentsParseException(e.getMessage() + " (constructing arguments for " + BaseJavaModule.this.getName() + "." + this.mMethod.getName() + " at argument index " + this.getAffectedRange(jsArgumentsConsumed, this.mArgumentExtractors[i].getJSArgumentsNeeded()) + ")", e);
                }
                try {
                    this.mMethod.invoke((Object)BaseJavaModule.this, this.mArguments);
                }
                catch (IllegalArgumentException ie) {
                    throw new RuntimeException("Could not invoke " + BaseJavaModule.this.getName() + "." + this.mMethod.getName(), ie);
                }
                catch (IllegalAccessException iae) {
                    throw new RuntimeException("Could not invoke " + BaseJavaModule.this.getName() + "." + this.mMethod.getName(), iae);
                }
                catch (InvocationTargetException ite) {
                    if (ite.getCause() instanceof RuntimeException) {
                        throw (RuntimeException)ite.getCause();
                    }
                    throw new RuntimeException("Could not invoke " + BaseJavaModule.this.getName() + "." + this.mMethod.getName(), ite);
                }
            }
            finally {
                Systrace.endSection(0L);
            }
        }

        @Override
        public String getType() {
            return this.mType;
        }
    }

    private static abstract class ArgumentExtractor<T> {
        private ArgumentExtractor() {
        }

        public int getJSArgumentsNeeded() {
            return 1;
        }

        @Nullable
        public abstract T extractArgument(CatalystInstance var1, ExecutorToken var2, ReadableNativeArray var3, int var4);
    }
}

