/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.bridge;

import com.facebook.common.logging.FLog;
import com.facebook.infer.annotation.Assertions;
import com.facebook.proguard.annotations.DoNotStrip;
import com.facebook.react.bridge.CatalystInstance;
import com.facebook.react.bridge.ExecutorToken;
import com.facebook.react.bridge.JSBundleLoader;
import com.facebook.react.bridge.JSExecutionException;
import com.facebook.react.bridge.JavaScriptExecutor;
import com.facebook.react.bridge.JavaScriptModule;
import com.facebook.react.bridge.JavaScriptModuleRegistry;
import com.facebook.react.bridge.JavaScriptModulesConfig;
import com.facebook.react.bridge.JsonWriter;
import com.facebook.react.bridge.MemoryPressure;
import com.facebook.react.bridge.NativeArray;
import com.facebook.react.bridge.NativeModule;
import com.facebook.react.bridge.NativeModuleCallExceptionHandler;
import com.facebook.react.bridge.NativeModuleRegistry;
import com.facebook.react.bridge.NotThreadSafeBridgeIdleDebugListener;
import com.facebook.react.bridge.ReactBridge;
import com.facebook.react.bridge.ReactCallback;
import com.facebook.react.bridge.ReadableNativeArray;
import com.facebook.react.bridge.Systrace;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.bridge.queue.QueueThreadExceptionHandler;
import com.facebook.react.bridge.queue.ReactQueueConfiguration;
import com.facebook.react.bridge.queue.ReactQueueConfigurationImpl;
import com.facebook.react.bridge.queue.ReactQueueConfigurationSpec;
import com.facebook.react.common.annotations.VisibleForTesting;
import com.facebook.react.common.futures.SimpleSettableFuture;
import com.facebook.systrace.TraceListener;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;

@DoNotStrip
public class CatalystInstanceImpl
implements CatalystInstance {
    private static final AtomicInteger sNextInstanceIdForTrace = new AtomicInteger(1);
    private final ReactQueueConfigurationImpl mReactQueueConfiguration;
    private final CopyOnWriteArrayList<NotThreadSafeBridgeIdleDebugListener> mBridgeIdleListeners;
    private final AtomicInteger mPendingJSCalls = new AtomicInteger(0);
    private final String mJsPendingCallsTitleForTrace = "pending_js_calls_instance" + sNextInstanceIdForTrace.getAndIncrement();
    private volatile boolean mDestroyed = false;
    private final TraceListener mTraceListener;
    private final JavaScriptModuleRegistry mJSModuleRegistry;
    private final JSBundleLoader mJSBundleLoader;
    @Nullable
    private ExecutorToken mMainExecutorToken;
    private final Object mJSToJavaCallsTeardownLock = new Object();
    private final Object mJavaToJSCallsTeardownLock = new Object();
    private final NativeModuleRegistry mJavaRegistry;
    private final NativeModuleCallExceptionHandler mNativeModuleCallExceptionHandler;
    private boolean mInitialized = false;
    private final ReactBridge mBridge;
    private boolean mJSBundleHasLoaded;

    private CatalystInstanceImpl(ReactQueueConfigurationSpec ReactQueueConfigurationSpec2, final JavaScriptExecutor jsExecutor, NativeModuleRegistry registry, final JavaScriptModulesConfig jsModulesConfig, JSBundleLoader jsBundleLoader, NativeModuleCallExceptionHandler nativeModuleCallExceptionHandler) {
        FLog.d((String)"React", (String)"Initializing React Bridge.");
        this.mReactQueueConfiguration = ReactQueueConfigurationImpl.create(ReactQueueConfigurationSpec2, new NativeExceptionHandler());
        this.mBridgeIdleListeners = new CopyOnWriteArrayList();
        this.mJavaRegistry = registry;
        this.mJSModuleRegistry = new JavaScriptModuleRegistry(this, jsModulesConfig);
        this.mJSBundleLoader = jsBundleLoader;
        this.mNativeModuleCallExceptionHandler = nativeModuleCallExceptionHandler;
        this.mTraceListener = new JSProfilerTraceListener();
        try {
            this.mBridge = this.mReactQueueConfiguration.getJSQueueThread().callOnQueue(new Callable<ReactBridge>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public ReactBridge call() throws Exception {
                    com.facebook.systrace.Systrace.beginSection(0L, "initializeBridge");
                    try {
                        ReactBridge reactBridge = CatalystInstanceImpl.this.initializeBridge(jsExecutor, jsModulesConfig);
                        return reactBridge;
                    }
                    finally {
                        com.facebook.systrace.Systrace.endSection(0L);
                    }
                }
            }).get();
        }
        catch (Exception t) {
            throw new RuntimeException("Failed to initialize bridge", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReactBridge initializeBridge(JavaScriptExecutor jsExecutor, JavaScriptModulesConfig jsModulesConfig) {
        ReactBridge bridge;
        this.mReactQueueConfiguration.getJSQueueThread().assertIsOnThread();
        Assertions.assertCondition((this.mBridge == null ? 1 : 0) != 0, (String)"initializeBridge should be called once");
        com.facebook.systrace.Systrace.beginSection(0L, "ReactBridgeCtor");
        try {
            bridge = new ReactBridge(jsExecutor, new NativeModulesReactCallback(), this.mReactQueueConfiguration.getNativeModulesQueueThread());
            this.mMainExecutorToken = bridge.getMainExecutorToken();
        }
        finally {
            com.facebook.systrace.Systrace.endSection(0L);
        }
        com.facebook.systrace.Systrace.beginSection(0L, "setBatchedBridgeConfig");
        try {
            bridge.setGlobalVariable("__fbBatchedBridgeConfig", this.buildModulesConfigJSONProperty(this.mJavaRegistry, jsModulesConfig));
            bridge.setGlobalVariable("__RCTProfileIsProfiling", com.facebook.systrace.Systrace.isTracing(0L) ? "true" : "false");
        }
        finally {
            com.facebook.systrace.Systrace.endSection(0L);
        }
        this.mJavaRegistry.notifyReactBridgeInitialized(bridge);
        return bridge;
    }

    @Override
    public void runJSBundle() {
        try {
            this.mJSBundleHasLoaded = this.mReactQueueConfiguration.getJSQueueThread().callOnQueue(new Callable<Boolean>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Boolean call() throws Exception {
                    Assertions.assertCondition((!CatalystInstanceImpl.this.mJSBundleHasLoaded ? 1 : 0) != 0, (String)"JS bundle was already loaded!");
                    CatalystInstanceImpl.this.incrementPendingJSCalls();
                    com.facebook.systrace.Systrace.beginSection(0L, "loadJSScript");
                    try {
                        CatalystInstanceImpl.this.mJSBundleLoader.loadScript(CatalystInstanceImpl.this.mBridge);
                        com.facebook.systrace.Systrace.registerListener(CatalystInstanceImpl.this.mTraceListener);
                    }
                    catch (JSExecutionException e) {
                        CatalystInstanceImpl.this.mNativeModuleCallExceptionHandler.handleException(e);
                    }
                    finally {
                        com.facebook.systrace.Systrace.endSection(0L);
                    }
                    return true;
                }
            }).get();
        }
        catch (Exception t) {
            throw new RuntimeException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void callFunction(ExecutorToken executorToken, int moduleId, int methodId, NativeArray arguments, String tracingName) {
        Object object = this.mJavaToJSCallsTeardownLock;
        synchronized (object) {
            if (this.mDestroyed) {
                FLog.w((String)"React", (String)"Calling JS function after bridge has been destroyed.");
                return;
            }
            this.incrementPendingJSCalls();
            ((ReactBridge)Assertions.assertNotNull((Object)this.mBridge)).callFunction(executorToken, moduleId, methodId, arguments, tracingName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @DoNotStrip
    public void invokeCallback(ExecutorToken executorToken, int callbackID, NativeArray arguments) {
        Object object = this.mJavaToJSCallsTeardownLock;
        synchronized (object) {
            if (this.mDestroyed) {
                FLog.w((String)"React", (String)"Invoking JS callback after bridge has been destroyed.");
                return;
            }
            this.incrementPendingJSCalls();
            ((ReactBridge)Assertions.assertNotNull((Object)this.mBridge)).invokeCallback(executorToken, callbackID, arguments);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        boolean wasIdle;
        UiThreadUtil.assertOnUiThread();
        Object object = this.mJSToJavaCallsTeardownLock;
        synchronized (object) {
            Object object2 = this.mJavaToJSCallsTeardownLock;
            synchronized (object2) {
                if (this.mDestroyed) {
                    return;
                }
                this.mDestroyed = true;
                this.mJavaRegistry.notifyCatalystInstanceDestroy();
                com.facebook.systrace.Systrace.unregisterListener(this.mTraceListener);
                this.synchronouslyDisposeBridgeOnJSThread();
            }
        }
        this.mReactQueueConfiguration.destroy();
        boolean bl = wasIdle = this.mPendingJSCalls.getAndSet(0) == 0;
        if (!wasIdle && !this.mBridgeIdleListeners.isEmpty()) {
            for (NotThreadSafeBridgeIdleDebugListener listener : this.mBridgeIdleListeners) {
                listener.onTransitionToBridgeIdle();
            }
        }
    }

    private void synchronouslyDisposeBridgeOnJSThread() {
        final SimpleSettableFuture bridgeDisposeFuture = new SimpleSettableFuture();
        this.mReactQueueConfiguration.getJSQueueThread().runOnQueue(new Runnable(){

            @Override
            public void run() {
                CatalystInstanceImpl.this.mBridge.destroy();
                CatalystInstanceImpl.this.mBridge.dispose();
                bridgeDisposeFuture.set(null);
            }
        });
        bridgeDisposeFuture.getOrThrow();
    }

    @Override
    public boolean isDestroyed() {
        return this.mDestroyed;
    }

    @Override
    @VisibleForTesting
    public void initialize() {
        UiThreadUtil.assertOnUiThread();
        Assertions.assertCondition((!this.mInitialized ? 1 : 0) != 0, (String)"This catalyst instance has already been initialized");
        this.mInitialized = true;
        this.mJavaRegistry.notifyCatalystInstanceInitialized();
    }

    @Override
    public ReactQueueConfiguration getReactQueueConfiguration() {
        return this.mReactQueueConfiguration;
    }

    @Override
    public <T extends JavaScriptModule> T getJSModule(Class<T> jsInterface) {
        return this.getJSModule((ExecutorToken)Assertions.assertNotNull((Object)this.mMainExecutorToken), jsInterface);
    }

    @Override
    public <T extends JavaScriptModule> T getJSModule(ExecutorToken executorToken, Class<T> jsInterface) {
        return ((JavaScriptModuleRegistry)Assertions.assertNotNull((Object)this.mJSModuleRegistry)).getJavaScriptModule(executorToken, jsInterface);
    }

    @Override
    public <T extends NativeModule> T getNativeModule(Class<T> nativeModuleInterface) {
        return this.mJavaRegistry.getModule(nativeModuleInterface);
    }

    @Override
    public Collection<NativeModule> getNativeModules() {
        return this.mJavaRegistry.getAllModules();
    }

    @Override
    public void handleMemoryPressure(final MemoryPressure level) {
        this.mReactQueueConfiguration.getJSQueueThread().runOnQueue(new Runnable(){

            @Override
            public void run() {
                ((ReactBridge)Assertions.assertNotNull((Object)CatalystInstanceImpl.this.mBridge)).handleMemoryPressure(level);
            }
        });
    }

    @Override
    public void addBridgeIdleDebugListener(NotThreadSafeBridgeIdleDebugListener listener) {
        this.mBridgeIdleListeners.add(listener);
    }

    @Override
    public void removeBridgeIdleDebugListener(NotThreadSafeBridgeIdleDebugListener listener) {
        this.mBridgeIdleListeners.remove(listener);
    }

    @Override
    public boolean supportsProfiling() {
        return this.mBridge.supportsProfiling();
    }

    @Override
    public void startProfiler(String title) {
        this.mBridge.startProfiler(title);
    }

    @Override
    public void stopProfiler(String title, String filename) {
        this.mBridge.stopProfiler(title, filename);
    }

    @Override
    @VisibleForTesting
    public void setGlobalVariable(String propName, String jsonValue) {
        this.mBridge.setGlobalVariable(propName, jsonValue);
    }

    private String buildModulesConfigJSONProperty(NativeModuleRegistry nativeModuleRegistry, JavaScriptModulesConfig jsModulesConfig) {
        StringWriter stringWriter = new StringWriter();
        JsonWriter writer = new JsonWriter(stringWriter);
        try {
            writer.beginObject();
            writer.name("remoteModuleConfig");
            nativeModuleRegistry.writeModuleDescriptions(writer);
            writer.name("localModulesConfig");
            jsModulesConfig.writeModuleDescriptions(writer);
            writer.endObject();
            String string = stringWriter.toString();
            return string;
        }
        catch (IOException ioe) {
            throw new RuntimeException("Unable to serialize JavaScript module declaration", ioe);
        }
        finally {
            try {
                writer.close();
            }
            catch (IOException ignored) {}
        }
    }

    private void incrementPendingJSCalls() {
        int oldPendingCalls = this.mPendingJSCalls.getAndIncrement();
        boolean wasIdle = oldPendingCalls == 0;
        com.facebook.systrace.Systrace.traceCounter(0L, this.mJsPendingCallsTitleForTrace, oldPendingCalls + 1);
        if (wasIdle && !this.mBridgeIdleListeners.isEmpty()) {
            for (NotThreadSafeBridgeIdleDebugListener listener : this.mBridgeIdleListeners) {
                listener.onTransitionToBridgeBusy();
            }
        }
    }

    private void decrementPendingJSCalls() {
        int newPendingCalls = this.mPendingJSCalls.decrementAndGet();
        boolean isNowIdle = newPendingCalls == 0;
        com.facebook.systrace.Systrace.traceCounter(0L, this.mJsPendingCallsTitleForTrace, newPendingCalls);
        if (isNowIdle && !this.mBridgeIdleListeners.isEmpty()) {
            for (NotThreadSafeBridgeIdleDebugListener listener : this.mBridgeIdleListeners) {
                listener.onTransitionToBridgeIdle();
            }
        }
    }

    public static class Builder {
        @Nullable
        private ReactQueueConfigurationSpec mReactQueueConfigurationSpec;
        @Nullable
        private JSBundleLoader mJSBundleLoader;
        @Nullable
        private NativeModuleRegistry mRegistry;
        @Nullable
        private JavaScriptModulesConfig mJSModulesConfig;
        @Nullable
        private JavaScriptExecutor mJSExecutor;
        @Nullable
        private NativeModuleCallExceptionHandler mNativeModuleCallExceptionHandler;

        public Builder setReactQueueConfigurationSpec(ReactQueueConfigurationSpec ReactQueueConfigurationSpec2) {
            this.mReactQueueConfigurationSpec = ReactQueueConfigurationSpec2;
            return this;
        }

        public Builder setRegistry(NativeModuleRegistry registry) {
            this.mRegistry = registry;
            return this;
        }

        public Builder setJSModulesConfig(JavaScriptModulesConfig jsModulesConfig) {
            this.mJSModulesConfig = jsModulesConfig;
            return this;
        }

        public Builder setJSBundleLoader(JSBundleLoader jsBundleLoader) {
            this.mJSBundleLoader = jsBundleLoader;
            return this;
        }

        public Builder setJSExecutor(JavaScriptExecutor jsExecutor) {
            this.mJSExecutor = jsExecutor;
            return this;
        }

        public Builder setNativeModuleCallExceptionHandler(NativeModuleCallExceptionHandler handler) {
            this.mNativeModuleCallExceptionHandler = handler;
            return this;
        }

        public CatalystInstanceImpl build() {
            return new CatalystInstanceImpl((ReactQueueConfigurationSpec)Assertions.assertNotNull((Object)this.mReactQueueConfigurationSpec), (JavaScriptExecutor)Assertions.assertNotNull((Object)this.mJSExecutor), (NativeModuleRegistry)Assertions.assertNotNull((Object)this.mRegistry), (JavaScriptModulesConfig)Assertions.assertNotNull((Object)this.mJSModulesConfig), (JSBundleLoader)Assertions.assertNotNull((Object)this.mJSBundleLoader), (NativeModuleCallExceptionHandler)Assertions.assertNotNull((Object)this.mNativeModuleCallExceptionHandler));
        }
    }

    private class JSProfilerTraceListener
    implements TraceListener {
        private JSProfilerTraceListener() {
        }

        @Override
        public void onTraceStarted() {
            CatalystInstanceImpl.this.getJSModule((ExecutorToken)Assertions.assertNotNull((Object)CatalystInstanceImpl.this.mMainExecutorToken), Systrace.class).setEnabled(true);
        }

        @Override
        public void onTraceStopped() {
            CatalystInstanceImpl.this.getJSModule((ExecutorToken)Assertions.assertNotNull((Object)CatalystInstanceImpl.this.mMainExecutorToken), Systrace.class).setEnabled(false);
        }
    }

    private class NativeExceptionHandler
    implements QueueThreadExceptionHandler {
        private NativeExceptionHandler() {
        }

        @Override
        public void handleException(Exception e) {
            CatalystInstanceImpl.this.mNativeModuleCallExceptionHandler.handleException(e);
            CatalystInstanceImpl.this.mReactQueueConfiguration.getUIQueueThread().runOnQueue(new Runnable(){

                @Override
                public void run() {
                    CatalystInstanceImpl.this.destroy();
                }
            });
        }
    }

    private class NativeModulesReactCallback
    implements ReactCallback {
        private NativeModulesReactCallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void call(ExecutorToken executorToken, int moduleId, int methodId, ReadableNativeArray parameters) {
            CatalystInstanceImpl.this.mReactQueueConfiguration.getNativeModulesQueueThread().assertIsOnThread();
            Object object = CatalystInstanceImpl.this.mJSToJavaCallsTeardownLock;
            synchronized (object) {
                if (CatalystInstanceImpl.this.mDestroyed) {
                    return;
                }
                CatalystInstanceImpl.this.mJavaRegistry.call(CatalystInstanceImpl.this, executorToken, moduleId, methodId, parameters);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onBatchComplete() {
            CatalystInstanceImpl.this.mReactQueueConfiguration.getNativeModulesQueueThread().assertIsOnThread();
            Object object = CatalystInstanceImpl.this.mJSToJavaCallsTeardownLock;
            synchronized (object) {
                if (!CatalystInstanceImpl.this.mDestroyed) {
                    com.facebook.systrace.Systrace.beginSection(0L, "onBatchComplete");
                    try {
                        CatalystInstanceImpl.this.mJavaRegistry.onBatchComplete();
                    }
                    finally {
                        com.facebook.systrace.Systrace.endSection(0L);
                    }
                }
            }
            CatalystInstanceImpl.this.decrementPendingJSCalls();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onExecutorUnregistered(ExecutorToken executorToken) {
            CatalystInstanceImpl.this.mReactQueueConfiguration.getNativeModulesQueueThread().assertIsOnThread();
            Object object = CatalystInstanceImpl.this.mJSToJavaCallsTeardownLock;
            synchronized (object) {
                if (!CatalystInstanceImpl.this.mDestroyed) {
                    com.facebook.systrace.Systrace.beginSection(0L, "onExecutorUnregistered");
                    try {
                        CatalystInstanceImpl.this.mJavaRegistry.onExecutorUnregistered(executorToken);
                    }
                    finally {
                        com.facebook.systrace.Systrace.endSection(0L);
                    }
                }
            }
        }
    }
}

