/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.bridge;

import com.facebook.common.logging.FLog;
import com.facebook.infer.annotation.Assertions;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ws.WebSocket;
import com.squareup.okhttp.ws.WebSocketCall;
import com.squareup.okhttp.ws.WebSocketListener;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import okio.Buffer;
import okio.BufferedSource;

public class JSDebuggerWebSocketClient
implements WebSocketListener {
    private static final String TAG = "JSDebuggerWebSocketClient";
    private static final JsonFactory mJsonFactory = new JsonFactory();
    @Nullable
    private WebSocket mWebSocket;
    @Nullable
    private OkHttpClient mHttpClient;
    @Nullable
    private JSDebuggerCallback mConnectCallback;
    private final AtomicInteger mRequestID = new AtomicInteger();
    private final ConcurrentHashMap<Integer, JSDebuggerCallback> mCallbacks = new ConcurrentHashMap();

    public void connect(String url, JSDebuggerCallback callback) {
        if (this.mHttpClient != null) {
            throw new IllegalStateException("JSDebuggerWebSocketClient is already initialized.");
        }
        this.mConnectCallback = callback;
        this.mHttpClient = new OkHttpClient();
        this.mHttpClient.setConnectTimeout(10L, TimeUnit.SECONDS);
        this.mHttpClient.setWriteTimeout(10L, TimeUnit.SECONDS);
        this.mHttpClient.setReadTimeout(0L, TimeUnit.MINUTES);
        Request request = new Request.Builder().url(url).build();
        WebSocketCall call = WebSocketCall.create((OkHttpClient)this.mHttpClient, (Request)request);
        call.enqueue((WebSocketListener)this);
    }

    private JsonGenerator startMessageObject(int requestID) throws IOException {
        JsonGenerator jg = mJsonFactory.createGenerator((Writer)new StringWriter());
        jg.writeStartObject();
        jg.writeNumberField("id", requestID);
        return jg;
    }

    private String endMessageObject(JsonGenerator jg) throws IOException {
        jg.writeEndObject();
        jg.flush();
        return ((StringWriter)jg.getOutputTarget()).getBuffer().toString();
    }

    public void prepareJSRuntime(JSDebuggerCallback callback) {
        int requestID = this.mRequestID.getAndIncrement();
        this.mCallbacks.put(requestID, callback);
        try {
            JsonGenerator jg = this.startMessageObject(requestID);
            jg.writeStringField("method", "prepareJSRuntime");
            this.sendMessage(requestID, this.endMessageObject(jg));
        }
        catch (IOException e) {
            this.triggerRequestFailure(requestID, e);
        }
    }

    public void loadApplicationScript(String sourceURL, HashMap<String, String> injectedObjects, JSDebuggerCallback callback) {
        int requestID = this.mRequestID.getAndIncrement();
        this.mCallbacks.put(requestID, callback);
        try {
            JsonGenerator jg = this.startMessageObject(requestID);
            jg.writeStringField("method", "executeApplicationScript");
            jg.writeStringField("url", sourceURL);
            jg.writeObjectFieldStart("inject");
            for (String key : injectedObjects.keySet()) {
                jg.writeObjectField(key, (Object)injectedObjects.get(key));
            }
            jg.writeEndObject();
            this.sendMessage(requestID, this.endMessageObject(jg));
        }
        catch (IOException e) {
            this.triggerRequestFailure(requestID, e);
        }
    }

    public void executeJSCall(String methodName, String jsonArgsArray, JSDebuggerCallback callback) {
        int requestID = this.mRequestID.getAndIncrement();
        this.mCallbacks.put(requestID, callback);
        try {
            JsonGenerator jg = this.startMessageObject(requestID);
            jg.writeStringField("method", methodName);
            jg.writeFieldName("arguments");
            jg.writeRawValue(jsonArgsArray);
            this.sendMessage(requestID, this.endMessageObject(jg));
        }
        catch (IOException e) {
            this.triggerRequestFailure(requestID, e);
        }
    }

    public void closeQuietly() {
        if (this.mWebSocket != null) {
            try {
                this.mWebSocket.close(1000, "End of session");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.mWebSocket = null;
        }
    }

    private void sendMessage(int requestID, String message) {
        if (this.mWebSocket == null) {
            this.triggerRequestFailure(requestID, new IllegalStateException("WebSocket connection no longer valid"));
            return;
        }
        Buffer messageBuffer = new Buffer();
        messageBuffer.writeUtf8(message);
        try {
            this.mWebSocket.sendMessage(WebSocket.PayloadType.TEXT, messageBuffer);
        }
        catch (IOException e) {
            this.triggerRequestFailure(requestID, e);
        }
    }

    private void triggerRequestFailure(int requestID, Throwable cause) {
        JSDebuggerCallback callback = this.mCallbacks.get(requestID);
        if (callback != null) {
            this.mCallbacks.remove(requestID);
            callback.onFailure(cause);
        }
    }

    private void triggerRequestSuccess(int requestID, @Nullable String response) {
        JSDebuggerCallback callback = this.mCallbacks.get(requestID);
        if (callback != null) {
            this.mCallbacks.remove(requestID);
            callback.onSuccess(response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(BufferedSource payload, WebSocket.PayloadType type) throws IOException {
        if (type != WebSocket.PayloadType.TEXT) {
            FLog.w((String)TAG, (String)("Websocket received unexpected message with payload of type " + type));
            return;
        }
        String message = null;
        try {
            message = payload.readUtf8();
        }
        finally {
            payload.close();
        }
        Integer replyID = null;
        try {
            JsonParser parser = new JsonFactory().createParser(message);
            String result = null;
            while (parser.nextToken() != JsonToken.END_OBJECT) {
                String field = parser.getCurrentName();
                if ("replyID".equals(field)) {
                    parser.nextToken();
                    replyID = parser.getIntValue();
                    continue;
                }
                if (!"result".equals(field)) continue;
                parser.nextToken();
                result = parser.getText();
            }
            if (replyID != null) {
                this.triggerRequestSuccess(replyID, result);
            }
        }
        catch (IOException e) {
            if (replyID != null) {
                this.triggerRequestFailure(replyID, e);
            }
            this.abort("Parsing response message from websocket failed", e);
        }
    }

    public void onFailure(IOException e, Response response) {
        this.abort("Websocket exception", e);
    }

    public void onOpen(WebSocket webSocket, Response response) {
        this.mWebSocket = webSocket;
        ((JSDebuggerCallback)Assertions.assertNotNull((Object)this.mConnectCallback)).onSuccess(null);
        this.mConnectCallback = null;
    }

    public void onClose(int code, String reason) {
        this.mWebSocket = null;
    }

    public void onPong(Buffer payload) {
    }

    private void abort(String message, Throwable cause) {
        FLog.e((String)TAG, (String)("Error occurred, shutting down websocket connection: " + message), (Throwable)cause);
        this.closeQuietly();
        if (this.mConnectCallback != null) {
            this.mConnectCallback.onFailure(cause);
            this.mConnectCallback = null;
        }
        for (JSDebuggerCallback callback : this.mCallbacks.values()) {
            callback.onFailure(cause);
        }
        this.mCallbacks.clear();
    }

    public static interface JSDebuggerCallback {
        public void onSuccess(@Nullable String var1);

        public void onFailure(Throwable var1);
    }
}

