/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.bridge;

import com.facebook.react.bridge.JavaScriptModule;
import com.facebook.react.bridge.JavaScriptModuleRegistration;
import com.facebook.react.bridge.JsonWriter;
import com.facebook.react.bridge.SupportsWebWorkers;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class JavaScriptModulesConfig {
    private final List<JavaScriptModuleRegistration> mModules;

    public JavaScriptModulesConfig(List<JavaScriptModuleRegistration> modules) {
        this.mModules = modules;
    }

    public List<JavaScriptModuleRegistration> getModuleDefinitions() {
        return this.mModules;
    }

    public void writeModuleDescriptions(JsonWriter writer) throws IOException {
        writer.beginObject();
        for (JavaScriptModuleRegistration registration : this.mModules) {
            writer.name(registration.getName()).beginObject();
            this.appendJSModuleToJSONObject(writer, registration);
            writer.endObject();
        }
        writer.endObject();
    }

    private void appendJSModuleToJSONObject(JsonWriter writer, JavaScriptModuleRegistration registration) throws IOException {
        writer.name("moduleID").value(registration.getModuleId());
        writer.name("methods").beginObject();
        for (Method method : registration.getMethods()) {
            writer.name(method.getName()).beginObject();
            writer.name("methodID").value(registration.getMethodId(method));
            writer.endObject();
        }
        writer.endObject();
        if (registration.getModuleInterface().isAnnotationPresent(SupportsWebWorkers.class)) {
            writer.name("supportsWebWorkers").value(true);
        }
    }

    public static class Builder {
        private int mLastJSModuleId = 0;
        private List<JavaScriptModuleRegistration> mModules = new ArrayList<JavaScriptModuleRegistration>();

        public Builder add(Class<? extends JavaScriptModule> moduleInterfaceClass) {
            int moduleId = this.mLastJSModuleId++;
            this.mModules.add(new JavaScriptModuleRegistration(moduleId, moduleInterfaceClass));
            return this;
        }

        public JavaScriptModulesConfig build() {
            return new JavaScriptModulesConfig(this.mModules);
        }
    }
}

