/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.bridge;

import com.facebook.infer.annotation.Assertions;
import com.facebook.react.bridge.CatalystInstance;
import com.facebook.react.bridge.ExecutorToken;
import com.facebook.react.bridge.JsonWriter;
import com.facebook.react.bridge.NativeModule;
import com.facebook.react.bridge.OnBatchCompleteListener;
import com.facebook.react.bridge.OnExecutorUnregisteredListener;
import com.facebook.react.bridge.ReactBridge;
import com.facebook.react.bridge.ReactMarker;
import com.facebook.react.bridge.ReadableNativeArray;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.common.MapBuilder;
import com.facebook.systrace.Systrace;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class NativeModuleRegistry {
    private final List<ModuleDefinition> mModuleTable;
    private final Map<Class<? extends NativeModule>, NativeModule> mModuleInstances;
    private final ArrayList<OnBatchCompleteListener> mBatchCompleteListenerModules;
    private final ArrayList<OnExecutorUnregisteredListener> mOnExecutorUnregisteredListenerModules;

    private NativeModuleRegistry(List<ModuleDefinition> moduleTable, Map<Class<? extends NativeModule>, NativeModule> moduleInstances) {
        this.mModuleTable = moduleTable;
        this.mModuleInstances = moduleInstances;
        this.mBatchCompleteListenerModules = new ArrayList(this.mModuleTable.size());
        this.mOnExecutorUnregisteredListenerModules = new ArrayList(this.mModuleTable.size());
        for (int i = 0; i < this.mModuleTable.size(); ++i) {
            ModuleDefinition definition = this.mModuleTable.get(i);
            if (definition.target instanceof OnBatchCompleteListener) {
                this.mBatchCompleteListenerModules.add((OnBatchCompleteListener)((Object)definition.target));
            }
            if (!(definition.target instanceof OnExecutorUnregisteredListener)) continue;
            this.mOnExecutorUnregisteredListenerModules.add((OnExecutorUnregisteredListener)((Object)definition.target));
        }
    }

    void call(CatalystInstance catalystInstance, ExecutorToken executorToken, int moduleId, int methodId, ReadableNativeArray parameters) {
        ModuleDefinition definition = this.mModuleTable.get(moduleId);
        if (definition == null) {
            throw new RuntimeException("Call to unknown module: " + moduleId);
        }
        definition.call(catalystInstance, executorToken, methodId, parameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeModuleDescriptions(JsonWriter writer) throws IOException {
        Systrace.beginSection(0L, "CreateJSON");
        try {
            writer.beginObject();
            for (ModuleDefinition moduleDef : this.mModuleTable) {
                writer.name(moduleDef.name).beginObject();
                writer.name("moduleID").value(moduleDef.id);
                writer.name("supportsWebWorkers").value(moduleDef.target.supportsWebWorkers());
                writer.name("methods").beginObject();
                for (int i = 0; i < moduleDef.methods.size(); ++i) {
                    MethodRegistration method = moduleDef.methods.get(i);
                    writer.name(method.name).beginObject();
                    writer.name("methodID").value(i);
                    writer.name("type").value(method.method.getType());
                    writer.endObject();
                }
                writer.endObject();
                moduleDef.target.writeConstantsField(writer, "constants");
                writer.endObject();
            }
            writer.endObject();
        }
        finally {
            Systrace.endSection(0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyCatalystInstanceDestroy() {
        UiThreadUtil.assertOnUiThread();
        Systrace.beginSection(0L, "NativeModuleRegistry_notifyCatalystInstanceDestroy");
        try {
            for (NativeModule nativeModule : this.mModuleInstances.values()) {
                nativeModule.onCatalystInstanceDestroy();
            }
        }
        finally {
            Systrace.endSection(0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyCatalystInstanceInitialized() {
        UiThreadUtil.assertOnUiThread();
        ReactMarker.logMarker("NativeModule_start");
        Systrace.beginSection(0L, "NativeModuleRegistry_notifyCatalystInstanceInitialized");
        try {
            for (NativeModule nativeModule : this.mModuleInstances.values()) {
                nativeModule.initialize();
            }
        }
        finally {
            Systrace.endSection(0L);
            ReactMarker.logMarker("NativeModule_end");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyReactBridgeInitialized(ReactBridge bridge) {
        Systrace.beginSection(0L, "NativeModuleRegistry_notifyReactBridgeInitialized");
        try {
            for (NativeModule nativeModule : this.mModuleInstances.values()) {
                nativeModule.onReactBridgeInitialized(bridge);
            }
        }
        finally {
            Systrace.endSection(0L);
        }
    }

    public void onBatchComplete() {
        for (int i = 0; i < this.mBatchCompleteListenerModules.size(); ++i) {
            this.mBatchCompleteListenerModules.get(i).onBatchComplete();
        }
    }

    public void onExecutorUnregistered(ExecutorToken executorToken) {
        for (int i = 0; i < this.mOnExecutorUnregisteredListenerModules.size(); ++i) {
            this.mOnExecutorUnregisteredListenerModules.get(i).onExecutorDestroyed(executorToken);
        }
    }

    public <T extends NativeModule> T getModule(Class<T> moduleInterface) {
        return (T)((NativeModule)Assertions.assertNotNull((Object)this.mModuleInstances.get(moduleInterface)));
    }

    public Collection<NativeModule> getAllModules() {
        return this.mModuleInstances.values();
    }

    public static class Builder {
        private final HashMap<String, NativeModule> mModules = MapBuilder.newHashMap();

        public Builder add(NativeModule module) {
            NativeModule existing = this.mModules.get(module.getName());
            if (existing != null && !module.canOverrideExistingModule()) {
                throw new IllegalStateException("Native module " + module.getClass().getSimpleName() + " tried to override " + existing.getClass().getSimpleName() + " for module name " + module.getName() + ". If this was your intention, return true from " + module.getClass().getSimpleName() + "#canOverrideExistingModule()");
            }
            this.mModules.put(module.getName(), module);
            return this;
        }

        public NativeModuleRegistry build() {
            ArrayList<ModuleDefinition> moduleTable = new ArrayList<ModuleDefinition>();
            HashMap moduleInstances = new HashMap();
            int idx = 0;
            for (NativeModule module : this.mModules.values()) {
                ModuleDefinition moduleDef = new ModuleDefinition(idx++, module.getName(), module);
                moduleTable.add(moduleDef);
                moduleInstances.put(module.getClass(), module);
            }
            return new NativeModuleRegistry(moduleTable, moduleInstances);
        }
    }

    private static class MethodRegistration {
        public String name;
        public String tracingName;
        public NativeModule.NativeMethod method;

        public MethodRegistration(String name, String tracingName, NativeModule.NativeMethod method) {
            this.name = name;
            this.tracingName = tracingName;
            this.method = method;
        }
    }

    private static class ModuleDefinition {
        public final int id;
        public final String name;
        public final NativeModule target;
        public final ArrayList<MethodRegistration> methods;

        public ModuleDefinition(int id, String name, NativeModule target) {
            this.id = id;
            this.name = name;
            this.target = target;
            this.methods = new ArrayList();
            for (Map.Entry<String, NativeModule.NativeMethod> entry : target.getMethods().entrySet()) {
                this.methods.add(new MethodRegistration(entry.getKey(), "NativeCall__" + target.getName() + "_" + entry.getKey(), entry.getValue()));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void call(CatalystInstance catalystInstance, ExecutorToken executorToken, int methodId, ReadableNativeArray parameters) {
            MethodRegistration method = this.methods.get(methodId);
            Systrace.beginSection(0L, method.tracingName);
            try {
                this.methods.get((int)methodId).method.invoke(catalystInstance, executorToken, parameters);
            }
            finally {
                Systrace.endSection(0L);
            }
        }
    }
}

