/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.devsupport;

import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.FrameLayout;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.devsupport.FpsView;
import javax.annotation.Nullable;

class DebugOverlayController {
    private final WindowManager mWindowManager;
    private final ReactContext mReactContext;
    @Nullable
    private FrameLayout mFPSDebugViewContainer;

    public DebugOverlayController(ReactContext reactContext) {
        this.mReactContext = reactContext;
        this.mWindowManager = (WindowManager)reactContext.getSystemService("window");
    }

    public void setFpsDebugViewVisible(boolean fpsDebugViewVisible) {
        if (fpsDebugViewVisible && this.mFPSDebugViewContainer == null) {
            this.mFPSDebugViewContainer = new FpsView(this.mReactContext);
            WindowManager.LayoutParams params = new WindowManager.LayoutParams(-1, -1, 2006, 24, -3);
            this.mWindowManager.addView((View)this.mFPSDebugViewContainer, (ViewGroup.LayoutParams)params);
        } else if (!fpsDebugViewVisible && this.mFPSDebugViewContainer != null) {
            this.mFPSDebugViewContainer.removeAllViews();
            this.mWindowManager.removeView((View)this.mFPSDebugViewContainer);
            this.mFPSDebugViewContainer = null;
        }
    }
}

