/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.devsupport;

import android.text.TextUtils;
import com.facebook.common.logging.FLog;
import java.io.IOException;
import javax.annotation.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

public class DebugServerException
extends IOException {
    private DebugServerException(String description, String fileName, int lineNumber, int column) {
        super(description + "\n  at " + fileName + ":" + lineNumber + ":" + column);
    }

    public DebugServerException(String description) {
        super(description);
    }

    @Nullable
    public static DebugServerException parse(String str) {
        if (TextUtils.isEmpty((CharSequence)str)) {
            return null;
        }
        try {
            JSONObject jsonObject = new JSONObject(str);
            String fullFileName = jsonObject.getString("filename");
            return new DebugServerException(jsonObject.getString("description"), DebugServerException.shortenFileName(fullFileName), jsonObject.getInt("lineNumber"), jsonObject.getInt("column"));
        }
        catch (JSONException e) {
            FLog.w((String)"React", (String)("Could not parse DebugServerException from: " + str), (Throwable)e);
            return null;
        }
    }

    private static String shortenFileName(String fullFileName) {
        String[] parts = fullFileName.split("/");
        return parts[parts.length - 1];
    }
}

