/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.devsupport;

import android.content.Context;
import android.os.Handler;
import android.text.TextUtils;
import com.facebook.common.logging.FLog;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.devsupport.DebugServerException;
import com.facebook.react.devsupport.DevInternalSettings;
import com.facebook.react.modules.systeminfo.AndroidInfoHelpers;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Callback;
import com.squareup.okhttp.ConnectionPool;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import okio.Okio;
import okio.Sink;
import okio.Source;

public class DevServerHelper {
    public static final String RELOAD_APP_EXTRA_JS_PROXY = "jsproxy";
    private static final String RELOAD_APP_ACTION_SUFFIX = ".RELOAD_APP_ACTION";
    private static final String BUNDLE_URL_FORMAT = "http://%s/%s.bundle?platform=android&dev=%s&hot=%s&minify=%s";
    private static final String SOURCE_MAP_URL_FORMAT = "http://%s/%s.bundle?platform=android&dev=%s&hot=%s&minify=%s".replaceFirst("\\.bundle", ".map");
    private static final String LAUNCH_CHROME_DEVTOOLS_COMMAND_URL_FORMAT = "http://%s/launch-chrome-devtools";
    private static final String ONCHANGE_ENDPOINT_URL_FORMAT = "http://%s/onchange";
    private static final String WEBSOCKET_PROXY_URL_FORMAT = "ws://%s/debugger-proxy?role=client";
    private static final String PACKAGER_STATUS_URL_FORMAT = "http://%s/status";
    private static final String PACKAGER_OK_STATUS = "packager-status:running";
    private static final int LONG_POLL_KEEP_ALIVE_DURATION_MS = 120000;
    private static final int LONG_POLL_FAILURE_DELAY_MS = 5000;
    private static final int HTTP_CONNECT_TIMEOUT_MS = 5000;
    private final DevInternalSettings mSettings;
    private final OkHttpClient mClient;
    private final Handler mRestartOnChangePollingHandler;
    private boolean mOnChangePollingEnabled;
    @Nullable
    private OkHttpClient mOnChangePollingClient;
    @Nullable
    private OnServerContentChangeListener mOnServerContentChangeListener;
    @Nullable
    private Call mDownloadBundleFromURLCall;

    public DevServerHelper(DevInternalSettings settings) {
        this.mSettings = settings;
        this.mClient = new OkHttpClient();
        this.mClient.setConnectTimeout(5000L, TimeUnit.MILLISECONDS);
        this.mClient.setReadTimeout(0L, TimeUnit.MILLISECONDS);
        this.mClient.setWriteTimeout(0L, TimeUnit.MILLISECONDS);
        this.mRestartOnChangePollingHandler = new Handler();
    }

    public static String getReloadAppAction(Context context) {
        return context.getPackageName() + RELOAD_APP_ACTION_SUFFIX;
    }

    public String getWebsocketProxyURL() {
        return String.format(Locale.US, WEBSOCKET_PROXY_URL_FORMAT, this.getDebugServerHost());
    }

    private static String getHostForJSProxy() {
        return "localhost:8081";
    }

    private boolean getDevMode() {
        return this.mSettings.isJSDevModeEnabled();
    }

    private boolean getJSMinifyMode() {
        return this.mSettings.isJSMinifyEnabled();
    }

    private boolean getHMR() {
        return this.mSettings.isHotModuleReplacementEnabled();
    }

    private String getDebugServerHost() {
        String hostFromSettings = this.mSettings.getDebugServerHost();
        if (!TextUtils.isEmpty((CharSequence)hostFromSettings)) {
            return (String)Assertions.assertNotNull((Object)hostFromSettings);
        }
        String host = AndroidInfoHelpers.getServerHost();
        if (host.equals("localhost:8081")) {
            FLog.w((String)"React", (String)"You seem to be running on device. Run 'adb reverse tcp:8081 tcp:8081' to forward the debug server's port to the device.");
        }
        return host;
    }

    private static String createBundleURL(String host, String jsModulePath, boolean devMode, boolean hmr, boolean jsMinify) {
        return String.format(Locale.US, BUNDLE_URL_FORMAT, host, jsModulePath, devMode, hmr, jsMinify);
    }

    public void downloadBundleFromURL(final BundleDownloadCallback callback, String jsModulePath, final File outputFile) {
        String bundleURL = DevServerHelper.createBundleURL(this.getDebugServerHost(), jsModulePath, this.getDevMode(), this.getHMR(), this.getJSMinifyMode());
        final Request request = new Request.Builder().url(bundleURL).build();
        this.mDownloadBundleFromURLCall = (Call)Assertions.assertNotNull((Object)this.mClient.newCall(request));
        this.mDownloadBundleFromURLCall.enqueue(new Callback(){

            public void onFailure(Request request2, IOException e) {
                if (DevServerHelper.this.mDownloadBundleFromURLCall == null || DevServerHelper.this.mDownloadBundleFromURLCall.isCanceled()) {
                    DevServerHelper.this.mDownloadBundleFromURLCall = null;
                    return;
                }
                DevServerHelper.this.mDownloadBundleFromURLCall = null;
                StringBuilder sb = new StringBuilder();
                sb.append("Could not connect to development server.\n\n").append("Try the following to fix the issue:\n").append("\u2022 Ensure that the packager server is running\n").append("\u2022 Ensure that your device/emulator is connected to your machine and has USB debugging enabled - run 'adb devices' to see a list of connected devices\n").append("\u2022 If you're on a physical device connected to the same machine, run 'adb reverse tcp:8081 tcp:8081' to forward requests from your device\n").append("\u2022 If your device is on the same Wi-Fi network, set 'Debug server host & port for device' in 'Dev settings' to your machine's IP address and the port of the local dev server - e.g. 10.0.1.1:8081\n\n").append("URL: ").append(request2.urlString());
                callback.onFailure(new DebugServerException(sb.toString()));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onResponse(Response response) throws IOException {
                if (DevServerHelper.this.mDownloadBundleFromURLCall == null || DevServerHelper.this.mDownloadBundleFromURLCall.isCanceled()) {
                    DevServerHelper.this.mDownloadBundleFromURLCall = null;
                    return;
                }
                DevServerHelper.this.mDownloadBundleFromURLCall = null;
                if (!response.isSuccessful()) {
                    String body = response.body().string();
                    DebugServerException debugServerException = DebugServerException.parse(body);
                    if (debugServerException != null) {
                        callback.onFailure(debugServerException);
                    } else {
                        StringBuilder sb = new StringBuilder();
                        sb.append("The development server returned response error code: ").append(response.code()).append("\n\n").append("URL: ").append(request.urlString()).append("\n\n").append("Body:\n").append(body);
                        callback.onFailure(new DebugServerException(sb.toString()));
                    }
                    return;
                }
                try (Sink output = null;){
                    output = Okio.sink((File)outputFile);
                    Okio.buffer((Source)response.body().source()).readAll(output);
                    callback.onSuccess();
                }
            }
        });
    }

    public void cancelDownloadBundleFromURL() {
        if (this.mDownloadBundleFromURLCall != null) {
            this.mDownloadBundleFromURLCall.cancel();
            this.mDownloadBundleFromURLCall = null;
        }
    }

    public void isPackagerRunning(final PackagerStatusCallback callback) {
        String statusURL = DevServerHelper.createPackagerStatusURL(this.getDebugServerHost());
        Request request = new Request.Builder().url(statusURL).build();
        this.mClient.newCall(request).enqueue(new Callback(){

            public void onFailure(Request request, IOException e) {
                FLog.w((String)"React", (String)("The packager does not seem to be running as we got an IOException requesting its status: " + e.getMessage()));
                callback.onPackagerStatusFetched(false);
            }

            public void onResponse(Response response) throws IOException {
                if (!response.isSuccessful()) {
                    FLog.e((String)"React", (String)("Got non-success http code from packager when requesting status: " + response.code()));
                    callback.onPackagerStatusFetched(false);
                    return;
                }
                ResponseBody body = response.body();
                if (body == null) {
                    FLog.e((String)"React", (String)"Got null body response from packager when requesting status");
                    callback.onPackagerStatusFetched(false);
                    return;
                }
                if (!DevServerHelper.PACKAGER_OK_STATUS.equals(body.string())) {
                    FLog.e((String)"React", (String)("Got unexpected response from packager when requesting status: " + body.string()));
                    callback.onPackagerStatusFetched(false);
                    return;
                }
                callback.onPackagerStatusFetched(true);
            }
        });
    }

    private static String createPackagerStatusURL(String host) {
        return String.format(Locale.US, PACKAGER_STATUS_URL_FORMAT, host);
    }

    public void stopPollingOnChangeEndpoint() {
        this.mOnChangePollingEnabled = false;
        this.mRestartOnChangePollingHandler.removeCallbacksAndMessages(null);
        if (this.mOnChangePollingClient != null) {
            this.mOnChangePollingClient.cancel((Object)this);
            this.mOnChangePollingClient = null;
        }
        this.mOnServerContentChangeListener = null;
    }

    public void startPollingOnChangeEndpoint(OnServerContentChangeListener onServerContentChangeListener) {
        if (this.mOnChangePollingEnabled) {
            return;
        }
        this.mOnChangePollingEnabled = true;
        this.mOnServerContentChangeListener = onServerContentChangeListener;
        this.mOnChangePollingClient = new OkHttpClient();
        this.mOnChangePollingClient.setConnectionPool(new ConnectionPool(1, 120000L)).setConnectTimeout(5000L, TimeUnit.MILLISECONDS);
        this.enqueueOnChangeEndpointLongPolling();
    }

    private void handleOnChangePollingResponse(boolean didServerContentChanged) {
        if (this.mOnChangePollingEnabled) {
            if (didServerContentChanged) {
                UiThreadUtil.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        if (DevServerHelper.this.mOnServerContentChangeListener != null) {
                            DevServerHelper.this.mOnServerContentChangeListener.onServerContentChanged();
                        }
                    }
                });
            }
            this.enqueueOnChangeEndpointLongPolling();
        }
    }

    private void enqueueOnChangeEndpointLongPolling() {
        Request request = new Request.Builder().url(this.createOnChangeEndpointUrl()).tag((Object)this).build();
        ((OkHttpClient)Assertions.assertNotNull((Object)this.mOnChangePollingClient)).newCall(request).enqueue(new Callback(){

            public void onFailure(Request request, IOException e) {
                if (DevServerHelper.this.mOnChangePollingEnabled) {
                    FLog.d((String)"React", (String)"Error while requesting /onchange endpoint", (Throwable)e);
                    DevServerHelper.this.mRestartOnChangePollingHandler.postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            DevServerHelper.this.handleOnChangePollingResponse(false);
                        }
                    }, 5000L);
                }
            }

            public void onResponse(Response response) throws IOException {
                DevServerHelper.this.handleOnChangePollingResponse(response.code() == 205);
            }
        });
    }

    private String createOnChangeEndpointUrl() {
        return String.format(Locale.US, ONCHANGE_ENDPOINT_URL_FORMAT, this.getDebugServerHost());
    }

    private String createLaunchChromeDevtoolsCommandUrl() {
        return String.format(LAUNCH_CHROME_DEVTOOLS_COMMAND_URL_FORMAT, this.getDebugServerHost());
    }

    public void launchChromeDevtools() {
        Request request = new Request.Builder().url(this.createLaunchChromeDevtoolsCommandUrl()).build();
        this.mClient.newCall(request).enqueue(new Callback(){

            public void onFailure(Request request, IOException e) {
            }

            public void onResponse(Response response) throws IOException {
            }
        });
    }

    public String getSourceMapUrl(String mainModuleName) {
        return String.format(Locale.US, SOURCE_MAP_URL_FORMAT, this.getDebugServerHost(), mainModuleName, this.getDevMode(), this.getHMR(), this.getJSMinifyMode());
    }

    public String getSourceUrl(String mainModuleName) {
        return String.format(Locale.US, BUNDLE_URL_FORMAT, this.getDebugServerHost(), mainModuleName, this.getDevMode(), this.getHMR(), this.getJSMinifyMode());
    }

    public String getJSBundleURLForRemoteDebugging(String mainModuleName) {
        return DevServerHelper.createBundleURL(DevServerHelper.getHostForJSProxy(), mainModuleName, this.getDevMode(), this.getHMR(), this.getJSMinifyMode());
    }

    public static interface PackagerStatusCallback {
        public void onPackagerStatusFetched(boolean var1);
    }

    public static interface OnServerContentChangeListener {
        public void onServerContentChanged();
    }

    public static interface BundleDownloadCallback {
        public void onSuccess();

        public void onFailure(Exception var1);
    }
}

