/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.core;

import android.util.SparseArray;
import android.view.Choreographer;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.ExecutorToken;
import com.facebook.react.bridge.LifecycleEventListener;
import com.facebook.react.bridge.OnExecutorUnregisteredListener;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.WritableArray;
import com.facebook.react.common.SystemClock;
import com.facebook.react.modules.core.JSTimersExecution;
import com.facebook.react.uimanager.ReactChoreographer;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;

public final class Timing
extends ReactContextBaseJavaModule
implements LifecycleEventListener,
OnExecutorUnregisteredListener {
    private final Object mTimerGuard = new Object();
    private final PriorityQueue<Timer> mTimers;
    private final HashMap<ExecutorToken, SparseArray<Timer>> mTimerIdsToTimers;
    private final AtomicBoolean isPaused = new AtomicBoolean(true);
    private final FrameCallback mFrameCallback = new FrameCallback();
    @Nullable
    private ReactChoreographer mReactChoreographer;
    private boolean mFrameCallbackPosted = false;

    public Timing(ReactApplicationContext reactContext) {
        super(reactContext);
        this.mTimers = new PriorityQueue<Timer>(11, new Comparator<Timer>(){

            @Override
            public int compare(Timer lhs, Timer rhs) {
                long diff = lhs.mTargetTime - rhs.mTargetTime;
                if (diff == 0L) {
                    return 0;
                }
                if (diff < 0L) {
                    return -1;
                }
                return 1;
            }
        });
        this.mTimerIdsToTimers = new HashMap();
    }

    @Override
    public void initialize() {
        this.mReactChoreographer = ReactChoreographer.getInstance();
        this.getReactApplicationContext().addLifecycleEventListener(this);
    }

    @Override
    public void onHostPause() {
        this.isPaused.set(true);
        this.clearChoreographerCallback();
    }

    @Override
    public void onHostDestroy() {
        this.clearChoreographerCallback();
    }

    @Override
    public void onHostResume() {
        this.isPaused.set(false);
        this.setChoreographerCallback();
    }

    @Override
    public void onCatalystInstanceDestroy() {
        this.clearChoreographerCallback();
    }

    private void setChoreographerCallback() {
        if (!this.mFrameCallbackPosted) {
            ((ReactChoreographer)Assertions.assertNotNull((Object)this.mReactChoreographer)).postFrameCallback(ReactChoreographer.CallbackType.TIMERS_EVENTS, this.mFrameCallback);
            this.mFrameCallbackPosted = true;
        }
    }

    private void clearChoreographerCallback() {
        if (this.mFrameCallbackPosted) {
            ((ReactChoreographer)Assertions.assertNotNull((Object)this.mReactChoreographer)).removeFrameCallback(ReactChoreographer.CallbackType.TIMERS_EVENTS, this.mFrameCallback);
            this.mFrameCallbackPosted = false;
        }
    }

    @Override
    public String getName() {
        return "RKTiming";
    }

    @Override
    public boolean supportsWebWorkers() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onExecutorDestroyed(ExecutorToken executorToken) {
        Object object = this.mTimerGuard;
        synchronized (object) {
            SparseArray<Timer> timersForContext = this.mTimerIdsToTimers.remove(executorToken);
            if (timersForContext == null) {
                return;
            }
            for (int i = 0; i < timersForContext.size(); ++i) {
                Timer timer = (Timer)timersForContext.get(timersForContext.keyAt(i));
                this.mTimers.remove(timer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ReactMethod
    public void createTimer(ExecutorToken executorToken, int callbackID, int duration, double jsSchedulingTime, boolean repeat) {
        long adjustedDuration = (long)Math.max(0.0, jsSchedulingTime - (double)SystemClock.currentTimeMillis() + (double)duration);
        if (duration == 0 && !repeat) {
            WritableArray timerToCall = Arguments.createArray();
            timerToCall.pushInt(callbackID);
            this.getReactApplicationContext().getJSModule(executorToken, JSTimersExecution.class).callTimers(timerToCall);
            return;
        }
        long initialTargetTime = SystemClock.nanoTime() / 1000000L + adjustedDuration;
        Timer timer = new Timer(executorToken, callbackID, initialTargetTime, duration, repeat);
        Object object = this.mTimerGuard;
        synchronized (object) {
            this.mTimers.add(timer);
            SparseArray timersForContext = this.mTimerIdsToTimers.get(executorToken);
            if (timersForContext == null) {
                timersForContext = new SparseArray();
                this.mTimerIdsToTimers.put(executorToken, (SparseArray<Timer>)timersForContext);
            }
            timersForContext.put(callbackID, (Object)timer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ReactMethod
    public void deleteTimer(ExecutorToken executorToken, int timerId) {
        Object object = this.mTimerGuard;
        synchronized (object) {
            SparseArray<Timer> timersForContext = this.mTimerIdsToTimers.get(executorToken);
            if (timersForContext == null) {
                return;
            }
            Timer timer = (Timer)timersForContext.get(timerId);
            if (timer == null) {
                return;
            }
            this.mTimerIdsToTimers.remove(timerId);
            this.mTimers.remove(timer);
        }
    }

    private class FrameCallback
    implements Choreographer.FrameCallback {
        private final HashMap<ExecutorToken, WritableArray> mTimersToCall = new HashMap();

        private FrameCallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doFrame(long frameTimeNanos) {
            if (Timing.this.isPaused.get()) {
                return;
            }
            long frameTimeMillis = frameTimeNanos / 1000000L;
            Object object = Timing.this.mTimerGuard;
            synchronized (object) {
                while (!Timing.this.mTimers.isEmpty() && ((Timer)Timing.this.mTimers.peek()).mTargetTime < frameTimeMillis) {
                    Timer timer = (Timer)Timing.this.mTimers.poll();
                    WritableArray timersForContext = this.mTimersToCall.get(timer.mExecutorToken);
                    if (timersForContext == null) {
                        timersForContext = Arguments.createArray();
                        this.mTimersToCall.put(timer.mExecutorToken, timersForContext);
                    }
                    timersForContext.pushInt(timer.mCallbackID);
                    if (timer.mRepeat) {
                        timer.mTargetTime = frameTimeMillis + (long)timer.mInterval;
                        Timing.this.mTimers.add(timer);
                        continue;
                    }
                    Timing.this.mTimerIdsToTimers.remove(timer.mCallbackID);
                }
            }
            for (Map.Entry<ExecutorToken, WritableArray> entry : this.mTimersToCall.entrySet()) {
                Timing.this.getReactApplicationContext().getJSModule(entry.getKey(), JSTimersExecution.class).callTimers(entry.getValue());
            }
            this.mTimersToCall.clear();
            ((ReactChoreographer)Assertions.assertNotNull((Object)Timing.this.mReactChoreographer)).postFrameCallback(ReactChoreographer.CallbackType.TIMERS_EVENTS, this);
        }
    }

    private static class Timer {
        private final ExecutorToken mExecutorToken;
        private final int mCallbackID;
        private final boolean mRepeat;
        private final int mInterval;
        private long mTargetTime;

        private Timer(ExecutorToken executorToken, int callbackID, long initialTargetTime, int duration, boolean repeat) {
            this.mExecutorToken = executorToken;
            this.mCallbackID = callbackID;
            this.mTargetTime = initialTargetTime;
            this.mInterval = duration;
            this.mRepeat = repeat;
        }
    }
}

