/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.network;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import android.webkit.CookieManager;
import android.webkit.CookieSyncManager;
import android.webkit.ValueCallback;
import com.facebook.react.bridge.Callback;
import com.facebook.react.bridge.GuardedAsyncTask;
import com.facebook.react.bridge.GuardedResultAsyncTask;
import com.facebook.react.bridge.ReactContext;
import java.io.IOException;
import java.net.CookieHandler;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class ForwardingCookieHandler
extends CookieHandler {
    private static final String VERSION_ZERO_HEADER = "Set-cookie";
    private static final String VERSION_ONE_HEADER = "Set-cookie2";
    private static final String COOKIE_HEADER = "Cookie";
    private static final boolean USES_LEGACY_STORE = Build.VERSION.SDK_INT < 21;
    private final CookieSaver mCookieSaver;
    private final ReactContext mContext;
    @Nullable
    private CookieManager mCookieManager;

    public ForwardingCookieHandler(ReactContext context) {
        this.mContext = context;
        this.mCookieSaver = new CookieSaver();
    }

    @Override
    public Map<String, List<String>> get(URI uri, Map<String, List<String>> headers) throws IOException {
        String cookies = this.getCookieManager().getCookie(uri.toString());
        if (TextUtils.isEmpty((CharSequence)cookies)) {
            return Collections.emptyMap();
        }
        return Collections.singletonMap(COOKIE_HEADER, Collections.singletonList(cookies));
    }

    @Override
    public void put(URI uri, Map<String, List<String>> headers) throws IOException {
        String url = uri.toString();
        for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
            String key = entry.getKey();
            if (key == null || !ForwardingCookieHandler.isCookieHeader(key)) continue;
            this.addCookies(url, entry.getValue());
        }
    }

    public void clearCookies(final Callback callback) {
        if (USES_LEGACY_STORE) {
            new GuardedResultAsyncTask<Boolean>(this.mContext){

                @Override
                protected Boolean doInBackgroundGuarded() {
                    ForwardingCookieHandler.this.getCookieManager().removeAllCookie();
                    ForwardingCookieHandler.this.mCookieSaver.onCookiesModified();
                    return true;
                }

                @Override
                protected void onPostExecuteGuarded(Boolean result) {
                    callback.invoke(result);
                }
            }.execute(new Void[0]);
        } else {
            this.clearCookiesAsync(callback);
        }
    }

    private void clearCookiesAsync(final Callback callback) {
        this.getCookieManager().removeAllCookies((ValueCallback)new ValueCallback<Boolean>(){

            public void onReceiveValue(Boolean value) {
                ForwardingCookieHandler.this.mCookieSaver.onCookiesModified();
                callback.invoke(value);
            }
        });
    }

    public void destroy() {
        if (USES_LEGACY_STORE) {
            this.getCookieManager().removeExpiredCookie();
            this.mCookieSaver.persistCookies();
        }
    }

    private void addCookies(final String url, final List<String> cookies) {
        if (USES_LEGACY_STORE) {
            this.runInBackground(new Runnable(){

                @Override
                public void run() {
                    for (String cookie : cookies) {
                        ForwardingCookieHandler.this.getCookieManager().setCookie(url, cookie);
                    }
                    ForwardingCookieHandler.this.mCookieSaver.onCookiesModified();
                }
            });
        } else {
            for (String cookie : cookies) {
                this.addCookieAsync(url, cookie);
            }
            this.mCookieSaver.onCookiesModified();
        }
    }

    @TargetApi(value=21)
    private void addCookieAsync(String url, String cookie) {
        this.getCookieManager().setCookie(url, cookie, null);
    }

    private static boolean isCookieHeader(String name) {
        return name.equalsIgnoreCase(VERSION_ZERO_HEADER) || name.equalsIgnoreCase(VERSION_ONE_HEADER);
    }

    private void runInBackground(final Runnable runnable) {
        new GuardedAsyncTask<Void, Void>(this.mContext){

            protected void doInBackgroundGuarded(Void ... params) {
                runnable.run();
            }
        }.execute(new Void[0]);
    }

    private CookieManager getCookieManager() {
        if (this.mCookieManager == null) {
            ForwardingCookieHandler.possiblyWorkaroundSyncManager((Context)this.mContext);
            this.mCookieManager = CookieManager.getInstance();
            if (USES_LEGACY_STORE) {
                this.mCookieManager.removeExpiredCookie();
            }
        }
        return this.mCookieManager;
    }

    private static void possiblyWorkaroundSyncManager(Context context) {
        if (USES_LEGACY_STORE) {
            CookieSyncManager syncManager = CookieSyncManager.createInstance((Context)context);
            syncManager.sync();
        }
    }

    private class CookieSaver {
        private static final int MSG_PERSIST_COOKIES = 1;
        private static final int TIMEOUT = 30000;
        private final Handler mHandler;

        public CookieSaver() {
            this.mHandler = new Handler(Looper.getMainLooper(), new Handler.Callback(){

                public boolean handleMessage(Message msg) {
                    if (msg.what == 1) {
                        CookieSaver.this.persistCookies();
                        return true;
                    }
                    return false;
                }
            });
        }

        public void onCookiesModified() {
            if (USES_LEGACY_STORE) {
                this.mHandler.sendEmptyMessageDelayed(1, 30000L);
            }
        }

        public void persistCookies() {
            this.mHandler.removeMessages(1);
            ForwardingCookieHandler.this.runInBackground(new Runnable(){

                @Override
                public void run() {
                    if (USES_LEGACY_STORE) {
                        CookieSyncManager syncManager = CookieSyncManager.getInstance();
                        syncManager.sync();
                    } else {
                        CookieSaver.this.flush();
                    }
                }
            });
        }

        @TargetApi(value=21)
        private void flush() {
            ForwardingCookieHandler.this.getCookieManager().flush();
        }
    }
}

