/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.network;

import android.content.Context;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.ExecutorToken;
import com.facebook.react.bridge.GuardedAsyncTask;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.WritableArray;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.modules.core.DeviceEventManagerModule;
import com.facebook.react.modules.network.ForwardingCookieHandler;
import com.facebook.react.modules.network.OkHttpClientProvider;
import com.facebook.react.modules.network.RequestBodyUtil;
import com.facebook.stetho.okhttp.StethoInterceptor;
import com.squareup.okhttp.Callback;
import com.squareup.okhttp.Headers;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.MultipartBuilder;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.CookieHandler;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public final class NetworkingModule
extends ReactContextBaseJavaModule {
    private static final String CONTENT_ENCODING_HEADER_NAME = "content-encoding";
    private static final String CONTENT_TYPE_HEADER_NAME = "content-type";
    private static final String REQUEST_BODY_KEY_STRING = "string";
    private static final String REQUEST_BODY_KEY_URI = "uri";
    private static final String REQUEST_BODY_KEY_FORMDATA = "formData";
    private static final String USER_AGENT_HEADER_NAME = "user-agent";
    private static final int MIN_BUFFER_SIZE = 8192;
    private static final int MAX_BUFFER_SIZE = 524288;
    private static final int CHUNK_TIMEOUT_NS = 100000000;
    private final OkHttpClient mClient;
    private final ForwardingCookieHandler mCookieHandler;
    @Nullable
    private final String mDefaultUserAgent;
    private boolean mShuttingDown;

    NetworkingModule(ReactApplicationContext reactContext, @Nullable String defaultUserAgent, OkHttpClient client) {
        super(reactContext);
        this.mClient = client;
        this.mClient.networkInterceptors().add(new StethoInterceptor());
        this.mCookieHandler = new ForwardingCookieHandler(reactContext);
        this.mShuttingDown = false;
        this.mDefaultUserAgent = defaultUserAgent;
    }

    public NetworkingModule(ReactApplicationContext context) {
        this(context, null, OkHttpClientProvider.getOkHttpClient());
    }

    public NetworkingModule(ReactApplicationContext context, String defaultUserAgent) {
        this(context, defaultUserAgent, OkHttpClientProvider.getOkHttpClient());
    }

    public NetworkingModule(ReactApplicationContext reactContext, OkHttpClient client) {
        this(reactContext, null, client);
    }

    @Override
    public void initialize() {
        this.mClient.setCookieHandler((CookieHandler)this.mCookieHandler);
    }

    @Override
    public String getName() {
        return "RCTNetworking";
    }

    @Override
    public void onCatalystInstanceDestroy() {
        this.mShuttingDown = true;
        this.mClient.cancel(null);
        this.mCookieHandler.destroy();
        this.mClient.setCookieHandler(null);
    }

    @ReactMethod
    public void sendRequest(final ExecutorToken executorToken, String method, String url, final int requestId, ReadableArray headers, ReadableMap data, final boolean useIncrementalUpdates, int timeout) {
        Headers requestHeaders;
        Request.Builder requestBuilder = new Request.Builder().url(url);
        if (requestId != 0) {
            requestBuilder.tag((Object)requestId);
        }
        OkHttpClient client = this.mClient;
        if (timeout != this.mClient.getConnectTimeout()) {
            client = this.mClient.clone();
            client.setReadTimeout((long)timeout, TimeUnit.MILLISECONDS);
        }
        if ((requestHeaders = this.extractHeaders(headers, data)) == null) {
            this.onRequestError(executorToken, requestId, "Unrecognized headers format");
            return;
        }
        String contentType = requestHeaders.get(CONTENT_TYPE_HEADER_NAME);
        String contentEncoding = requestHeaders.get(CONTENT_ENCODING_HEADER_NAME);
        requestBuilder.headers(requestHeaders);
        if (data == null) {
            requestBuilder.method(method, RequestBodyUtil.getEmptyBody(method));
        } else if (data.hasKey(REQUEST_BODY_KEY_STRING)) {
            if (contentType == null) {
                this.onRequestError(executorToken, requestId, "Payload is set but no content-type header specified");
                return;
            }
            String body = data.getString(REQUEST_BODY_KEY_STRING);
            MediaType contentMediaType = MediaType.parse((String)contentType);
            if (RequestBodyUtil.isGzipEncoding(contentEncoding)) {
                RequestBody requestBody = RequestBodyUtil.createGzip(contentMediaType, body);
                if (requestBody == null) {
                    this.onRequestError(executorToken, requestId, "Failed to gzip request body");
                    return;
                }
                requestBuilder.method(method, requestBody);
            } else {
                requestBuilder.method(method, RequestBody.create((MediaType)contentMediaType, (String)body));
            }
        } else if (data.hasKey(REQUEST_BODY_KEY_URI)) {
            if (contentType == null) {
                this.onRequestError(executorToken, requestId, "Payload is set but no content-type header specified");
                return;
            }
            String uri = data.getString(REQUEST_BODY_KEY_URI);
            InputStream fileInputStream = RequestBodyUtil.getFileInputStream((Context)this.getReactApplicationContext(), uri);
            if (fileInputStream == null) {
                this.onRequestError(executorToken, requestId, "Could not retrieve file for uri " + uri);
                return;
            }
            requestBuilder.method(method, RequestBodyUtil.create(MediaType.parse((String)contentType), fileInputStream));
        } else if (data.hasKey(REQUEST_BODY_KEY_FORMDATA)) {
            ReadableArray parts;
            MultipartBuilder multipartBuilder;
            if (contentType == null) {
                contentType = "multipart/form-data";
            }
            if ((multipartBuilder = this.constructMultipartBody(executorToken, parts = data.getArray(REQUEST_BODY_KEY_FORMDATA), contentType, requestId)) == null) {
                return;
            }
            requestBuilder.method(method, multipartBuilder.build());
        } else {
            requestBuilder.method(method, RequestBodyUtil.getEmptyBody(method));
        }
        client.newCall(requestBuilder.build()).enqueue(new Callback(){

            public void onFailure(Request request, IOException e) {
                if (NetworkingModule.this.mShuttingDown) {
                    return;
                }
                NetworkingModule.this.onRequestError(executorToken, requestId, e.getMessage());
            }

            public void onResponse(Response response) throws IOException {
                if (NetworkingModule.this.mShuttingDown) {
                    return;
                }
                NetworkingModule.this.onResponseReceived(executorToken, requestId, response);
                ResponseBody responseBody = response.body();
                try {
                    if (useIncrementalUpdates) {
                        NetworkingModule.this.readWithProgress(executorToken, requestId, responseBody);
                        NetworkingModule.this.onRequestSuccess(executorToken, requestId);
                    } else {
                        NetworkingModule.this.onDataReceived(executorToken, requestId, responseBody.string());
                        NetworkingModule.this.onRequestSuccess(executorToken, requestId);
                    }
                }
                catch (IOException e) {
                    NetworkingModule.this.onRequestError(executorToken, requestId, e.getMessage());
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readWithProgress(ExecutorToken executorToken, int requestId, ResponseBody responseBody) throws IOException {
        try (Reader reader = responseBody.charStream();){
            int read;
            StringBuilder sb = new StringBuilder(NetworkingModule.getBufferSize(responseBody));
            char[] buffer = new char[8192];
            long last = System.nanoTime();
            while ((read = reader.read(buffer)) != -1) {
                sb.append(buffer, 0, read);
                long now = System.nanoTime();
                if (!NetworkingModule.shouldDispatch(now, last)) continue;
                this.onDataReceived(executorToken, requestId, sb.toString());
                sb.setLength(0);
                last = now;
            }
            if (sb.length() > 0) {
                this.onDataReceived(executorToken, requestId, sb.toString());
            }
        }
    }

    private static boolean shouldDispatch(long now, long last) {
        return last + 100000000L < now;
    }

    private static int getBufferSize(ResponseBody responseBody) throws IOException {
        long length = responseBody.contentLength();
        if (length == -1L) {
            return 8192;
        }
        return (int)Math.min(length, 524288L);
    }

    private void onDataReceived(ExecutorToken ExecutorToken2, int requestId, String data) {
        WritableArray args = Arguments.createArray();
        args.pushInt(requestId);
        args.pushString(data);
        this.getEventEmitter(ExecutorToken2).emit("didReceiveNetworkData", args);
    }

    private void onRequestError(ExecutorToken ExecutorToken2, int requestId, String error) {
        WritableArray args = Arguments.createArray();
        args.pushInt(requestId);
        args.pushString(error);
        this.getEventEmitter(ExecutorToken2).emit("didCompleteNetworkResponse", args);
    }

    private void onRequestSuccess(ExecutorToken ExecutorToken2, int requestId) {
        WritableArray args = Arguments.createArray();
        args.pushInt(requestId);
        args.pushNull();
        this.getEventEmitter(ExecutorToken2).emit("didCompleteNetworkResponse", args);
    }

    private void onResponseReceived(ExecutorToken ExecutorToken2, int requestId, Response response) {
        WritableMap headers = NetworkingModule.translateHeaders(response.headers());
        WritableArray args = Arguments.createArray();
        args.pushInt(requestId);
        args.pushInt(response.code());
        args.pushMap(headers);
        args.pushString(response.request().urlString());
        this.getEventEmitter(ExecutorToken2).emit("didReceiveNetworkResponse", args);
    }

    private static WritableMap translateHeaders(Headers headers) {
        WritableMap responseHeaders = Arguments.createMap();
        for (int i = 0; i < headers.size(); ++i) {
            String headerName = headers.name(i);
            if (responseHeaders.hasKey(headerName)) {
                responseHeaders.putString(headerName, responseHeaders.getString(headerName) + ", " + headers.value(i));
                continue;
            }
            responseHeaders.putString(headerName, headers.value(i));
        }
        return responseHeaders;
    }

    @ReactMethod
    public void abortRequest(ExecutorToken executorToken, final int requestId) {
        new GuardedAsyncTask<Void, Void>((ReactContext)this.getReactApplicationContext()){

            protected void doInBackgroundGuarded(Void ... params) {
                NetworkingModule.this.mClient.cancel((Object)requestId);
            }
        }.execute(new Void[0]);
    }

    @ReactMethod
    public void clearCookies(ExecutorToken executorToken, com.facebook.react.bridge.Callback callback) {
        this.mCookieHandler.clearCookies(callback);
    }

    @Override
    public boolean supportsWebWorkers() {
        return true;
    }

    @Nullable
    private MultipartBuilder constructMultipartBody(ExecutorToken ExecutorToken2, ReadableArray body, String contentType, int requestId) {
        MultipartBuilder multipartBuilder = new MultipartBuilder();
        multipartBuilder.type(MediaType.parse((String)contentType));
        int size = body.size();
        for (int i = 0; i < size; ++i) {
            ReadableMap bodyPart = body.getMap(i);
            ReadableArray headersArray = bodyPart.getArray("headers");
            Headers headers = this.extractHeaders(headersArray, null);
            if (headers == null) {
                this.onRequestError(ExecutorToken2, requestId, "Missing or invalid header format for FormData part.");
                return null;
            }
            MediaType partContentType = null;
            String partContentTypeStr = headers.get(CONTENT_TYPE_HEADER_NAME);
            if (partContentTypeStr != null) {
                partContentType = MediaType.parse((String)partContentTypeStr);
                headers = headers.newBuilder().removeAll(CONTENT_TYPE_HEADER_NAME).build();
            }
            if (bodyPart.hasKey(REQUEST_BODY_KEY_STRING)) {
                String bodyValue = bodyPart.getString(REQUEST_BODY_KEY_STRING);
                multipartBuilder.addPart(headers, RequestBody.create((MediaType)partContentType, (String)bodyValue));
                continue;
            }
            if (bodyPart.hasKey(REQUEST_BODY_KEY_URI)) {
                if (partContentType == null) {
                    this.onRequestError(ExecutorToken2, requestId, "Binary FormData part needs a content-type header.");
                    return null;
                }
                String fileContentUriStr = bodyPart.getString(REQUEST_BODY_KEY_URI);
                InputStream fileInputStream = RequestBodyUtil.getFileInputStream((Context)this.getReactApplicationContext(), fileContentUriStr);
                if (fileInputStream == null) {
                    this.onRequestError(ExecutorToken2, requestId, "Could not retrieve file for uri " + fileContentUriStr);
                    return null;
                }
                multipartBuilder.addPart(headers, RequestBodyUtil.create(partContentType, fileInputStream));
                continue;
            }
            this.onRequestError(ExecutorToken2, requestId, "Unrecognized FormData part.");
        }
        return multipartBuilder;
    }

    @Nullable
    private Headers extractHeaders(@Nullable ReadableArray headersArray, @Nullable ReadableMap requestData) {
        boolean isGzipSupported;
        if (headersArray == null) {
            return null;
        }
        Headers.Builder headersBuilder = new Headers.Builder();
        int size = headersArray.size();
        for (int headersIdx = 0; headersIdx < size; ++headersIdx) {
            ReadableArray header = headersArray.getArray(headersIdx);
            if (header == null || header.size() != 2) {
                return null;
            }
            String headerName = header.getString(0);
            String headerValue = header.getString(1);
            headersBuilder.add(headerName, headerValue);
        }
        if (headersBuilder.get(USER_AGENT_HEADER_NAME) == null && this.mDefaultUserAgent != null) {
            headersBuilder.add(USER_AGENT_HEADER_NAME, this.mDefaultUserAgent);
        }
        boolean bl = isGzipSupported = requestData != null && requestData.hasKey(REQUEST_BODY_KEY_STRING);
        if (!isGzipSupported) {
            headersBuilder.removeAll(CONTENT_ENCODING_HEADER_NAME);
        }
        return headersBuilder.build();
    }

    private DeviceEventManagerModule.RCTDeviceEventEmitter getEventEmitter(ExecutorToken ExecutorToken2) {
        return this.getReactApplicationContext().getJSModule(ExecutorToken2, DeviceEventManagerModule.RCTDeviceEventEmitter.class);
    }
}

