/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.websocket;

import com.facebook.common.logging.FLog;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.ReadableMapKeySetIterator;
import com.facebook.react.bridge.ReadableType;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.modules.core.DeviceEventManagerModule;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ws.WebSocket;
import com.squareup.okhttp.ws.WebSocketCall;
import com.squareup.okhttp.ws.WebSocketListener;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import okio.Buffer;
import okio.BufferedSource;

public class WebSocketModule
extends ReactContextBaseJavaModule {
    private Map<Integer, WebSocket> mWebSocketConnections = new HashMap<Integer, WebSocket>();
    private ReactContext mReactContext;

    public WebSocketModule(ReactApplicationContext context) {
        super(context);
        this.mReactContext = context;
    }

    private void sendEvent(String eventName, WritableMap params) {
        this.mReactContext.getJSModule(DeviceEventManagerModule.RCTDeviceEventEmitter.class).emit(eventName, params);
    }

    @Override
    public String getName() {
        return "WebSocketModule";
    }

    @ReactMethod
    public void connect(String url, @Nullable ReadableArray protocols, @Nullable ReadableMap headers, final int id) {
        OkHttpClient client = new OkHttpClient();
        client.setConnectTimeout(10L, TimeUnit.SECONDS);
        client.setWriteTimeout(10L, TimeUnit.SECONDS);
        client.setReadTimeout(0L, TimeUnit.MINUTES);
        Request.Builder builder = new Request.Builder().tag((Object)id).url(url);
        if (headers != null) {
            ReadableMapKeySetIterator iterator = headers.keySetIterator();
            if (!headers.hasKey("origin")) {
                builder.addHeader("origin", WebSocketModule.setDefaultOrigin(url));
            }
            while (iterator.hasNextKey()) {
                String key = iterator.nextKey();
                if (ReadableType.String.equals((Object)headers.getType(key))) {
                    builder.addHeader(key, headers.getString(key));
                    continue;
                }
                FLog.w((String)"React", (String)("Ignoring: requested " + key + ", value not a string"));
            }
        } else {
            builder.addHeader("origin", WebSocketModule.setDefaultOrigin(url));
        }
        WebSocketCall.create((OkHttpClient)client, (Request)builder.build()).enqueue(new WebSocketListener(){

            public void onOpen(WebSocket webSocket, Response response) {
                WebSocketModule.this.mWebSocketConnections.put(id, webSocket);
                WritableMap params = Arguments.createMap();
                params.putInt("id", id);
                WebSocketModule.this.sendEvent("websocketOpen", params);
            }

            public void onClose(int code, String reason) {
                WritableMap params = Arguments.createMap();
                params.putInt("id", id);
                params.putInt("code", code);
                params.putString("reason", reason);
                WebSocketModule.this.sendEvent("websocketClosed", params);
            }

            public void onFailure(IOException e, Response response) {
                WebSocketModule.this.notifyWebSocketFailed(id, e.getMessage());
            }

            public void onPong(Buffer buffer) {
            }

            public void onMessage(BufferedSource bufferedSource, WebSocket.PayloadType payloadType) {
                String message;
                try {
                    message = bufferedSource.readUtf8();
                }
                catch (IOException e) {
                    WebSocketModule.this.notifyWebSocketFailed(id, e.getMessage());
                    return;
                }
                try {
                    bufferedSource.close();
                }
                catch (IOException e) {
                    FLog.e((String)"React", (String)("Could not close BufferedSource for WebSocket id " + id), (Throwable)e);
                }
                WritableMap params = Arguments.createMap();
                params.putInt("id", id);
                params.putString("data", message);
                WebSocketModule.this.sendEvent("websocketMessage", params);
            }
        });
        client.getDispatcher().getExecutorService().shutdown();
    }

    @ReactMethod
    public void close(int code, String reason, int id) {
        WebSocket client = this.mWebSocketConnections.get(id);
        if (client == null) {
            FLog.w((String)"React", (String)("Cannot close WebSocket. Unknown WebSocket id " + id));
            return;
        }
        try {
            client.close(code, reason);
            this.mWebSocketConnections.remove(id);
        }
        catch (Exception e) {
            FLog.e((String)"React", (String)("Could not close WebSocket connection for id " + id), (Throwable)e);
        }
    }

    @ReactMethod
    public void send(String message, int id) {
        WebSocket client = this.mWebSocketConnections.get(id);
        if (client == null) {
            throw new RuntimeException("Cannot send a message. Unknown WebSocket id " + id);
        }
        try {
            client.sendMessage(WebSocket.PayloadType.TEXT, new Buffer().writeUtf8(message));
        }
        catch (IOException | IllegalStateException e) {
            this.notifyWebSocketFailed(id, e.getMessage());
        }
    }

    private void notifyWebSocketFailed(int id, String message) {
        WritableMap params = Arguments.createMap();
        params.putInt("id", id);
        params.putString("message", message);
        this.sendEvent("websocketFailed", params);
    }

    private static String setDefaultOrigin(String uri) {
        try {
            String scheme = "";
            URI requestURI = new URI(uri);
            if (requestURI.getScheme().equals("wss")) {
                scheme = scheme + "https";
            } else if (requestURI.getScheme().equals("ws")) {
                scheme = scheme + "http";
            }
            String defaultOrigin = requestURI.getPort() != -1 ? String.format("%s://%s:%s", scheme, requestURI.getHost(), requestURI.getPort()) : String.format("%s://%s/", scheme, requestURI.getHost());
            return defaultOrigin;
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Unable to set " + uri + " as default origin header.");
        }
    }
}

