/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager;

import android.graphics.Matrix;
import android.graphics.PointF;
import android.graphics.Rect;
import android.view.View;
import android.view.ViewGroup;
import com.facebook.react.bridge.JSApplicationIllegalArgumentException;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.touch.ReactHitSlopView;
import com.facebook.react.uimanager.PointerEvents;
import com.facebook.react.uimanager.ReactCompoundView;
import com.facebook.react.uimanager.ReactCompoundViewGroup;
import com.facebook.react.uimanager.ReactPointerEventsView;
import javax.annotation.Nullable;

public class TouchTargetHelper {
    private static final float[] mEventCoords = new float[2];
    private static final PointF mTempPoint = new PointF();
    private static final float[] mMatrixTransformCoords = new float[2];
    private static final Matrix mInverseMatrix = new Matrix();

    public static int findTargetTagForTouch(float eventX, float eventY, ViewGroup viewGroup) {
        return TouchTargetHelper.findTargetTagAndCoordinatesForTouch(eventX, eventY, viewGroup, mEventCoords);
    }

    public static int findTargetTagAndCoordinatesForTouch(float eventX, float eventY, ViewGroup viewGroup, float[] viewCoords) {
        View reactTargetView;
        UiThreadUtil.assertOnUiThread();
        int targetTag = viewGroup.getId();
        viewCoords[0] = eventX;
        viewCoords[1] = eventY;
        View nativeTargetView = TouchTargetHelper.findTouchTargetView(viewCoords, viewGroup);
        if (nativeTargetView != null && (reactTargetView = TouchTargetHelper.findClosestReactAncestor(nativeTargetView)) != null) {
            targetTag = TouchTargetHelper.getTouchTargetForView(reactTargetView, viewCoords[0], viewCoords[1]);
        }
        return targetTag;
    }

    private static View findClosestReactAncestor(View view) {
        while (view != null && view.getId() <= 0) {
            view = (View)view.getParent();
        }
        return view;
    }

    private static View findTouchTargetView(float[] eventCoords, ViewGroup viewGroup) {
        int childrenCount = viewGroup.getChildCount();
        for (int i = childrenCount - 1; i >= 0; --i) {
            PointF childPoint;
            View child = viewGroup.getChildAt(i);
            if (!TouchTargetHelper.isTransformedTouchPointInView(eventCoords[0], eventCoords[1], viewGroup, child, childPoint = mTempPoint)) continue;
            float restoreX = eventCoords[0];
            float restoreY = eventCoords[1];
            eventCoords[0] = childPoint.x;
            eventCoords[1] = childPoint.y;
            View targetView = TouchTargetHelper.findTouchTargetViewWithPointerEvents(eventCoords, child);
            if (targetView != null) {
                return targetView;
            }
            eventCoords[0] = restoreX;
            eventCoords[1] = restoreY;
        }
        return viewGroup;
    }

    private static boolean isTransformedTouchPointInView(float x, float y, ViewGroup parent, View child, PointF outLocalPoint) {
        float localX = x + (float)parent.getScrollX() - (float)child.getLeft();
        float localY = y + (float)parent.getScrollY() - (float)child.getTop();
        Matrix matrix = child.getMatrix();
        if (!matrix.isIdentity()) {
            float[] localXY = mMatrixTransformCoords;
            localXY[0] = localX;
            localXY[1] = localY;
            Matrix inverseMatrix = mInverseMatrix;
            matrix.invert(inverseMatrix);
            inverseMatrix.mapPoints(localXY);
            localX = localXY[0];
            localY = localXY[1];
        }
        if (child instanceof ReactHitSlopView && ((ReactHitSlopView)child).getHitSlopRect() != null) {
            Rect hitSlopRect = ((ReactHitSlopView)child).getHitSlopRect();
            if (localX >= (float)(-hitSlopRect.left) && localX < (float)(child.getRight() - child.getLeft() + hitSlopRect.right) && localY >= (float)(-hitSlopRect.top) && localY < (float)(child.getBottom() - child.getTop() + hitSlopRect.bottom)) {
                outLocalPoint.set(localX, localY);
                return true;
            }
            return false;
        }
        if (localX >= 0.0f && localX < (float)(child.getRight() - child.getLeft()) && localY >= 0.0f && localY < (float)(child.getBottom() - child.getTop())) {
            outLocalPoint.set(localX, localY);
            return true;
        }
        return false;
    }

    @Nullable
    private static View findTouchTargetViewWithPointerEvents(float[] eventCoords, View view) {
        PointerEvents pointerEvents;
        PointerEvents pointerEvents2 = pointerEvents = view instanceof ReactPointerEventsView ? ((ReactPointerEventsView)view).getPointerEvents() : PointerEvents.AUTO;
        if (pointerEvents == PointerEvents.NONE) {
            return null;
        }
        if (pointerEvents == PointerEvents.BOX_ONLY) {
            return view;
        }
        if (pointerEvents == PointerEvents.BOX_NONE) {
            if (view instanceof ViewGroup) {
                int reactTag;
                View targetView = TouchTargetHelper.findTouchTargetView(eventCoords, (ViewGroup)view);
                if (targetView != view) {
                    return targetView;
                }
                if (view instanceof ReactCompoundView && (reactTag = ((ReactCompoundView)view).reactTagForTouch(eventCoords[0], eventCoords[1])) != view.getId()) {
                    return view;
                }
            }
            return null;
        }
        if (pointerEvents == PointerEvents.AUTO) {
            if (view instanceof ReactCompoundViewGroup && ((ReactCompoundViewGroup)view).interceptsTouchEvent(eventCoords[0], eventCoords[1])) {
                return view;
            }
            if (view instanceof ViewGroup) {
                return TouchTargetHelper.findTouchTargetView(eventCoords, (ViewGroup)view);
            }
            return view;
        }
        throw new JSApplicationIllegalArgumentException("Unknown pointer event type: " + pointerEvents.toString());
    }

    private static int getTouchTargetForView(View targetView, float eventX, float eventY) {
        if (targetView instanceof ReactCompoundView) {
            return ((ReactCompoundView)targetView).reactTagForTouch(eventX, eventY);
        }
        return targetView.getId();
    }
}

