/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager;

import com.facebook.csslayout.CSSLayoutContext;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.animation.Animation;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.Callback;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.WritableArray;
import com.facebook.react.uimanager.IllegalViewOperationException;
import com.facebook.react.uimanager.NativeViewHierarchyManager;
import com.facebook.react.uimanager.NativeViewHierarchyOptimizer;
import com.facebook.react.uimanager.OnLayoutEvent;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.ReactShadowNode;
import com.facebook.react.uimanager.ReactStylesDiffMap;
import com.facebook.react.uimanager.ShadowNodeRegistry;
import com.facebook.react.uimanager.SizeMonitoringFrameLayout;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.UIViewOperationQueue;
import com.facebook.react.uimanager.ViewAtIndex;
import com.facebook.react.uimanager.ViewGroupManager;
import com.facebook.react.uimanager.ViewManager;
import com.facebook.react.uimanager.ViewManagerRegistry;
import com.facebook.react.uimanager.debug.NotThreadSafeViewHierarchyUpdateDebugListener;
import com.facebook.react.uimanager.events.EventDispatcher;
import com.facebook.systrace.Systrace;
import com.facebook.systrace.SystraceMessage;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;

public class UIImplementation {
    private final ShadowNodeRegistry mShadowNodeRegistry = new ShadowNodeRegistry();
    private final ViewManagerRegistry mViewManagers;
    private final CSSLayoutContext mLayoutContext = new CSSLayoutContext();
    private final UIViewOperationQueue mOperationsQueue;
    private final NativeViewHierarchyOptimizer mNativeViewHierarchyOptimizer;
    private final int[] mMeasureBuffer = new int[4];

    public UIImplementation(ReactApplicationContext reactContext, List<ViewManager> viewManagers) {
        this(reactContext, new ViewManagerRegistry(viewManagers));
    }

    private UIImplementation(ReactApplicationContext reactContext, ViewManagerRegistry viewManagers) {
        this(viewManagers, new UIViewOperationQueue(reactContext, new NativeViewHierarchyManager(viewManagers)));
    }

    protected UIImplementation(ViewManagerRegistry viewManagers, UIViewOperationQueue operationsQueue) {
        this.mViewManagers = viewManagers;
        this.mOperationsQueue = operationsQueue;
        this.mNativeViewHierarchyOptimizer = new NativeViewHierarchyOptimizer(this.mOperationsQueue, this.mShadowNodeRegistry);
    }

    protected ReactShadowNode createRootShadowNode() {
        ReactShadowNode rootCSSNode = new ReactShadowNode();
        rootCSSNode.setViewClassName("Root");
        return rootCSSNode;
    }

    protected ReactShadowNode createShadowNode(String className) {
        ViewManager viewManager = this.mViewManagers.get(className);
        return viewManager.createShadowNodeInstance();
    }

    protected final ReactShadowNode resolveShadowNode(int reactTag) {
        return this.mShadowNodeRegistry.getNode(reactTag);
    }

    protected final ViewManager resolveViewManager(String className) {
        return this.mViewManagers.get(className);
    }

    public void registerRootView(SizeMonitoringFrameLayout rootView, int tag, int width, int height, ThemedReactContext context) {
        ReactShadowNode rootCSSNode = this.createRootShadowNode();
        rootCSSNode.setReactTag(tag);
        rootCSSNode.setThemedContext(context);
        rootCSSNode.setStyleWidth(width);
        rootCSSNode.setStyleHeight(height);
        this.mShadowNodeRegistry.addRootNode(rootCSSNode);
        this.mOperationsQueue.addRootView(tag, rootView, context);
    }

    public void removeRootView(int rootViewTag) {
        this.mShadowNodeRegistry.removeRootNode(rootViewTag);
        this.mOperationsQueue.enqueueRemoveRootView(rootViewTag);
    }

    public void updateRootNodeSize(int rootViewTag, int newWidth, int newHeight, EventDispatcher eventDispatcher) {
        ReactShadowNode rootCSSNode = this.mShadowNodeRegistry.getNode(rootViewTag);
        rootCSSNode.setStyleWidth(newWidth);
        rootCSSNode.setStyleHeight(newHeight);
        if (this.mOperationsQueue.isEmpty()) {
            this.dispatchViewUpdates(eventDispatcher, -1);
        }
    }

    public void createView(int tag, String className, int rootViewTag, ReadableMap props) {
        ReactShadowNode cssNode = this.createShadowNode(className);
        ReactShadowNode rootNode = this.mShadowNodeRegistry.getNode(rootViewTag);
        cssNode.setReactTag(tag);
        cssNode.setViewClassName(className);
        cssNode.setRootNode(rootNode);
        cssNode.setThemedContext(rootNode.getThemedContext());
        this.mShadowNodeRegistry.addNode(cssNode);
        ReactStylesDiffMap styles = null;
        if (props != null) {
            styles = new ReactStylesDiffMap(props);
            cssNode.updateProperties(styles);
        }
        this.handleCreateView(cssNode, rootViewTag, styles);
    }

    protected void handleCreateView(ReactShadowNode cssNode, int rootViewTag, @Nullable ReactStylesDiffMap styles) {
        if (!cssNode.isVirtual()) {
            this.mNativeViewHierarchyOptimizer.handleCreateView(cssNode, cssNode.getThemedContext(), styles);
        }
    }

    public void updateView(int tag, String className, ReadableMap props) {
        ViewManager viewManager = this.mViewManagers.get(className);
        if (viewManager == null) {
            throw new IllegalViewOperationException("Got unknown view type: " + className);
        }
        ReactShadowNode cssNode = this.mShadowNodeRegistry.getNode(tag);
        if (cssNode == null) {
            throw new IllegalViewOperationException("Trying to update non-existent view with tag " + tag);
        }
        if (props != null) {
            ReactStylesDiffMap styles = new ReactStylesDiffMap(props);
            cssNode.updateProperties(styles);
            this.handleUpdateView(cssNode, className, styles);
        }
    }

    protected void handleUpdateView(ReactShadowNode cssNode, String className, ReactStylesDiffMap styles) {
        if (!cssNode.isVirtual()) {
            this.mNativeViewHierarchyOptimizer.handleUpdateView(cssNode, className, styles);
        }
    }

    public void manageChildren(int viewTag, @Nullable ReadableArray moveFrom, @Nullable ReadableArray moveTo, @Nullable ReadableArray addChildTags, @Nullable ReadableArray addAtIndices, @Nullable ReadableArray removeFrom) {
        int i;
        int i2;
        int numToRemove;
        ReactShadowNode cssNodeToManage = this.mShadowNodeRegistry.getNode(viewTag);
        int numToMove = moveFrom == null ? 0 : moveFrom.size();
        int numToAdd = addChildTags == null ? 0 : addChildTags.size();
        int n = numToRemove = removeFrom == null ? 0 : removeFrom.size();
        if (numToMove != 0 && (moveTo == null || numToMove != moveTo.size())) {
            throw new IllegalViewOperationException("Size of moveFrom != size of moveTo!");
        }
        if (numToAdd != 0 && (addAtIndices == null || numToAdd != addAtIndices.size())) {
            throw new IllegalViewOperationException("Size of addChildTags != size of addAtIndices!");
        }
        ViewAtIndex[] viewsToAdd = new ViewAtIndex[numToMove + numToAdd];
        int[] indicesToRemove = new int[numToMove + numToRemove];
        int[] tagsToRemove = new int[indicesToRemove.length];
        int[] tagsToDelete = new int[numToRemove];
        if (numToMove > 0) {
            Assertions.assertNotNull((Object)moveFrom);
            Assertions.assertNotNull((Object)moveTo);
            for (i2 = 0; i2 < numToMove; ++i2) {
                int moveFromIndex = moveFrom.getInt(i2);
                int tagToMove = cssNodeToManage.getChildAt(moveFromIndex).getReactTag();
                viewsToAdd[i2] = new ViewAtIndex(tagToMove, moveTo.getInt(i2));
                indicesToRemove[i2] = moveFromIndex;
                tagsToRemove[i2] = tagToMove;
            }
        }
        if (numToAdd > 0) {
            Assertions.assertNotNull((Object)addChildTags);
            Assertions.assertNotNull((Object)addAtIndices);
            for (i2 = 0; i2 < numToAdd; ++i2) {
                int viewTagToAdd = addChildTags.getInt(i2);
                int indexToAddAt = addAtIndices.getInt(i2);
                viewsToAdd[numToMove + i2] = new ViewAtIndex(viewTagToAdd, indexToAddAt);
            }
        }
        if (numToRemove > 0) {
            Assertions.assertNotNull((Object)removeFrom);
            for (i2 = 0; i2 < numToRemove; ++i2) {
                int indexToRemove = removeFrom.getInt(i2);
                int tagToRemove = cssNodeToManage.getChildAt(indexToRemove).getReactTag();
                indicesToRemove[numToMove + i2] = indexToRemove;
                tagsToRemove[numToMove + i2] = tagToRemove;
                tagsToDelete[i2] = tagToRemove;
            }
        }
        Arrays.sort(viewsToAdd, ViewAtIndex.COMPARATOR);
        Arrays.sort(indicesToRemove);
        int lastIndexRemoved = -1;
        for (i = indicesToRemove.length - 1; i >= 0; --i) {
            int indexToRemove = indicesToRemove[i];
            if (indexToRemove == lastIndexRemoved) {
                throw new IllegalViewOperationException("Repeated indices in Removal list for view tag: " + viewTag);
            }
            cssNodeToManage.removeChildAt(indicesToRemove[i]);
            lastIndexRemoved = indicesToRemove[i];
        }
        for (i = 0; i < viewsToAdd.length; ++i) {
            ViewAtIndex viewAtIndex = viewsToAdd[i];
            ReactShadowNode cssNodeToAdd = this.mShadowNodeRegistry.getNode(viewAtIndex.mTag);
            if (cssNodeToAdd == null) {
                throw new IllegalViewOperationException("Trying to add unknown view tag: " + viewAtIndex.mTag);
            }
            cssNodeToManage.addChildAt(cssNodeToAdd, viewAtIndex.mIndex);
        }
        if (!cssNodeToManage.isVirtual() && !cssNodeToManage.isVirtualAnchor()) {
            this.mNativeViewHierarchyOptimizer.handleManageChildren(cssNodeToManage, indicesToRemove, tagsToRemove, viewsToAdd, tagsToDelete);
        }
        for (i = 0; i < tagsToDelete.length; ++i) {
            this.removeShadowNode(this.mShadowNodeRegistry.getNode(tagsToDelete[i]));
        }
    }

    public void replaceExistingNonRootView(int oldTag, int newTag) {
        if (this.mShadowNodeRegistry.isRootNode(oldTag) || this.mShadowNodeRegistry.isRootNode(newTag)) {
            throw new IllegalViewOperationException("Trying to add or replace a root tag!");
        }
        ReactShadowNode oldNode = this.mShadowNodeRegistry.getNode(oldTag);
        if (oldNode == null) {
            throw new IllegalViewOperationException("Trying to replace unknown view tag: " + oldTag);
        }
        ReactShadowNode parent = oldNode.getParent();
        if (parent == null) {
            throw new IllegalViewOperationException("Node is not attached to a parent: " + oldTag);
        }
        int oldIndex = parent.indexOf(oldNode);
        if (oldIndex < 0) {
            throw new IllegalStateException("Didn't find child tag in parent");
        }
        WritableArray tagsToAdd = Arguments.createArray();
        tagsToAdd.pushInt(newTag);
        WritableArray addAtIndices = Arguments.createArray();
        addAtIndices.pushInt(oldIndex);
        WritableArray indicesToRemove = Arguments.createArray();
        indicesToRemove.pushInt(oldIndex);
        this.manageChildren(parent.getReactTag(), null, null, tagsToAdd, addAtIndices, indicesToRemove);
    }

    public void removeSubviewsFromContainerWithID(int containerTag) {
        ReactShadowNode containerNode = this.mShadowNodeRegistry.getNode(containerTag);
        if (containerNode == null) {
            throw new IllegalViewOperationException("Trying to remove subviews of an unknown view tag: " + containerTag);
        }
        WritableArray indicesToRemove = Arguments.createArray();
        for (int childIndex = 0; childIndex < containerNode.getChildCount(); ++childIndex) {
            indicesToRemove.pushInt(childIndex);
        }
        this.manageChildren(containerTag, null, null, null, null, indicesToRemove);
    }

    public void findSubviewIn(int reactTag, float targetX, float targetY, Callback callback) {
        this.mOperationsQueue.enqueueFindTargetForTouch(reactTag, targetX, targetY, callback);
    }

    public void measure(int reactTag, Callback callback) {
        this.mOperationsQueue.enqueueMeasure(reactTag, callback);
    }

    public void measureInWindow(int reactTag, Callback callback) {
        this.mOperationsQueue.enqueueMeasureInWindow(reactTag, callback);
    }

    public void measureLayout(int tag, int ancestorTag, Callback errorCallback, Callback successCallback) {
        try {
            this.measureLayout(tag, ancestorTag, this.mMeasureBuffer);
            float relativeX = PixelUtil.toDIPFromPixel(this.mMeasureBuffer[0]);
            float relativeY = PixelUtil.toDIPFromPixel(this.mMeasureBuffer[1]);
            float width = PixelUtil.toDIPFromPixel(this.mMeasureBuffer[2]);
            float height = PixelUtil.toDIPFromPixel(this.mMeasureBuffer[3]);
            successCallback.invoke(Float.valueOf(relativeX), Float.valueOf(relativeY), Float.valueOf(width), Float.valueOf(height));
        }
        catch (IllegalViewOperationException e) {
            errorCallback.invoke(e.getMessage());
        }
    }

    public void measureLayoutRelativeToParent(int tag, Callback errorCallback, Callback successCallback) {
        try {
            this.measureLayoutRelativeToParent(tag, this.mMeasureBuffer);
            float relativeX = PixelUtil.toDIPFromPixel(this.mMeasureBuffer[0]);
            float relativeY = PixelUtil.toDIPFromPixel(this.mMeasureBuffer[1]);
            float width = PixelUtil.toDIPFromPixel(this.mMeasureBuffer[2]);
            float height = PixelUtil.toDIPFromPixel(this.mMeasureBuffer[3]);
            successCallback.invoke(Float.valueOf(relativeX), Float.valueOf(relativeY), Float.valueOf(width), Float.valueOf(height));
        }
        catch (IllegalViewOperationException e) {
            errorCallback.invoke(e.getMessage());
        }
    }

    public void dispatchViewUpdates(EventDispatcher eventDispatcher, int batchId) {
        this.updateViewHierarchy(eventDispatcher);
        this.mNativeViewHierarchyOptimizer.onBatchComplete();
        this.mOperationsQueue.dispatchViewUpdates(batchId);
    }

    protected void updateViewHierarchy(EventDispatcher eventDispatcher) {
        for (int i = 0; i < this.mShadowNodeRegistry.getRootNodeCount(); ++i) {
            int tag = this.mShadowNodeRegistry.getRootTag(i);
            ReactShadowNode cssRoot = this.mShadowNodeRegistry.getNode(tag);
            this.notifyOnBeforeLayoutRecursive(cssRoot);
            this.calculateRootLayout(cssRoot);
            this.applyUpdatesRecursive(cssRoot, 0.0f, 0.0f, eventDispatcher);
        }
    }

    public void registerAnimation(Animation animation) {
        this.mOperationsQueue.enqueueRegisterAnimation(animation);
    }

    public void addAnimation(int reactTag, int animationID, Callback onSuccess) {
        this.assertViewExists(reactTag, "addAnimation");
        this.mOperationsQueue.enqueueAddAnimation(reactTag, animationID, onSuccess);
    }

    public void removeAnimation(int reactTag, int animationID) {
        this.assertViewExists(reactTag, "removeAnimation");
        this.mOperationsQueue.enqueueRemoveAnimation(animationID);
    }

    public void setLayoutAnimationEnabledExperimental(boolean enabled) {
        this.mOperationsQueue.enqueueSetLayoutAnimationEnabled(enabled);
    }

    public void configureNextLayoutAnimation(ReadableMap config, Callback success, Callback error) {
        this.mOperationsQueue.enqueueConfigureLayoutAnimation(config, success, error);
    }

    public void setJSResponder(int reactTag, boolean blockNativeResponder) {
        this.assertViewExists(reactTag, "setJSResponder");
        ReactShadowNode node = this.mShadowNodeRegistry.getNode(reactTag);
        while (node.isVirtual() || node.isLayoutOnly()) {
            node = node.getParent();
        }
        this.mOperationsQueue.enqueueSetJSResponder(node.getReactTag(), reactTag, blockNativeResponder);
    }

    public void clearJSResponder() {
        this.mOperationsQueue.enqueueClearJSResponder();
    }

    public void dispatchViewManagerCommand(int reactTag, int commandId, ReadableArray commandArgs) {
        this.assertViewExists(reactTag, "dispatchViewManagerCommand");
        this.mOperationsQueue.enqueueDispatchCommand(reactTag, commandId, commandArgs);
    }

    public void showPopupMenu(int reactTag, ReadableArray items, Callback error, Callback success) {
        this.assertViewExists(reactTag, "showPopupMenu");
        this.mOperationsQueue.enqueueShowPopupMenu(reactTag, items, error, success);
    }

    public void sendAccessibilityEvent(int tag, int eventType) {
        this.mOperationsQueue.enqueueSendAccessibilityEvent(tag, eventType);
    }

    public void onHostResume() {
        this.mOperationsQueue.resumeFrameCallback();
    }

    public void onHostPause() {
        this.mOperationsQueue.pauseFrameCallback();
    }

    public void onHostDestroy() {
    }

    public void setViewHierarchyUpdateDebugListener(@Nullable NotThreadSafeViewHierarchyUpdateDebugListener listener) {
        this.mOperationsQueue.setViewHierarchyUpdateDebugListener(listener);
    }

    protected final void removeShadowNode(ReactShadowNode nodeToRemove) {
        NativeViewHierarchyOptimizer.handleRemoveNode(nodeToRemove);
        this.mShadowNodeRegistry.removeNode(nodeToRemove.getReactTag());
        for (int i = nodeToRemove.getChildCount() - 1; i >= 0; --i) {
            this.removeShadowNode(nodeToRemove.getChildAt(i));
        }
        nodeToRemove.removeAllChildren();
    }

    private void measureLayout(int tag, int ancestorTag, int[] outputBuffer) {
        ReactShadowNode node = this.mShadowNodeRegistry.getNode(tag);
        ReactShadowNode ancestor = this.mShadowNodeRegistry.getNode(ancestorTag);
        if (node == null || ancestor == null) {
            throw new IllegalViewOperationException("Tag " + (node == null ? tag : ancestorTag) + " does not exist");
        }
        if (node != ancestor) {
            for (ReactShadowNode currentParent = node.getParent(); currentParent != ancestor; currentParent = currentParent.getParent()) {
                if (currentParent != null) continue;
                throw new IllegalViewOperationException("Tag " + ancestorTag + " is not an ancestor of tag " + tag);
            }
        }
        this.measureLayoutRelativeToVerifiedAncestor(node, ancestor, outputBuffer);
    }

    private void measureLayoutRelativeToParent(int tag, int[] outputBuffer) {
        ReactShadowNode node = this.mShadowNodeRegistry.getNode(tag);
        if (node == null) {
            throw new IllegalViewOperationException("No native view for tag " + tag + " exists!");
        }
        ReactShadowNode parent = node.getParent();
        if (parent == null) {
            throw new IllegalViewOperationException("View with tag " + tag + " doesn't have a parent!");
        }
        this.measureLayoutRelativeToVerifiedAncestor(node, parent, outputBuffer);
    }

    private void measureLayoutRelativeToVerifiedAncestor(ReactShadowNode node, ReactShadowNode ancestor, int[] outputBuffer) {
        int offsetX = 0;
        int offsetY = 0;
        if (node != ancestor) {
            offsetX = Math.round(node.getLayoutX());
            offsetY = Math.round(node.getLayoutY());
            for (ReactShadowNode current = node.getParent(); current != ancestor; current = current.getParent()) {
                Assertions.assertNotNull((Object)current);
                this.assertNodeDoesNotNeedCustomLayoutForChildren(current);
                offsetX += Math.round(current.getLayoutX());
                offsetY += Math.round(current.getLayoutY());
            }
            this.assertNodeDoesNotNeedCustomLayoutForChildren(ancestor);
        }
        outputBuffer[0] = offsetX;
        outputBuffer[1] = offsetY;
        outputBuffer[2] = node.getScreenWidth();
        outputBuffer[3] = node.getScreenHeight();
    }

    private void assertViewExists(int reactTag, String operationNameForExceptionMessage) {
        if (this.mShadowNodeRegistry.getNode(reactTag) == null) {
            throw new IllegalViewOperationException("Unable to execute operation " + operationNameForExceptionMessage + " on view with " + "tag: " + reactTag + ", since the view does not exists");
        }
    }

    private void assertNodeDoesNotNeedCustomLayoutForChildren(ReactShadowNode node) {
        ViewManager viewManager = (ViewManager)Assertions.assertNotNull((Object)this.mViewManagers.get(node.getViewClass()));
        if (!(viewManager instanceof ViewGroupManager)) {
            throw new IllegalViewOperationException("Trying to use view " + node.getViewClass() + " as a parent, but its Manager doesn't extends ViewGroupManager");
        }
        ViewGroupManager viewGroupManager = (ViewGroupManager)viewManager;
        if (viewGroupManager != null && viewGroupManager.needsCustomLayoutForChildren()) {
            throw new IllegalViewOperationException("Trying to measure a view using measureLayout/measureLayoutRelativeToParent relative to an ancestor that requires custom layout for it's children (" + node.getViewClass() + "). Use measure instead.");
        }
    }

    private void notifyOnBeforeLayoutRecursive(ReactShadowNode cssNode) {
        if (!cssNode.hasUpdates()) {
            return;
        }
        for (int i = 0; i < cssNode.getChildCount(); ++i) {
            this.notifyOnBeforeLayoutRecursive(cssNode.getChildAt(i));
        }
        cssNode.onBeforeLayout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void calculateRootLayout(ReactShadowNode cssRoot) {
        SystraceMessage.beginSection(0L, "cssRoot.calculateLayout").arg("rootTag", cssRoot.getReactTag()).flush();
        try {
            cssRoot.calculateLayout(this.mLayoutContext);
        }
        finally {
            Systrace.endSection(0L);
        }
    }

    protected void applyUpdatesRecursive(ReactShadowNode cssNode, float absoluteX, float absoluteY, EventDispatcher eventDispatcher) {
        int tag;
        if (!cssNode.hasUpdates()) {
            return;
        }
        if (!cssNode.isVirtualAnchor()) {
            for (int i = 0; i < cssNode.getChildCount(); ++i) {
                this.applyUpdatesRecursive(cssNode.getChildAt(i), absoluteX + cssNode.getLayoutX(), absoluteY + cssNode.getLayoutY(), eventDispatcher);
            }
        }
        if (!this.mShadowNodeRegistry.isRootNode(tag = cssNode.getReactTag())) {
            cssNode.dispatchUpdates(absoluteX, absoluteY, this.mOperationsQueue, this.mNativeViewHierarchyOptimizer);
            if (cssNode.shouldNotifyOnLayout()) {
                eventDispatcher.dispatchEvent(OnLayoutEvent.obtain(tag, cssNode.getScreenX(), cssNode.getScreenY(), cssNode.getScreenWidth(), cssNode.getScreenHeight()));
            }
        }
        cssNode.markUpdateSeen();
    }
}

