/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.art;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import com.facebook.common.logging.FLog;
import com.facebook.react.bridge.JSApplicationIllegalArgumentException;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.uimanager.annotations.ReactProp;
import com.facebook.react.views.art.ARTVirtualNode;
import com.facebook.react.views.art.PropHelper;
import javax.annotation.Nullable;

public class ARTShapeShadowNode
extends ARTVirtualNode {
    private static final int CAP_BUTT = 0;
    private static final int CAP_ROUND = 1;
    private static final int CAP_SQUARE = 2;
    private static final int JOIN_BEVEL = 2;
    private static final int JOIN_MITER = 0;
    private static final int JOIN_ROUND = 1;
    private static final int PATH_TYPE_ARC = 4;
    private static final int PATH_TYPE_CLOSE = 1;
    private static final int PATH_TYPE_CURVETO = 3;
    private static final int PATH_TYPE_LINETO = 2;
    private static final int PATH_TYPE_MOVETO = 0;
    @Nullable
    protected Path mPath;
    @Nullable
    private float[] mStrokeColor;
    @Nullable
    private float[] mFillColor;
    @Nullable
    private float[] mStrokeDash;
    private float mStrokeWidth = 1.0f;
    private int mStrokeCap = 1;
    private int mStrokeJoin = 1;

    @ReactProp(name="d")
    public void setShapePath(@Nullable ReadableArray shapePath) {
        float[] pathData = PropHelper.toFloatArray(shapePath);
        this.mPath = this.createPath(pathData);
        this.markUpdated();
    }

    @ReactProp(name="stroke")
    public void setStroke(@Nullable ReadableArray strokeColors) {
        this.mStrokeColor = PropHelper.toFloatArray(strokeColors);
        this.markUpdated();
    }

    @ReactProp(name="strokeDash")
    public void setStrokeDash(@Nullable ReadableArray strokeDash) {
        this.mStrokeDash = PropHelper.toFloatArray(strokeDash);
        this.markUpdated();
    }

    @ReactProp(name="fill")
    public void setFill(@Nullable ReadableArray fillColors) {
        this.mFillColor = PropHelper.toFloatArray(fillColors);
        this.markUpdated();
    }

    @ReactProp(name="strokeWidth", defaultFloat=1.0f)
    public void setStrokeWidth(float strokeWidth) {
        this.mStrokeWidth = strokeWidth;
        this.markUpdated();
    }

    @ReactProp(name="strokeCap", defaultInt=1)
    public void setStrokeCap(int strokeCap) {
        this.mStrokeCap = strokeCap;
        this.markUpdated();
    }

    @ReactProp(name="strokeJoin", defaultInt=1)
    public void setStrokeJoin(int strokeJoin) {
        this.mStrokeJoin = strokeJoin;
        this.markUpdated();
    }

    @Override
    public void draw(Canvas canvas, Paint paint, float opacity) {
        if ((opacity *= this.mOpacity) > 0.01f) {
            this.saveAndSetupCanvas(canvas);
            if (this.mPath == null) {
                throw new JSApplicationIllegalArgumentException("Shapes should have a valid path (d) prop");
            }
            if (this.setupStrokePaint(paint, opacity)) {
                canvas.drawPath(this.mPath, paint);
            }
            if (this.setupFillPaint(paint, opacity)) {
                canvas.drawPath(this.mPath, paint);
            }
            this.restoreCanvas(canvas);
        }
        this.markUpdateSeen();
    }

    protected boolean setupStrokePaint(Paint paint, float opacity) {
        if (this.mStrokeWidth == 0.0f || this.mStrokeColor == null || this.mStrokeColor.length == 0) {
            return false;
        }
        paint.reset();
        paint.setFlags(1);
        paint.setStyle(Paint.Style.STROKE);
        switch (this.mStrokeCap) {
            case 0: {
                paint.setStrokeCap(Paint.Cap.BUTT);
                break;
            }
            case 2: {
                paint.setStrokeCap(Paint.Cap.SQUARE);
                break;
            }
            case 1: {
                paint.setStrokeCap(Paint.Cap.ROUND);
                break;
            }
            default: {
                throw new JSApplicationIllegalArgumentException("strokeCap " + this.mStrokeCap + " unrecognized");
            }
        }
        switch (this.mStrokeJoin) {
            case 0: {
                paint.setStrokeJoin(Paint.Join.MITER);
                break;
            }
            case 2: {
                paint.setStrokeJoin(Paint.Join.BEVEL);
                break;
            }
            case 1: {
                paint.setStrokeJoin(Paint.Join.ROUND);
                break;
            }
            default: {
                throw new JSApplicationIllegalArgumentException("strokeJoin " + this.mStrokeJoin + " unrecognized");
            }
        }
        paint.setStrokeWidth(this.mStrokeWidth * this.mScale);
        paint.setARGB((int)(this.mStrokeColor.length > 3 ? this.mStrokeColor[3] * opacity * 255.0f : opacity * 255.0f), (int)(this.mStrokeColor[0] * 255.0f), (int)(this.mStrokeColor[1] * 255.0f), (int)(this.mStrokeColor[2] * 255.0f));
        if (this.mStrokeDash != null && this.mStrokeDash.length > 0) {
            FLog.w((String)"React", (String)"ART: Dashes are not supported yet!");
        }
        return true;
    }

    protected boolean setupFillPaint(Paint paint, float opacity) {
        if (this.mFillColor != null && this.mFillColor.length > 0) {
            paint.reset();
            paint.setFlags(1);
            paint.setStyle(Paint.Style.FILL);
            int colorType = (int)this.mFillColor[0];
            switch (colorType) {
                case 0: {
                    paint.setARGB((int)(this.mFillColor.length > 4 ? this.mFillColor[4] * opacity * 255.0f : opacity * 255.0f), (int)(this.mFillColor[1] * 255.0f), (int)(this.mFillColor[2] * 255.0f), (int)(this.mFillColor[3] * 255.0f));
                    break;
                }
                default: {
                    FLog.w((String)"React", (String)("ART: Color type " + colorType + " not supported!"));
                }
            }
            return true;
        }
        return false;
    }

    private Path createPath(float[] data) {
        Path path = new Path();
        path.moveTo(0.0f, 0.0f);
        int i = 0;
        block7: while (i < data.length) {
            int type = (int)data[i++];
            switch (type) {
                case 0: {
                    path.moveTo(data[i++] * this.mScale, data[i++] * this.mScale);
                    continue block7;
                }
                case 1: {
                    path.close();
                    continue block7;
                }
                case 2: {
                    path.lineTo(data[i++] * this.mScale, data[i++] * this.mScale);
                    continue block7;
                }
                case 3: {
                    path.cubicTo(data[i++] * this.mScale, data[i++] * this.mScale, data[i++] * this.mScale, data[i++] * this.mScale, data[i++] * this.mScale, data[i++] * this.mScale);
                    continue block7;
                }
                case 4: {
                    boolean clockwise;
                    float x = data[i++] * this.mScale;
                    float y = data[i++] * this.mScale;
                    float r = data[i++] * this.mScale;
                    float start = (float)Math.toDegrees(data[i++]);
                    float end = (float)Math.toDegrees(data[i++]);
                    boolean bl = clockwise = data[i++] == 0.0f;
                    if (!clockwise) {
                        end = 360.0f - end;
                    }
                    float sweep = start - end;
                    RectF oval = new RectF(x - r, y - r, x + r, y + r);
                    path.addArc(oval, start, sweep);
                    continue block7;
                }
            }
            throw new JSApplicationIllegalArgumentException("Unrecognized drawing instruction " + type);
        }
        return path;
    }
}

