/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.drawer;

import android.os.Build;
import android.support.v4.widget.DrawerLayout;
import android.view.View;
import com.facebook.common.logging.FLog;
import com.facebook.react.bridge.JSApplicationIllegalArgumentException;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.common.MapBuilder;
import com.facebook.react.common.SystemClock;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.UIManagerModule;
import com.facebook.react.uimanager.ViewGroupManager;
import com.facebook.react.uimanager.annotations.ReactProp;
import com.facebook.react.uimanager.events.EventDispatcher;
import com.facebook.react.views.drawer.ReactDrawerLayout;
import com.facebook.react.views.drawer.events.DrawerClosedEvent;
import com.facebook.react.views.drawer.events.DrawerOpenedEvent;
import com.facebook.react.views.drawer.events.DrawerSlideEvent;
import com.facebook.react.views.drawer.events.DrawerStateChangedEvent;
import java.lang.reflect.Method;
import java.util.Map;
import javax.annotation.Nullable;

public class ReactDrawerLayoutManager
extends ViewGroupManager<ReactDrawerLayout> {
    private static final String REACT_CLASS = "AndroidDrawerLayout";
    public static final int OPEN_DRAWER = 1;
    public static final int CLOSE_DRAWER = 2;

    @Override
    public String getName() {
        return REACT_CLASS;
    }

    @Override
    protected void addEventEmitters(ThemedReactContext reactContext, ReactDrawerLayout view) {
        view.setDrawerListener(new DrawerEventEmitter(view, reactContext.getNativeModule(UIManagerModule.class).getEventDispatcher()));
    }

    @Override
    protected ReactDrawerLayout createViewInstance(ThemedReactContext context) {
        return new ReactDrawerLayout(context);
    }

    @ReactProp(name="drawerPosition", defaultInt=0x800003)
    public void setDrawerPosition(ReactDrawerLayout view, int drawerPosition) {
        if (0x800003 != drawerPosition && 0x800005 != drawerPosition) {
            throw new JSApplicationIllegalArgumentException("Unknown drawerPosition " + drawerPosition);
        }
        view.setDrawerPosition(drawerPosition);
    }

    @ReactProp(name="drawerWidth", defaultFloat=NaNf)
    public void getDrawerWidth(ReactDrawerLayout view, float width) {
        int widthInPx = Float.isNaN(width) ? -1 : Math.round(PixelUtil.toPixelFromDIP(width));
        view.setDrawerWidth(widthInPx);
    }

    @ReactProp(name="drawerLockMode")
    public void setDrawerLockMode(ReactDrawerLayout view, @Nullable String drawerLockMode) {
        if (drawerLockMode == null || "unlocked".equals(drawerLockMode)) {
            view.setDrawerLockMode(0);
        } else if ("locked-closed".equals(drawerLockMode)) {
            view.setDrawerLockMode(1);
        } else if ("locked-open".equals(drawerLockMode)) {
            view.setDrawerLockMode(2);
        } else {
            throw new JSApplicationIllegalArgumentException("Unknown drawerLockMode " + drawerLockMode);
        }
    }

    @Override
    public void setElevation(ReactDrawerLayout view, float elevation) {
        if (Build.VERSION.SDK_INT >= 21) {
            try {
                Method method = ReactDrawerLayout.class.getMethod("setDrawerElevation", Float.TYPE);
                method.invoke((Object)view, Float.valueOf(PixelUtil.toPixelFromDIP(elevation)));
            }
            catch (Exception ex) {
                FLog.w((String)"React", (String)"setDrawerElevation is not available in this version of the support lib.", (Throwable)ex);
            }
        }
    }

    @Override
    public boolean needsCustomLayoutForChildren() {
        return true;
    }

    @Override
    @Nullable
    public Map<String, Integer> getCommandsMap() {
        return MapBuilder.of("openDrawer", 1, "closeDrawer", 2);
    }

    @Override
    public void receiveCommand(ReactDrawerLayout root, int commandId, @Nullable ReadableArray args) {
        switch (commandId) {
            case 1: {
                root.openDrawer();
                break;
            }
            case 2: {
                root.closeDrawer();
            }
        }
    }

    @Override
    @Nullable
    public Map getExportedViewConstants() {
        return MapBuilder.of("DrawerPosition", MapBuilder.of("Left", 0x800003, "Right", 0x800005));
    }

    @Override
    @Nullable
    public Map getExportedCustomDirectEventTypeConstants() {
        return MapBuilder.of("topDrawerSlide", MapBuilder.of("registrationName", "onDrawerSlide"), "topDrawerOpened", MapBuilder.of("registrationName", "onDrawerOpen"), "topDrawerClosed", MapBuilder.of("registrationName", "onDrawerClose"), "topDrawerStateChanged", MapBuilder.of("registrationName", "onDrawerStateChanged"));
    }

    @Override
    public void addView(ReactDrawerLayout parent, View child, int index) {
        if (this.getChildCount(parent) >= 2) {
            throw new JSApplicationIllegalArgumentException("The Drawer cannot have more than two children");
        }
        if (index != 0 && index != 1) {
            throw new JSApplicationIllegalArgumentException("The only valid indices for drawer's child are 0 or 1. Got " + index + " instead.");
        }
        parent.addView(child, index);
        parent.setDrawerProperties();
    }

    public static class DrawerEventEmitter
    implements DrawerLayout.DrawerListener {
        private final DrawerLayout mDrawerLayout;
        private final EventDispatcher mEventDispatcher;

        public DrawerEventEmitter(DrawerLayout drawerLayout, EventDispatcher eventDispatcher) {
            this.mDrawerLayout = drawerLayout;
            this.mEventDispatcher = eventDispatcher;
        }

        public void onDrawerSlide(View view, float v) {
            this.mEventDispatcher.dispatchEvent(new DrawerSlideEvent(this.mDrawerLayout.getId(), SystemClock.nanoTime(), v));
        }

        public void onDrawerOpened(View view) {
            this.mEventDispatcher.dispatchEvent(new DrawerOpenedEvent(this.mDrawerLayout.getId(), SystemClock.nanoTime()));
        }

        public void onDrawerClosed(View view) {
            this.mEventDispatcher.dispatchEvent(new DrawerClosedEvent(this.mDrawerLayout.getId(), SystemClock.nanoTime()));
        }

        public void onDrawerStateChanged(int i) {
            this.mEventDispatcher.dispatchEvent(new DrawerStateChangedEvent(this.mDrawerLayout.getId(), SystemClock.nanoTime(), i));
        }
    }
}

