/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.modal;

import android.content.Context;
import android.content.DialogInterface;
import com.facebook.react.common.MapBuilder;
import com.facebook.react.common.SystemClock;
import com.facebook.react.uimanager.LayoutShadowNode;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.UIManagerModule;
import com.facebook.react.uimanager.ViewGroupManager;
import com.facebook.react.uimanager.annotations.ReactProp;
import com.facebook.react.uimanager.events.EventDispatcher;
import com.facebook.react.views.modal.ModalHostShadowNode;
import com.facebook.react.views.modal.ReactModalHostView;
import com.facebook.react.views.modal.RequestCloseEvent;
import com.facebook.react.views.modal.ShowEvent;
import java.util.Map;

public class ReactModalHostManager
extends ViewGroupManager<ReactModalHostView> {
    private static final String REACT_CLASS = "RCTModalHostView";

    @Override
    public String getName() {
        return REACT_CLASS;
    }

    @Override
    protected ReactModalHostView createViewInstance(ThemedReactContext reactContext) {
        return new ReactModalHostView((Context)reactContext);
    }

    @Override
    public LayoutShadowNode createShadowNodeInstance() {
        return new ModalHostShadowNode();
    }

    @Override
    public Class<? extends LayoutShadowNode> getShadowNodeClass() {
        return ModalHostShadowNode.class;
    }

    @Override
    public void onDropViewInstance(ReactModalHostView view) {
        super.onDropViewInstance(view);
        view.dismiss();
    }

    @ReactProp(name="animated")
    public void setAnimated(ReactModalHostView view, boolean animated) {
        view.setAnimated(animated);
    }

    @ReactProp(name="transparent")
    public void setTransparent(ReactModalHostView view, boolean transparent) {
        view.setTransparent(transparent);
    }

    @Override
    protected void addEventEmitters(ThemedReactContext reactContext, final ReactModalHostView view) {
        final EventDispatcher dispatcher = reactContext.getNativeModule(UIManagerModule.class).getEventDispatcher();
        view.setOnRequestCloseListener(new ReactModalHostView.OnRequestCloseListener(){

            @Override
            public void onRequestClose(DialogInterface dialog) {
                dispatcher.dispatchEvent(new RequestCloseEvent(view.getId(), SystemClock.nanoTime()));
            }
        });
        view.setOnShowListener(new DialogInterface.OnShowListener(){

            public void onShow(DialogInterface dialog) {
                dispatcher.dispatchEvent(new ShowEvent(view.getId(), SystemClock.nanoTime()));
            }
        });
    }

    @Override
    public Map<String, Object> getExportedCustomDirectEventTypeConstants() {
        return MapBuilder.builder().put("topRequestClose", MapBuilder.of("registrationName", "onRequestClose")).put("topShow", MapBuilder.of("registrationName", "onShow")).build();
    }

    @Override
    protected void onAfterUpdateTransaction(ReactModalHostView view) {
        super.onAfterUpdateTransaction(view);
        view.showOrUpdate();
    }
}

