/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.text;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.text.Layout;
import android.text.Spanned;
import android.widget.TextView;
import com.facebook.react.uimanager.ReactCompoundView;
import com.facebook.react.views.text.ReactTagSpan;
import com.facebook.react.views.text.ReactTextUpdate;
import com.facebook.react.views.text.TextInlineImageSpan;

public class ReactTextView
extends TextView
implements ReactCompoundView {
    private boolean mContainsImages;
    private int mDefaultGravityHorizontal = this.getGravity() & 0x800007;
    private int mDefaultGravityVertical = this.getGravity() & 0x70;

    public ReactTextView(Context context) {
        super(context);
    }

    public void setText(ReactTextUpdate update) {
        this.mContainsImages = update.containsImages();
        this.setText((CharSequence)update.getText());
    }

    @Override
    public int reactTagForTouch(float touchX, float touchY) {
        int index;
        ReactTagSpan[] spans;
        Spanned text = (Spanned)this.getText();
        int target = this.getId();
        int x = (int)touchX;
        int y = (int)touchY;
        Layout layout2 = this.getLayout();
        if (layout2 == null) {
            return target;
        }
        int line = layout2.getLineForVertical(y);
        int lineStartX = (int)layout2.getLineLeft(line);
        int lineEndX = (int)layout2.getLineRight(line);
        if (x >= lineStartX && x <= lineEndX && (spans = (ReactTagSpan[])text.getSpans(index = layout2.getOffsetForHorizontal(line, (float)x), index, ReactTagSpan.class)) != null) {
            int targetSpanTextLength = text.length();
            for (int i = 0; i < spans.length; ++i) {
                int spanStart = text.getSpanStart((Object)spans[i]);
                int spanEnd = text.getSpanEnd((Object)spans[i]);
                if (spanEnd <= index || spanEnd - spanStart > targetSpanTextLength) continue;
                target = spans[i].getReactTag();
                targetSpanTextLength = spanEnd - spanStart;
            }
        }
        return target;
    }

    protected boolean verifyDrawable(Drawable drawable) {
        if (this.mContainsImages && this.getText() instanceof Spanned) {
            TextInlineImageSpan[] spans;
            Spanned text = (Spanned)this.getText();
            for (TextInlineImageSpan span : spans = (TextInlineImageSpan[])text.getSpans(0, text.length(), TextInlineImageSpan.class)) {
                if (span.getDrawable() != drawable) continue;
                return true;
            }
        }
        return super.verifyDrawable(drawable);
    }

    public void invalidateDrawable(Drawable drawable) {
        if (this.mContainsImages && this.getText() instanceof Spanned) {
            TextInlineImageSpan[] spans;
            Spanned text = (Spanned)this.getText();
            for (TextInlineImageSpan span : spans = (TextInlineImageSpan[])text.getSpans(0, text.length(), TextInlineImageSpan.class)) {
                if (span.getDrawable() != drawable) continue;
                this.invalidate();
            }
        }
        super.invalidateDrawable(drawable);
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mContainsImages && this.getText() instanceof Spanned) {
            TextInlineImageSpan[] spans;
            Spanned text = (Spanned)this.getText();
            for (TextInlineImageSpan span : spans = (TextInlineImageSpan[])text.getSpans(0, text.length(), TextInlineImageSpan.class)) {
                span.onDetachedFromWindow();
            }
        }
    }

    public void onStartTemporaryDetach() {
        super.onStartTemporaryDetach();
        if (this.mContainsImages && this.getText() instanceof Spanned) {
            TextInlineImageSpan[] spans;
            Spanned text = (Spanned)this.getText();
            for (TextInlineImageSpan span : spans = (TextInlineImageSpan[])text.getSpans(0, text.length(), TextInlineImageSpan.class)) {
                span.onStartTemporaryDetach();
            }
        }
    }

    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.mContainsImages && this.getText() instanceof Spanned) {
            TextInlineImageSpan[] spans;
            Spanned text = (Spanned)this.getText();
            for (TextInlineImageSpan span : spans = (TextInlineImageSpan[])text.getSpans(0, text.length(), TextInlineImageSpan.class)) {
                span.onAttachedToWindow();
            }
        }
    }

    public void onFinishTemporaryDetach() {
        super.onFinishTemporaryDetach();
        if (this.mContainsImages && this.getText() instanceof Spanned) {
            TextInlineImageSpan[] spans;
            Spanned text = (Spanned)this.getText();
            for (TextInlineImageSpan span : spans = (TextInlineImageSpan[])text.getSpans(0, text.length(), TextInlineImageSpan.class)) {
                span.onFinishTemporaryDetach();
            }
        }
    }

    void setGravityHorizontal(int gravityHorizontal) {
        if (gravityHorizontal == 0) {
            gravityHorizontal = this.mDefaultGravityHorizontal;
        }
        this.setGravity(this.getGravity() & 0xFFFFFFF8 & 0xFF7FFFF8 | gravityHorizontal);
    }

    void setGravityVertical(int gravityVertical) {
        if (gravityVertical == 0) {
            gravityVertical = this.mDefaultGravityVertical;
        }
        this.setGravity(this.getGravity() & 0xFFFFFF8F | gravityVertical);
    }
}

