/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.textfrescosupport;

import android.content.Context;
import android.content.res.Resources;
import android.net.Uri;
import com.facebook.drawee.controller.AbstractDraweeControllerBuilder;
import com.facebook.react.uimanager.annotations.ReactProp;
import com.facebook.react.views.text.ReactTextInlineImageShadowNode;
import com.facebook.react.views.text.TextInlineImageSpan;
import com.facebook.react.views.textfrescosupport.FrescoBasedReactTextInlineImageSpan;
import java.util.Locale;
import javax.annotation.Nullable;

public class FrescoBasedReactTextInlineImageShadowNode
extends ReactTextInlineImageShadowNode {
    @Nullable
    private Uri mUri;
    private final AbstractDraweeControllerBuilder mDraweeControllerBuilder;
    @Nullable
    private final Object mCallerContext;

    public FrescoBasedReactTextInlineImageShadowNode(AbstractDraweeControllerBuilder draweeControllerBuilder, @Nullable Object callerContext) {
        this.mDraweeControllerBuilder = draweeControllerBuilder;
        this.mCallerContext = callerContext;
    }

    @ReactProp(name="src")
    public void setSource(@Nullable String source) {
        Uri uri = null;
        if (source != null) {
            try {
                uri = Uri.parse((String)source);
                if (uri.getScheme() == null) {
                    uri = null;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (uri == null) {
                uri = FrescoBasedReactTextInlineImageShadowNode.getResourceDrawableUri((Context)this.getThemedContext(), source);
            }
        }
        if (uri != this.mUri) {
            this.markUpdated();
        }
        this.mUri = uri;
    }

    @Nullable
    public Uri getUri() {
        return this.mUri;
    }

    @Nullable
    private static Uri getResourceDrawableUri(Context context, @Nullable String name) {
        if (name == null || name.isEmpty()) {
            return null;
        }
        name = name.toLowerCase(Locale.getDefault()).replace("-", "_");
        int resId = context.getResources().getIdentifier(name, "drawable", context.getPackageName());
        return new Uri.Builder().scheme("res").path(String.valueOf(resId)).build();
    }

    @Override
    public boolean isVirtual() {
        return true;
    }

    @Override
    public TextInlineImageSpan buildInlineImageSpan() {
        Resources resources = this.getThemedContext().getResources();
        int height = (int)Math.ceil(this.getStyleHeight());
        int width = (int)Math.ceil(this.getStyleWidth());
        return new FrescoBasedReactTextInlineImageSpan(resources, height, width, this.getUri(), this.getDraweeControllerBuilder(), this.getCallerContext());
    }

    public AbstractDraweeControllerBuilder getDraweeControllerBuilder() {
        return this.mDraweeControllerBuilder;
    }

    @Nullable
    public Object getCallerContext() {
        return this.mCallerContext;
    }
}

