/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.textfrescosupport;

import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.widget.TextView;
import com.facebook.drawee.controller.AbstractDraweeController;
import com.facebook.drawee.controller.AbstractDraweeControllerBuilder;
import com.facebook.drawee.generic.GenericDraweeHierarchy;
import com.facebook.drawee.generic.GenericDraweeHierarchyBuilder;
import com.facebook.drawee.interfaces.DraweeController;
import com.facebook.drawee.interfaces.DraweeHierarchy;
import com.facebook.drawee.view.DraweeHolder;
import com.facebook.imagepipeline.request.ImageRequest;
import com.facebook.imagepipeline.request.ImageRequestBuilder;
import com.facebook.react.views.text.TextInlineImageSpan;
import javax.annotation.Nullable;

public class FrescoBasedReactTextInlineImageSpan
extends TextInlineImageSpan {
    @Nullable
    private Drawable mDrawable;
    private final AbstractDraweeControllerBuilder mDraweeControllerBuilder;
    private final DraweeHolder<GenericDraweeHierarchy> mDraweeHolder;
    @Nullable
    private final Object mCallerContext;
    private int mHeight;
    private Uri mUri;
    private int mWidth;
    @Nullable
    private TextView mTextView;

    public FrescoBasedReactTextInlineImageSpan(Resources resources, int height, int width, @Nullable Uri uri, AbstractDraweeControllerBuilder draweeControllerBuilder, @Nullable Object callerContext) {
        this.mDraweeHolder = new DraweeHolder((DraweeHierarchy)GenericDraweeHierarchyBuilder.newInstance((Resources)resources).build());
        this.mDraweeControllerBuilder = draweeControllerBuilder;
        this.mCallerContext = callerContext;
        this.mHeight = height;
        this.mWidth = width;
        this.mUri = uri != null ? uri : Uri.EMPTY;
    }

    @Override
    public void onDetachedFromWindow() {
        this.mDraweeHolder.onDetach();
    }

    @Override
    public void onStartTemporaryDetach() {
        this.mDraweeHolder.onDetach();
    }

    @Override
    public void onAttachedToWindow() {
        this.mDraweeHolder.onAttach();
    }

    @Override
    public void onFinishTemporaryDetach() {
        this.mDraweeHolder.onAttach();
    }

    @Override
    @Nullable
    public Drawable getDrawable() {
        return this.mDrawable;
    }

    public int getSize(Paint paint, CharSequence text, int start, int end, Paint.FontMetricsInt fm) {
        if (fm != null) {
            fm.ascent = -this.mHeight;
            fm.descent = 0;
            fm.top = fm.ascent;
            fm.bottom = 0;
        }
        return this.mWidth;
    }

    @Override
    public void setTextView(TextView textView) {
        this.mTextView = textView;
    }

    public void draw(Canvas canvas, CharSequence text, int start, int end, float x, int top, int y, int bottom, Paint paint) {
        if (this.mDrawable == null) {
            ImageRequest imageRequest = ImageRequestBuilder.newBuilderWithSource((Uri)this.mUri).build();
            AbstractDraweeController draweeController = this.mDraweeControllerBuilder.reset().setOldController(this.mDraweeHolder.getController()).setCallerContext(this.mCallerContext).setImageRequest((Object)imageRequest).build();
            this.mDraweeHolder.setController((DraweeController)draweeController);
            this.mDrawable = this.mDraweeHolder.getTopLevelDrawable();
            this.mDrawable.setBounds(0, 0, this.mWidth, this.mHeight);
            this.mDrawable.setCallback((Drawable.Callback)this.mTextView);
        }
        canvas.save();
        int transY = bottom - this.mDrawable.getBounds().bottom;
        canvas.translate(x, (float)(transY -= paint.getFontMetricsInt().descent));
        this.mDrawable.draw(canvas);
        canvas.restore();
    }
}

