/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.animated.impl;

import android.os.SystemClock;

class RollingStat {
    private static final int WINDOWS = 60;
    private final short[] mStat = new short[60];

    void incrementStats(int toAdd) {
        long nowMs = SystemClock.uptimeMillis();
        long nowSeconds = nowMs / 1000L;
        int statsIndex = (int)(nowSeconds % 60L);
        int marker = (int)(nowSeconds / 60L & 0xFFL);
        short bucketData = this.mStat[statsIndex];
        int prevCount = bucketData & 0xFF;
        int prevMarker = bucketData >> 8 & 0xFF;
        int newCount = marker != prevMarker ? toAdd : prevCount + toAdd;
        int newData = marker << 8 | newCount;
        this.mStat[statsIndex] = (short)newData;
    }

    int getSum(int previousSeconds) {
        long nowMs = SystemClock.uptimeMillis();
        long nowSeconds = nowMs / 1000L;
        int statsIndexStart = (int)((nowSeconds - (long)previousSeconds) % 60L);
        int currentMarker = (int)(nowSeconds / 60L & 0xFFL);
        int sum = 0;
        for (int i = 0; i < previousSeconds; ++i) {
            short bucketData = this.mStat[(statsIndexStart + i) % 60];
            int count = bucketData & 0xFF;
            int marker = bucketData >> 8 & 0xFF;
            if (marker != currentMarker) continue;
            sum += count;
        }
        return sum;
    }
}

