/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.bitmaps;

import android.annotation.TargetApi;
import android.graphics.Bitmap;
import com.facebook.common.references.CloseableReference;
import com.facebook.imageformat.ImageFormat;
import com.facebook.imagepipeline.bitmaps.EmptyJpegGenerator;
import com.facebook.imagepipeline.bitmaps.PlatformBitmapFactory;
import com.facebook.imagepipeline.image.EncodedImage;
import com.facebook.imagepipeline.memory.PooledByteBuffer;
import com.facebook.imagepipeline.platform.PlatformDecoder;
import javax.annotation.concurrent.ThreadSafe;

@TargetApi(value=11)
@ThreadSafe
public class HoneycombBitmapFactory
extends PlatformBitmapFactory {
    private final EmptyJpegGenerator mJpegGenerator;
    private final PlatformDecoder mPurgeableDecoder;

    public HoneycombBitmapFactory(EmptyJpegGenerator jpegGenerator, PlatformDecoder purgeableDecoder) {
        this.mJpegGenerator = jpegGenerator;
        this.mPurgeableDecoder = purgeableDecoder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CloseableReference<Bitmap> createBitmap(int width, int height, Bitmap.Config bitmapConfig) {
        try (CloseableReference<PooledByteBuffer> jpgRef = this.mJpegGenerator.generate((short)width, (short)height);){
            CloseableReference<Bitmap> closeableReference;
            EncodedImage encodedImage = new EncodedImage(jpgRef);
            encodedImage.setImageFormat(ImageFormat.JPEG);
            try {
                CloseableReference<Bitmap> bitmapRef = this.mPurgeableDecoder.decodeJPEGFromEncodedImage(encodedImage, bitmapConfig, ((PooledByteBuffer)jpgRef.get()).size());
                ((Bitmap)bitmapRef.get()).eraseColor(0);
                closeableReference = bitmapRef;
            }
            catch (Throwable throwable) {
                EncodedImage.closeSafely(encodedImage);
                throw throwable;
            }
            EncodedImage.closeSafely(encodedImage);
            return closeableReference;
        }
    }
}

