/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.image;

import com.facebook.imagepipeline.animated.base.AnimatedImage;
import com.facebook.imagepipeline.animated.base.AnimatedImageResult;
import com.facebook.imagepipeline.image.CloseableImage;

public class CloseableAnimatedImage
extends CloseableImage {
    private AnimatedImageResult mImageResult;

    public CloseableAnimatedImage(AnimatedImageResult imageResult) {
        this.mImageResult = imageResult;
    }

    @Override
    public synchronized int getWidth() {
        return this.isClosed() ? 0 : this.mImageResult.getImage().getWidth();
    }

    @Override
    public synchronized int getHeight() {
        return this.isClosed() ? 0 : this.mImageResult.getImage().getHeight();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        AnimatedImageResult imageResult;
        CloseableAnimatedImage closeableAnimatedImage = this;
        synchronized (closeableAnimatedImage) {
            if (this.mImageResult == null) {
                return;
            }
            imageResult = this.mImageResult;
            this.mImageResult = null;
        }
        imageResult.dispose();
    }

    @Override
    public synchronized boolean isClosed() {
        return this.mImageResult == null;
    }

    @Override
    public synchronized int getSizeInBytes() {
        return this.isClosed() ? 0 : this.mImageResult.getImage().getSizeInBytes();
    }

    @Override
    public boolean isStateful() {
        return true;
    }

    public synchronized AnimatedImageResult getImageResult() {
        return this.mImageResult;
    }

    public synchronized AnimatedImage getImage() {
        return this.isClosed() ? null : this.mImageResult.getImage();
    }
}

